/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.tools.util;

import br.com.auttar.AuttarLogger;
import com.csi.ctfclient.excecoes.ExcecaoArquivoCorrompido;
import com.csi.ctfclient.excecoes.ExcecaoNaoLocal;
import com.csi.ctfclient.servicos.CTFClientCore;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.StreamCorruptedException;
import java.nio.file.FileAlreadyExistsException;
import java.util.HashMap;

public class PersistenciaObjetos {
    public static final String CAMINHO_PADRAO_PERSISTENCIA = "arquivo.txt";
    private final AuttarLogger logger = CTFClientCore.getAuttarLoggerFactory().getLogger(PersistenciaObjetos.class);
    private HashMap<String, Object> hash;
    private String path;

    public PersistenciaObjetos(String path) throws ExcecaoNaoLocal {
        if (path != null) {
            File arquivo;
            this.path = path;
            if (path.lastIndexOf("/") != -1 && !(arquivo = new File(path.substring(0, path.lastIndexOf("/")))).exists() && !arquivo.mkdirs()) {
                this.logger.warn("N\u00e3o foi poss\u00edvel criar as pastas de " + arquivo.getAbsolutePath());
            }
        } else {
            this.path = CAMINHO_PADRAO_PERSISTENCIA;
        }
        if (new File(this.path).exists()) {
            try {
                this.load();
            }
            catch (ExcecaoArquivoCorrompido e) {
                this.hash = new HashMap();
            }
        } else {
            this.hash = new HashMap();
        }
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void save(String key, Object obj) {
        this.hash.put(key, obj);
    }

    public Object get(String key) {
        if (this.hash == null) {
            return null;
        }
        Object obj = this.hash.get(key);
        return obj;
    }

    public void persist(boolean overwrite) throws ExcecaoNaoLocal {
        try {
            File file;
            if (!overwrite && (file = new File(this.path)).exists()) {
                throw new FileAlreadyExistsException(this.path);
            }
            ObjectOutputStream output = new ObjectOutputStream(new FileOutputStream(this.path));
            output.writeObject(this.hash);
            output.close();
        }
        catch (Exception e) {
            throw new ExcecaoNaoLocal(e, "PO02", "Erro ao escrever arquivo de persistencia");
        }
    }

    public void load() throws ExcecaoNaoLocal, ExcecaoArquivoCorrompido {
        ObjectInputStream input = null;
        FileInputStream fileInput = null;
        try {
            try {
                fileInput = new FileInputStream(this.path);
                input = new ObjectInputStream(fileInput);
                Object obj = input.readObject();
                this.hash = (HashMap)obj;
            }
            catch (ClassCastException e) {
                this.hash = null;
                this.logger.error("Nao foi possivel realizar o cast do objeto lido a partir do arquivo persistido para um HashMap<String,Object>: " + e.getMessage());
                throw new ExcecaoNaoLocal(e, "PO03", "O objeto lido a partir do arquivo persistido n\u00e3o \u00e9 um HashMap");
            }
            catch (StreamCorruptedException e1) {
                File file = new File(this.path);
                this.logger.error(this.path + " deletado " + file.delete());
                throw new ExcecaoArquivoCorrompido();
            }
            catch (ClassNotFoundException e) {
                throw new ExcecaoNaoLocal(e, "PO04", "Erro de classe ao ler arquivo de persistencia");
            }
            catch (IOException e) {
                throw new ExcecaoNaoLocal(e, "PO05", "Erro de IO ao ler arquivo de persistencia");
            }
            finally {
                if (null != input) {
                    input.close();
                }
                if (null != fileInput) {
                    fileInput.close();
                }
            }
        }
        catch (IOException e) {
            throw new ExcecaoNaoLocal(e, "PO06", "Erro de IO ao fechar arquivo de persistencia");
        }
    }
}

