/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.tools.util.xml;

import br.com.auttar.AuttarLogger;
import com.csi.ctfclient.servicos.CTFClientCore;
import com.csi.ctfclient.tools.util.xml.ConfigConstants;
import com.csi.ctfclient.tools.util.xml.MultipleNamesFoundException;
import com.csi.ctfclient.tools.util.xml.NoSuchParameterException;
import com.csi.ctfclient.tools.util.xml.Parameter;
import com.csi.ctfclient.tools.util.xml.ParameterFilter;
import com.csi.ctfclient.tools.util.xml.ParameterSetFilter;
import java.util.LinkedList;
import java.util.List;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.IllegalAddException;
import org.jdom.filter.ElementFilter;
import org.jdom.filter.Filter;

public class ParameterSet
implements ConfigConstants {
    protected Element jdomElement;
    private AuttarLogger logger = CTFClientCore.getAuttarLoggerFactory().getLogger(ParameterSet.class);

    public ParameterSet(String name) {
        this.jdomElement = new Element("ParameterSet");
        this.jdomElement.setAttribute("name", name);
    }

    protected ParameterSet(Element jdomElement) {
        this.jdomElement = jdomElement;
    }

    public synchronized Parameter getParameter(String name) throws MultipleNamesFoundException, NoSuchParameterException {
        List<Filter> childParams = this.getFilter(new ParameterFilter(name));
        if (childParams.size() > 1) {
            throw new MultipleNamesFoundException(name, this.getIdentity());
        }
        if (childParams.size() == 0) {
            throw new NoSuchParameterException(name, this.getIdentity());
        }
        return new Parameter((Element)childParams.get(0));
    }

    public synchronized List<Parameter> getParameters(String name) throws NoSuchParameterException {
        List<Filter> childParams = this.getFilter(new ParameterFilter(name));
        if (childParams.size() == 0 && name != null) {
            throw new NoSuchParameterException(name, this.getIdentity());
        }
        LinkedList<Parameter> returnList = new LinkedList<Parameter>();
        for (Element element : childParams) {
            returnList.add(new Parameter(element));
        }
        return returnList;
    }

    public synchronized ParameterSet getParameterSet(String name) throws MultipleNamesFoundException, NoSuchParameterException {
        List<Filter> childParamSets = this.getFilter(new ParameterSetFilter(name));
        if (childParamSets.size() > 1) {
            throw new MultipleNamesFoundException(name, this.getIdentity());
        }
        if (childParamSets.size() == 0) {
            throw new NoSuchParameterException(name, this.getIdentity());
        }
        return new ParameterSet((Element)childParamSets.get(0));
    }

    public synchronized List<ParameterSet> getParameterSets(String name) throws NoSuchParameterException {
        List<Filter> childParamSets = this.getFilter(new ParameterSetFilter(name));
        if (childParamSets.size() == 0 && name != null) {
            throw new NoSuchParameterException(name, this.getIdentity());
        }
        LinkedList<ParameterSet> returnList = new LinkedList<ParameterSet>();
        for (Element element : childParamSets) {
            returnList.add(new ParameterSet(element));
        }
        return returnList;
    }

    public List<Parameter> getAllParameters() {
        List<Parameter> returnList;
        try {
            returnList = this.getParameters(null);
        }
        catch (NoSuchParameterException e) {
            returnList = new LinkedList<Parameter>();
        }
        return returnList;
    }

    public List<ParameterSet> getAllParameterSets() {
        List<ParameterSet> returnList;
        try {
            returnList = this.getParameterSets(null);
        }
        catch (NoSuchParameterException e) {
            returnList = new LinkedList<ParameterSet>();
        }
        return returnList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void attachParameter(Parameter newParameter) {
        Element element = this.jdomElement;
        synchronized (element) {
            newParameter.attach(this.jdomElement);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void attachParameterSet(ParameterSet newParameterSet) {
        Element element = this.jdomElement;
        synchronized (element) {
            newParameterSet.attach(this.jdomElement);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ParameterSet detach() {
        Element element = this.jdomElement;
        synchronized (element) {
            this.jdomElement.detach();
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void attach(Element newParent) {
        Element element = this.jdomElement;
        synchronized (element) {
            try {
                newParent.addContent((Content)this.jdomElement);
            }
            catch (IllegalAddException e1) {
                try {
                    this.jdomElement.detach();
                    newParent.addContent((Content)this.jdomElement);
                }
                catch (IllegalAddException e2) {
                    throw new UnsupportedOperationException("Could not detach() jdom element: " + e2.getMessage());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getName() {
        String returnString;
        Element element = this.jdomElement;
        synchronized (element) {
            returnString = this.jdomElement.getAttributeValue("name");
        }
        return returnString;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setName(String newName) {
        Element element = this.jdomElement;
        synchronized (element) {
            this.jdomElement.setAttribute("name", newName);
        }
    }

    public Object clone() {
        Element newElement = (Element)this.jdomElement.clone();
        ParameterSet newParameterSet = new ParameterSet(newElement);
        return newParameterSet;
    }

    protected String getIdentity() {
        return this.jdomElement.getAttributeValue("name");
    }

    private List<Filter> getFilter(ElementFilter filter) {
        try {
            return this.jdomElement.getContent((Filter)filter);
        }
        catch (ClassCastException e) {
            this.logger.error("N\u00e3o foi poss\u00edvel realizar o cast do objeto para um Filter: " + e.getMessage());
            throw new ClassCastException(e.getCause().getMessage());
        }
    }
}

