/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.oned;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.NotFoundException;
import com.google.zxing.common.BitArray;
import com.google.zxing.oned.UPCEANReader;

public final class EAN13Reader
extends UPCEANReader {
    static final int[] FIRST_DIGIT_ENCODINGS = new int[]{0, 11, 13, 14, 19, 25, 28, 21, 22, 26};
    private final int[] decodeMiddleCounters = new int[4];

    private static void determineFirstDigit(StringBuilder resultString, int lgPatternFound) throws NotFoundException {
        for (int d = 0; d < 10; ++d) {
            if (lgPatternFound != FIRST_DIGIT_ENCODINGS[d]) continue;
            resultString.insert(0, (char)(48 + d));
            return;
        }
        throw NotFoundException.getNotFoundInstance();
    }

    @Override
    protected int decodeMiddle(BitArray row, int[] startRange, StringBuilder resultString) throws NotFoundException {
        int[] counters = this.decodeMiddleCounters;
        counters[0] = 0;
        counters[1] = 0;
        counters[2] = 0;
        counters[3] = 0;
        int end = row.getSize();
        int rowOffset = startRange[1];
        int lgPatternFound = 0;
        for (int x = 0; x < 6 && rowOffset < end; ++x) {
            int bestMatch = EAN13Reader.decodeDigit(row, counters, rowOffset, L_AND_G_PATTERNS);
            resultString.append((char)(48 + bestMatch % 10));
            for (int counter : counters) {
                rowOffset += counter;
            }
            if (bestMatch < 10) continue;
            lgPatternFound |= 1 << 5 - x;
        }
        EAN13Reader.determineFirstDigit(resultString, lgPatternFound);
        int[] middleRange = EAN13Reader.findGuardPattern(row, rowOffset, true, MIDDLE_PATTERN);
        rowOffset = middleRange[1];
        for (int x = 0; x < 6 && rowOffset < end; ++x) {
            int bestMatch = EAN13Reader.decodeDigit(row, counters, rowOffset, L_PATTERNS);
            resultString.append((char)(48 + bestMatch));
            for (int counter : counters) {
                rowOffset += counter;
            }
        }
        return rowOffset;
    }

    @Override
    BarcodeFormat getBarcodeFormat() {
        return BarcodeFormat.EAN_13;
    }
}

