/*
 * Decompiled with CFR 0.152.
 */
package net.glxn.qrgen.core.scheme;

import java.util.Map;
import net.glxn.qrgen.core.scheme.Schema;
import net.glxn.qrgen.core.scheme.SchemeUtil;

public class Bookmark
extends Schema {
    private static final String BEGIN_BOOKMARK = "MEBKM";
    private static final String URL = "URL";
    private static final String TITLE = "TITLE";
    private static final String LINE_SEPARATOR = ";";
    private String url;
    private String titel;

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getTitel() {
        return this.titel;
    }

    public void setTitel(String titel) {
        this.titel = titel;
    }

    @Override
    public Schema parseSchema(String code) {
        if (code == null || !code.startsWith(BEGIN_BOOKMARK)) {
            throw new IllegalArgumentException("this is not a valid Bookmark code: " + code);
        }
        Map<String, String> parameters = SchemeUtil.getParameters(code.replaceFirst("MEBKM:", ""), LINE_SEPARATOR, ":");
        if (parameters.containsKey(URL)) {
            this.setUrl(parameters.get(URL));
        }
        if (parameters.containsKey(TITLE)) {
            this.setTitel(parameters.get(TITLE));
        }
        return this;
    }

    @Override
    public String generateString() {
        StringBuilder sb = new StringBuilder();
        sb.append(BEGIN_BOOKMARK).append(":");
        if (this.url != null) {
            sb.append(URL).append(":").append(this.url).append(LINE_SEPARATOR);
        }
        if (this.titel != null) {
            sb.append(TITLE).append(":").append(this.titel).append(LINE_SEPARATOR);
        }
        sb.append(LINE_SEPARATOR);
        return sb.toString();
    }

    public String toString() {
        return this.generateString();
    }

    public static Bookmark parse(String code) {
        Bookmark bookmark = new Bookmark();
        bookmark.parseSchema(code);
        return bookmark;
    }
}

