/*
 * Decompiled with CFR 0.152.
 */
package net.glxn.qrgen.core.scheme;

import net.glxn.qrgen.core.scheme.Schema;

public class Girocode
extends Schema {
    protected static final String SERVICE_HEADER = "BCD";
    protected static final String FUNCTION_SEPA_CREDIT_TRANSFER = "SCT";
    protected static final String VERSION_1 = "001";
    private String name;
    private String iban;
    private String bic;
    private String amount;
    private String purposeCode;
    private String reference;
    private String text;
    private Encoding encoding;
    private String hint;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getIban() {
        return this.iban;
    }

    public void setIban(String iban) {
        this.iban = iban;
    }

    public String getBic() {
        return this.bic;
    }

    public void setBic(String bic) {
        this.bic = bic;
    }

    public String getAmount() {
        return this.amount;
    }

    public void setAmount(String amount) {
        this.amount = amount;
    }

    public String getPurposeCode() {
        return this.purposeCode;
    }

    public void setPurposeCode(String purposeCode) {
        this.purposeCode = purposeCode;
    }

    public String getReference() {
        return this.reference;
    }

    public void setReference(String reference) {
        this.reference = reference;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public Encoding getEncoding() {
        return this.encoding;
    }

    public void setEncoding(Encoding encoding) {
        this.encoding = encoding;
    }

    public String getHint() {
        return this.hint;
    }

    public void setHint(String hint) {
        this.hint = hint;
    }

    @Override
    public Schema parseSchema(String code) {
        if (code == null) {
            throw new IllegalArgumentException("this is not a valid Girocode: " + code);
        }
        String[] params = code.split("\r?\n");
        if (params.length < 6 || params[0].equals("SERVICE_HEADER")) {
            throw new IllegalArgumentException("this is not a valid Girocode: " + code);
        }
        this.setEncoding(Encoding.encodingFor(params[2]));
        this.setBic(params[4]);
        this.setName(params[5]);
        this.setIban(params[6]);
        if (params.length > 7) {
            this.setAmount(params[7]);
        }
        if (params.length > 8) {
            this.setPurposeCode(params[8]);
        }
        if (params.length > 9) {
            this.setReference(params[9]);
        }
        if (params.length > 10) {
            this.setText(params[10]);
        }
        if (params.length > 11) {
            this.setHint(params[11]);
        }
        return this;
    }

    @Override
    public String generateString() {
        StringBuilder bob = new StringBuilder();
        bob.append(SERVICE_HEADER).append("\n");
        bob.append(VERSION_1).append("\n");
        bob.append(this.nullToEmptyString((Object)this.getEncoding())).append("\n");
        bob.append(FUNCTION_SEPA_CREDIT_TRANSFER).append("\n");
        bob.append(this.nullToEmptyString(this.getBic())).append("\n");
        bob.append(this.nullToEmptyString(this.getName())).append("\n");
        bob.append(this.nullToEmptyString(this.getIban())).append("\n");
        bob.append(this.nullToEmptyString(this.getAmount())).append("\n");
        bob.append(this.nullToEmptyString(this.getPurposeCode())).append("\n");
        bob.append(this.nullToEmptyString(this.getReference())).append("\n");
        bob.append(this.nullToEmptyString(this.getText())).append("\n");
        bob.append(this.nullToEmptyString(this.getHint())).append("\n");
        return bob.toString();
    }

    private String nullToEmptyString(Object value) {
        return value == null ? "" : value.toString();
    }

    public String toString() {
        return this.generateString();
    }

    public static Girocode parse(String qrCode) {
        Girocode girocode = new Girocode();
        girocode.parseSchema(qrCode);
        return girocode;
    }

    public static enum Encoding {
        UTF_8,
        ISO_8859_1,
        ISO_8859_2,
        ISO_8859_4,
        ISO_8859_5,
        ISO_8859_7,
        ISO_8859_10,
        ISO_8859_15;


        public String value() {
            return "" + (this.ordinal() + 1);
        }

        public String toString() {
            return this.value();
        }

        public static Encoding encodingFor(String value) {
            for (Encoding encoding : Encoding.values()) {
                if (!encoding.value().equals(value)) continue;
                return encoding;
            }
            throw new IllegalArgumentException(String.format("unknown encoding value '%s'", value));
        }
    }
}

