/*
 * Decompiled with CFR 0.152.
 */
package net.glxn.qrgen.core.scheme;

import java.util.Map;
import net.glxn.qrgen.core.scheme.IEvent;
import net.glxn.qrgen.core.scheme.IFreeBusyTime;
import net.glxn.qrgen.core.scheme.IJournal;
import net.glxn.qrgen.core.scheme.IToDo;
import net.glxn.qrgen.core.scheme.Schema;
import net.glxn.qrgen.core.scheme.SchemeUtil;
import net.glxn.qrgen.core.scheme.SubSchema;

public class ICal
extends Schema {
    private static final String BEGIN_VCALENDAR = "BEGIN:VCALENDAR";
    private SubSchema subSchema;

    private ICal() {
    }

    public ICal(IEvent event) {
        this();
        this.subSchema = event;
    }

    public ICal(IToDo toDo) {
        this();
        this.subSchema = toDo;
    }

    public ICal(IJournal journal) {
        this();
        this.subSchema = journal;
    }

    public ICal(IFreeBusyTime freeBusyTime) {
        this();
        this.subSchema = freeBusyTime;
    }

    public static ICal parse(String code) {
        ICal iCal = new ICal();
        iCal.parseSchema(code);
        return iCal;
    }

    public SubSchema getSubSchema() {
        return this.subSchema;
    }

    @Override
    public Schema parseSchema(String code) {
        if (code == null || !code.startsWith(BEGIN_VCALENDAR)) {
            throw new IllegalArgumentException("this is not a valid ICal code: " + code);
        }
        Map<String, String> parameters = SchemeUtil.getParameters(code);
        if (parameters.containsKey("VEVENT")) {
            this.subSchema = IEvent.parse(parameters, code);
        }
        if (parameters.containsKey("VTODO")) {
            this.subSchema = IToDo.parse(parameters, code);
        }
        if (parameters.containsKey("VJOURNAL")) {
            this.subSchema = IJournal.parse(parameters, code);
        }
        if (parameters.containsKey("VFREEBUSY")) {
            this.subSchema = IFreeBusyTime.parse(parameters, code);
        }
        return this;
    }

    @Override
    public String generateString() {
        StringBuilder sb = new StringBuilder();
        sb.append(BEGIN_VCALENDAR).append("\n");
        sb.append("VERSION:2.0").append("\n");
        sb.append("PRODID:-//hacksw/handcal//NONSGML v1.0//EN").append("\n");
        if (this.subSchema != null) {
            sb.append(this.subSchema.generateString());
        }
        sb.append("\n").append("END:VCALENDAR");
        return sb.toString();
    }

    public String toString() {
        return this.generateString();
    }
}

