/*
 * Decompiled with CFR 0.152.
 */
package net.glxn.qrgen.core.scheme;

import java.util.Map;
import net.glxn.qrgen.core.scheme.SchemeUtil;
import net.glxn.qrgen.core.scheme.SubSchema;

public class IEvent
extends SubSchema {
    public static final String NAME = "VEVENT";
    private static final String BEGIN_EVENT = "BEGIN:VEVENT";
    private static final String UID = "UID";
    private static final String STAMP = "DTSTAMP";
    private static final String ORGANIZER = "ORGANIZER";
    private static final String START = "DTSTART";
    private static final String END = "DTEND";
    private static final String SUMMARY = "SUMMARY";
    private String uid;
    private String stamp;
    private String organizer;
    private String start;
    private String end;
    private String summary;

    public String getUid() {
        return this.uid;
    }

    public void setUid(String uid) {
        this.uid = uid;
    }

    public String getStamp() {
        return this.stamp;
    }

    public void setStamp(String stamp) {
        this.stamp = stamp;
    }

    public String getOrganizer() {
        return this.organizer;
    }

    public void setOrganizer(String organizer) {
        this.organizer = organizer;
    }

    public String getStart() {
        return this.start;
    }

    public void setStart(String start) {
        this.start = start;
    }

    public String getEnd() {
        return this.end;
    }

    public void setEnd(String end) {
        this.end = end;
    }

    public String getSummary() {
        return this.summary;
    }

    public void setSummary(String summary) {
        this.summary = summary;
    }

    @Override
    public SubSchema parseSchema(Map<String, String> parameters, String code) {
        if (parameters.containsKey(UID)) {
            this.setUid(parameters.get(UID));
        }
        if (parameters.containsKey(STAMP)) {
            this.setStamp(parameters.get(STAMP));
        }
        if (parameters.containsKey(START)) {
            this.setStart(parameters.get(START));
        }
        if (parameters.containsKey(END)) {
            this.setEnd(parameters.get(END));
        }
        if (parameters.containsKey(SUMMARY)) {
            this.setSummary(parameters.get(SUMMARY));
        }
        Map<String, String> param = SchemeUtil.getParameters(code);
        return this;
    }

    @Override
    public String generateString() {
        StringBuilder sb = new StringBuilder();
        sb.append(BEGIN_EVENT).append("\n");
        if (this.uid != null) {
            sb.append(UID).append(":").append(this.uid).append("\n");
        } else if (this.stamp != null) {
            sb.append(STAMP).append(":").append(this.stamp).append("\n");
        } else if (this.organizer != null) {
            sb.append(ORGANIZER).append(";").append(this.organizer).append("\n");
        } else if (this.start != null) {
            sb.append(START).append(":").append(this.start).append("\n");
        } else if (this.end != null) {
            sb.append(END).append(":").append(this.end).append("\n");
        } else if (this.summary != null) {
            sb.append(SUMMARY).append(":").append(this.summary).append("\n");
        }
        sb.append("\n").append("END:VEVENT");
        return sb.toString();
    }

    public String toString() {
        return this.generateString();
    }

    public static IEvent parse(Map<String, String> parameters, String code) {
        IEvent event = new IEvent();
        event.parseSchema(parameters, code);
        return event;
    }
}

