/*
 * Decompiled with CFR 0.152.
 */
package net.glxn.qrgen.core.scheme;

import java.util.Map;
import net.glxn.qrgen.core.scheme.Schema;
import net.glxn.qrgen.core.scheme.SchemeUtil;

public class MeCard
extends Schema {
    private static final String BEGIN_MECARD = "MECARD";
    private static final String NAME = "N";
    private static final String ADDRESS = "ADR";
    private static final String TEL = "TEL";
    private static final String EMAIL = "EMAIL";
    private static final String LINE_SEPARATOR = ";";
    private String name;
    private String address;
    private String telephone;
    private String email;

    public MeCard() {
    }

    public MeCard(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public String getTelephone() {
        return this.telephone;
    }

    public void setTelephone(String telephone) {
        this.telephone = telephone;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    @Override
    public Schema parseSchema(String code) {
        if (code == null || !code.startsWith(BEGIN_MECARD)) {
            throw new IllegalArgumentException("this is not a valid MeCard code: " + code);
        }
        Map<String, String> parameters = SchemeUtil.getParameters(code.replaceFirst("MECARD:", ""), LINE_SEPARATOR, ":");
        if (parameters.containsKey(NAME)) {
            this.setName(parameters.get(NAME));
        }
        if (parameters.containsKey(ADDRESS)) {
            this.setAddress(parameters.get(ADDRESS));
        }
        if (parameters.containsKey(TEL)) {
            this.setTelephone(parameters.get(TEL));
        }
        if (parameters.containsKey(EMAIL)) {
            this.setEmail(parameters.get(EMAIL));
        }
        return this;
    }

    @Override
    public String generateString() {
        StringBuilder sb = new StringBuilder();
        sb.append(BEGIN_MECARD).append(":");
        if (this.name != null) {
            sb.append(NAME).append(":").append(this.name).append(LINE_SEPARATOR);
        }
        if (this.address != null) {
            sb.append(ADDRESS).append(":").append(this.address).append(LINE_SEPARATOR);
        }
        if (this.telephone != null) {
            sb.append(TEL).append(":").append(this.telephone).append(LINE_SEPARATOR);
        }
        if (this.email != null) {
            sb.append(EMAIL).append(":").append(this.email).append(LINE_SEPARATOR);
        }
        sb.append(LINE_SEPARATOR);
        return sb.toString();
    }

    public String toString() {
        return this.generateString();
    }

    public static MeCard parse(String meCardCode) {
        MeCard meCard = new MeCard();
        meCard.parseSchema(meCardCode);
        return meCard;
    }
}

