/*
 * Decompiled with CFR 0.152.
 */
package com.linx.touchkeyboard;

import com.linx.touchkeyboard.configuration.KeyboardConfiguration;
import com.linx.touchkeyboard.event.TouchKeyEvent;
import com.linx.touchkeyboard.event.TouchKeyboardListener;
import com.linx.touchkeyboard.exception.KeyboardConfigException;
import com.linx.touchkeyboard.exception.TouchKeyboardExceptionMessages;
import com.linx.touchkeyboard.renderer.TouchKeyboardKey;
import com.linx.touchkeyboard.renderer.TouchKeyboardRenderer;
import com.linx.touchkeyboard.util.TouchKeyboardXstreamUtil;
import java.awt.Component;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TouchKeyboard
implements EventHandler<ActionEvent>,
TouchKeyboardExceptionMessages {
    private TouchKeyboardRenderer renderer;
    private List<TouchKeyboardListener> listeners = new ArrayList<TouchKeyboardListener>();
    private Component componentFocus;
    private Logger logger = LoggerFactory.getLogger(TouchKeyboard.class);

    public void setComponentFocus(Component component) {
        this.componentFocus = component;
    }

    public void configure(File file, String string, JFrame jFrame, String string2) throws KeyboardConfigException {
        if (file == null || !file.exists()) {
            throw new KeyboardConfigException("Arquivo com layouts do Teclado Touch n\u00e3o encontrado!");
        }
        this.logger.debug("Carregando configura\u00e7\u00f5es do arquivo (" + file.getAbsolutePath() + ") ...");
        KeyboardConfiguration keyboardConfiguration = TouchKeyboardXstreamUtil.loadKeyboardConfiguration(file);
        this.logger.debug("Configura\u00e7\u00f5es carregadas.");
        if (new File(string).exists()) {
            this.logger.debug("Definindo estilo do teclado...");
            keyboardConfiguration.setStyleFilePath(string);
            this.logger.debug("Estilo do teclado definido.");
        }
        if (jFrame == null) {
            throw new KeyboardConfigException("Frame destino n\u00e3o informado!");
        }
        this.logger.debug("Instanciando renderizador do teclado...");
        this.renderer = new TouchKeyboardRenderer(keyboardConfiguration, jFrame, this);
        this.logger.debug("Renderizador do teclado inicado.");
        SwingUtilities.invokeLater(this.renderer);
        this.logger.debug("Definindo layout " + string2 + " como padr\u00e3o...");
        this.renderer.setLayout(string2);
        this.logger.debug("Layout definido.");
    }

    public void show() {
        this.renderer.getKeyboardPanel().setVisible(true);
    }

    public void hide() {
        this.renderer.getKeyboardPanel().setVisible(false);
    }

    public void setEnabled(boolean bl) {
        this.renderer.getKeyboardPanel().setEnabled(bl);
    }

    public boolean isVisible() {
        return this.renderer.getKeyboardPanel().isVisible();
    }

    public void setLayout(String string) {
        this.renderer.setLayout(string);
    }

    public void addListener(TouchKeyboardListener touchKeyboardListener) {
        this.listeners.add(touchKeyboardListener);
    }

    public void removeListener(TouchKeyboardListener touchKeyboardListener) {
        this.listeners.remove(touchKeyboardListener);
    }

    public void setFocusTarget() {
        if (this.componentFocus != null) {
            this.componentFocus.requestFocus();
        }
    }

    public void handle(ActionEvent actionEvent) {
        TouchKeyboardKey touchKeyboardKey = (TouchKeyboardKey)((Object)actionEvent.getSource());
        this.logger.debug("Evento recebido da tecla " + touchKeyboardKey.getText());
        TouchKeyEvent touchKeyEvent = new TouchKeyEvent();
        touchKeyEvent.setKeyCode(touchKeyboardKey.getKey().getKeyCode());
        touchKeyEvent.setCharCode(touchKeyboardKey.getKey().getKeyChar());
        touchKeyEvent.setModifiers(0);
        this.logger.debug("Key code: " + touchKeyboardKey.getKey().getKeyCode());
        this.logger.debug("Key char: " + touchKeyboardKey.getKey().getKeyChar());
        this.logger.debug("Key type: " + (Object)((Object)touchKeyboardKey.getKey().getType()));
        for (TouchKeyboardListener touchKeyboardListener : this.listeners) {
            this.logger.debug("Notificando ouvindo do evento: " + touchKeyboardListener.getClass().getName());
            touchKeyboardListener.keyTouched(touchKeyEvent);
        }
        this.logger.debug("Definindo foco no componente.");
        this.setFocusTarget();
    }
}

