/*
 * Decompiled with CFR 0.152.
 */
package com.linx.touchkeyboard.util.configuration;

import java.util.ArrayList;
import java.util.List;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonBuilder;
import javafx.scene.control.Label;
import javafx.scene.control.LabelBuilder;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.VBoxBuilder;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import javafx.stage.Window;

public class AlertDialog
extends Stage {
    final Stage self = this;
    List<Node> childrenNodes = new ArrayList<Node>();
    private final String LABEL_DEFAULT_CONFIRMATION_BUTTON = "Ok";
    private final String LABEL_DEFAULT_WARNING_MESSAGE = "Por favor, adicione uma mensagem de aviso.";

    public AlertDialog(Stage stage, String string) {
        super(StageStyle.TRANSPARENT);
        this.initialize(stage, string, "Ok");
    }

    public AlertDialog(Stage stage, String string, String string2) {
        super(StageStyle.TRANSPARENT);
        this.initialize(stage, string, string2);
    }

    public AlertDialog(Stage stage, ArrayList<String> arrayList, String string) {
        super(StageStyle.TRANSPARENT);
        String string2 = "";
        for (String string3 : arrayList) {
            string2 = string2 + string3 + "\n\n";
        }
        this.initialize(stage, string2, string);
    }

    private void initialize(Stage stage, String string, String string2) {
        this.initModality(Modality.WINDOW_MODAL);
        this.initOwner((Window)stage);
        stage.getScene().getRoot().setEffect(null);
        this.childrenNodes.add((Node)this.configureWarningMessaging(string));
        this.childrenNodes.add((Node)this.configureConfirmButton(string2));
    }

    private Label configureWarningMessaging(String string) {
        if (string == null) {
            string = "Por favor, adicione uma mensagem de aviso.";
        }
        return ((LabelBuilder)LabelBuilder.create().text(string)).build();
    }

    private Button configureConfirmButton(String string) {
        if (string == null || string.trim().equalsIgnoreCase("")) {
            string = "Ok";
        }
        Button button = ((ButtonBuilder)((ButtonBuilder)ButtonBuilder.create().text(string)).defaultButton(true).onAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent actionEvent) {
                AlertDialog.this.getOwner().getScene().getRoot().setEffect(null);
                AlertDialog.this.self.close();
            }
        })).build();
        return button;
    }

    private void configureAlertDialog() {
        this.setScene(new Scene((Parent)((VBoxBuilder)((VBoxBuilder)VBoxBuilder.create().styleClass(new String[]{"modal-dialog"})).children(this.childrenNodes)).build(), (Paint)Color.TRANSPARENT));
        this.getScene().getStylesheets().add((Object)((Object)((Object)this)).getClass().getClassLoader().getResource("resource/alertdialog.css").toExternalForm());
        Parent parent = this.getScene().getRoot();
        final PositionControl positionControl = new PositionControl();
        parent.setOnMousePressed((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent mouseEvent) {
                positionControl.x = AlertDialog.this.self.getX() - mouseEvent.getScreenX();
                positionControl.y = AlertDialog.this.self.getY() - mouseEvent.getScreenY();
            }
        });
        parent.setOnMouseDragged((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent mouseEvent) {
                AlertDialog.this.self.setX(mouseEvent.getScreenX() + positionControl.x);
                AlertDialog.this.self.setY(mouseEvent.getScreenY() + positionControl.y);
            }
        });
    }

    public void showAndWait() {
        this.configureAlertDialog();
        super.showAndWait();
    }

    class PositionControl {
        double x;
        double y;

        PositionControl() {
        }
    }
}

