/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jpos.config.auto;

import com.ibm.jpos.config.auto.CashDrawerDevInfo;
import com.ibm.jpos.config.auto.DevInfo;
import com.ibm.jpos.config.auto.DevInfoVisitor;
import com.ibm.jpos.config.auto.HardTotalsDevInfo;
import com.ibm.jpos.config.auto.KeylockDevInfo;
import com.ibm.jpos.config.auto.LineDisplayDevInfo;
import com.ibm.jpos.config.auto.MICRDevInfo;
import com.ibm.jpos.config.auto.MSRDevInfo;
import com.ibm.jpos.config.auto.POSKeyboardDevInfo;
import com.ibm.jpos.config.auto.POSPrinterDevInfo;
import com.ibm.jpos.config.auto.ScaleDevInfo;
import com.ibm.jpos.config.auto.ScannerDevInfo;
import com.ibm.jpos.config.auto.ToneIndicatorDevInfo;
import jpos.config.JposEntry;
import jpos.config.simple.SimpleEntry;

class EntryFactoryV
extends DevInfoVisitor {
    private String logicalName = "";
    private JposEntry jposEntry = null;
    private static final byte POSPRINTER_SST_SBCS_SUBTYPE = 3;
    private static final byte POSPRINTER_SST_8MEG_SUBTYPE = 5;
    private static final byte POSPRINTER_SST_DBCS_SUBTYPE = 7;
    public static final String SERVICE_CLASS_PROP_NAME = "serviceClass";
    public static final String DEVICE_CATEGORY_PROP_NAME = "deviceCategory";
    public static final String VENDOR_URL_PROP_NAME = "vendorURL";
    public static final String VENDOR_NAME_PROP_NAME = "vendorName";
    public static final String PRODUCT_URL_PROP_NAME = "productURL";
    public static final String PRODUCT_DESCRIPTION_PROP_NAME = "productDescription";
    public static final String PRODUCT_NAME_PROP_NAME = "productName";
    public static final String JPOS_VERSION_PROP_NAME = "jposVersion";
    public static final String IBM_URL_VALUE = "http://www.ibm.com";
    public static final String IBM_NAME_VALUE = "IBM Corp.";
    public static final String IBM_JAVAPOS_URL_VALUE = "http://www2.clearlake.ibm.com/store/support/html/windowsdrivers.html";
    public static final String IBM_JAVAPOS_PRODUCT_DESCRIPTION_VALUE = "IBM's services for the JavaPOS (TM) standard";
    public static final String IBM_JAVAPOS_PRODUCT_NAME_VALUE = "IBM's Services for JavaPOS";
    public static final String JPOS_VERSION_VALUE = "1.5";

    EntryFactoryV() {
    }

    public JposEntry getLastEntry() {
        return this.jposEntry;
    }

    public void setLogicalName(String string) {
        this.logicalName = string;
    }

    public String getLogicalName() {
        return this.logicalName;
    }

    protected JposEntry createDefaultJposEntry() {
        return new SimpleEntry();
    }

    protected JposEntry createJposEntry(String string, String string2, String string3, String string4, DevInfo devInfo) {
        this.jposEntry = this.createDefaultJposEntry();
        this.jposEntry.addProperty("logicalName", (Object)string2);
        this.jposEntry.addProperty("serviceInstanceFactoryClass", (Object)"com.ibm.jpos.services.IBMJposServiceInstanceFactory");
        this.jposEntry.addProperty(DEVICE_CATEGORY_PROP_NAME, (Object)devInfo.getDevCatName());
        this.jposEntry.addProperty(VENDOR_URL_PROP_NAME, (Object)IBM_URL_VALUE);
        this.jposEntry.addProperty(VENDOR_NAME_PROP_NAME, (Object)IBM_NAME_VALUE);
        this.jposEntry.addProperty(PRODUCT_URL_PROP_NAME, (Object)IBM_JAVAPOS_URL_VALUE);
        this.jposEntry.addProperty(PRODUCT_DESCRIPTION_PROP_NAME, (Object)IBM_JAVAPOS_PRODUCT_DESCRIPTION_VALUE);
        this.jposEntry.addProperty(PRODUCT_NAME_PROP_NAME, (Object)IBM_JAVAPOS_PRODUCT_NAME_VALUE);
        this.jposEntry.addProperty(JPOS_VERSION_PROP_NAME, (Object)JPOS_VERSION_VALUE);
        this.jposEntry.addProperty(SERVICE_CLASS_PROP_NAME, (Object)string);
        this.jposEntry.addProperty("abstractionClass", (Object)string3);
        this.jposEntry.addProperty("impClass", (Object)string4);
        this.jposEntry.addProperty("posNslotNumber", (Object)Integer.toHexString(devInfo.getSlotNumber()));
        this.jposEntry.addProperty("posNportNumber", (Object)("0x" + Integer.toHexString(devInfo.getPortNumber())));
        this.jposEntry.addProperty("posNdeviceNumber", (Object)("0x" + Integer.toHexString(devInfo.getDeviceNumber())));
        this.jposEntry.addProperty("devCat", (Object)devInfo.getDevCatName());
        return this.jposEntry;
    }

    void visitCashDrawer(CashDrawerDevInfo cashDrawerDevInfo) {
        String string = "com.ibm.jpos.services.IBMCashDrawer";
        String string2 = "com.ibm.jpos.services.IBMCashDrawer";
        String string3 = "com.ibm.jpos.services.poss.IBMCashDrawerImp";
        this.createJposEntry(string, this.getLogicalName(), string2, string3, cashDrawerDevInfo);
    }

    void visitLineDisplay(LineDisplayDevInfo lineDisplayDevInfo) {
        String string = "com.ibm.jpos.services.";
        String string2 = "com.ibm.jpos.services.";
        String string3 = "com.ibm.jpos.services.poss.";
        switch (lineDisplayDevInfo.getDeviceNumber()) {
            case 34: 
            case 35: {
                string = string + "LineDisplayAnop0";
                string2 = string2 + "LineDisplayAnop0";
                string3 = string3 + "LineDisplayAnop0Imp";
                break;
            }
            case 36: 
            case 37: {
                if (lineDisplayDevInfo.getSubtype() == 1 || lineDisplayDevInfo.getSubtype() == 3) {
                    string = string + "LineDisplayAnop0";
                    string2 = string2 + "LineDisplayAnop0";
                    string3 = string3 + "LineDisplayAnop0Imp";
                    break;
                }
                string = string + "LineDisplayAnop20";
                string2 = string2 + "LineDisplayAnop20";
                string3 = string3 + "LineDisplayAnop20Imp";
                break;
            }
            case 38: 
            case 39: {
                string = string + "LineDisplayShopper";
                string2 = string2 + "LineDisplayShopper";
                string3 = string3 + "LineDisplayShopperImp";
                break;
            }
            case 42: 
            case 43: 
            case 44: 
            case 45: {
                if (lineDisplayDevInfo.getSubtype() == 17 || lineDisplayDevInfo.getSubtype() == 0) {
                    string = string + "LineDisplayApaJapan";
                    string2 = string2 + "LineDisplayApaJapan";
                    string3 = string3 + "LineDisplayApaJapanImp";
                    break;
                }
                if (lineDisplayDevInfo.getSubtype() != 18) break;
                string = string + "LineDisplayApaKorean";
                string2 = string2 + "LineDisplayApaKorean";
                string3 = string3 + "LineDisplayApaJapanImp";
                break;
            }
            default: {
                throw new RuntimeException("Device subtype not supported by IBM JavaPOS services: " + lineDisplayDevInfo.toString());
            }
        }
        this.createJposEntry(string, this.getLogicalName(), string2, string3, lineDisplayDevInfo);
    }

    void visitPOSKeyboard(POSKeyboardDevInfo pOSKeyboardDevInfo) {
        String string = "com.ibm.jpos.services.";
        String string2 = "com.ibm.jpos.services.";
        String string3 = "com.ibm.jpos.services.poss.";
        if (pOSKeyboardDevInfo.getDeviceNumber() == 129) {
            string = string + "IBMPOSKeyboard";
            string2 = string2 + "IBMPOSKeyboard";
            string3 = string3 + "POSKeyboardPS2Imp";
        } else {
            switch (pOSKeyboardDevInfo.getSubtype()) {
                case 5: {
                    string = string + "IBMKeyboardV";
                    string2 = string2 + "IBMKeyboardV";
                    string3 = string3 + "DBCSPOSKeyboardImp";
                    break;
                }
                case 6: {
                    string = string + "IBMKeyboardPLU";
                    string2 = string2 + "IBMKeyboardPLU";
                    string3 = string3 + "DBCSPOSKeyboardImp";
                    break;
                }
                default: {
                    string = string + "IBMPOSKeyboard";
                    string2 = string2 + "IBMPOSKeyboard";
                    string3 = string3 + "POSKeyboardRS485Imp";
                }
            }
        }
        this.createJposEntry(string, this.getLogicalName(), string2, string3, pOSKeyboardDevInfo);
    }

    void visitKeylock(KeylockDevInfo keylockDevInfo) {
        String string = "com.ibm.jpos.services.";
        String string2 = "com.ibm.jpos.services.";
        String string3 = "com.ibm.jpos.services.poss.";
        switch (keylockDevInfo.getSubtype()) {
            case 4: 
            case 5: 
            case 7: {
                string = string + "IBMDBCSKeylock";
                string2 = string2 + "IBMDBCSKeylock";
                string3 = string3 + "DBCSKeylockImp";
                break;
            }
            case 6: {
                break;
            }
            default: {
                string = string + "IBMKeylock";
                string2 = string2 + "IBMKeylock";
                string3 = string3 + "IBMKeylockImp";
            }
        }
        this.createJposEntry(string, this.getLogicalName(), string2, string3, keylockDevInfo);
    }

    void visitPOSPrinter(POSPrinterDevInfo pOSPrinterDevInfo) {
        String string = "com.ibm.jpos.services.";
        String string2 = "com.ibm.jpos.services.";
        String string3 = "com.ibm.jpos.services.poss.";
        switch (pOSPrinterDevInfo.getDeviceNumber()) {
            case 52: {
                string = string + "POSPrinter4";
                string2 = string2 + "POSPrinter4";
                string3 = string3 + "POSPrinter4Imp";
                break;
            }
            case 53: {
                if (pOSPrinterDevInfo.getSubtype() == 3 || pOSPrinterDevInfo.getSubtype() == 5 || pOSPrinterDevInfo.getSubtype() == 7) {
                    string = string + "POSPrinter4610SST";
                    string2 = string2 + "POSPrinter4610SST";
                    string3 = string3 + "POSPrinter4610SSTImp";
                    break;
                }
                string = string + "POSPrinter4610";
                string2 = string2 + "POSPrinter4610";
                string3 = string3 + "POSPrinter4610Imp";
                break;
            }
            case 50: 
            case 55: {
                string = string + "POSPrinter4689";
                string2 = string2 + "POSPrinter4689";
                string3 = string3 + "POSPrinter4689Imp";
                break;
            }
            default: {
                throw new RuntimeException("Device subtype not supported by IBM JavaPOS services: " + pOSPrinterDevInfo.toString());
            }
        }
        this.createJposEntry(string, this.getLogicalName(), string2, string3, pOSPrinterDevInfo);
    }

    void visitMICR(MICRDevInfo mICRDevInfo) {
        String string = "com.ibm.jpos.services.IBMMICR";
        String string2 = "com.ibm.jpos.services.IBMMICR";
        String string3 = "com.ibm.jpos.services.poss.IBMMICRImp";
        this.createJposEntry(string, this.getLogicalName(), string2, string3, mICRDevInfo);
    }

    void visitMSR(MSRDevInfo mSRDevInfo) {
        String string = "com.ibm.jpos.services.IBMMSR";
        String string2 = "com.ibm.jpos.services.IBMMSR";
        String string3 = "com.ibm.jpos.services.poss.POSSMSRServiceImp";
        this.createJposEntry(string, this.getLogicalName(), string2, string3, mSRDevInfo);
    }

    void visitScanner(ScannerDevInfo scannerDevInfo) {
        String string = "com.ibm.jpos.services.";
        String string2 = "com.ibm.jpos.services.";
        String string3 = "com.ibm.jpos.services.poss.";
        switch (scannerDevInfo.getDeviceNumber()) {
            case 66: {
                string = string + "ScannerHHBCR_1";
                string2 = string2 + "ScannerHHBCR_1";
                string3 = string3 + "ScannerHHBCR_1Imp";
                break;
            }
            case 74: 
            case 75: {
                string = string + "Scanner1520_A02";
                string2 = string2 + "Scanner1520_A02";
                string3 = string3 + "Scanner1520_A02Imp";
                break;
            }
            default: {
                throw new RuntimeException("Device subtype not supported by IBM JavaPOS services: " + scannerDevInfo.toString());
            }
        }
        this.createJposEntry(string, this.getLogicalName(), string2, string3, scannerDevInfo);
    }

    void visitScale(ScaleDevInfo scaleDevInfo) {
        String string = "com.ibm.jpos.services.";
        String string2 = "com.ibm.jpos.services.";
        String string3 = "com.ibm.jpos.services.poss.";
        switch (scaleDevInfo.getDeviceNumber()) {
            case 106: {
                string = string + "Scale4687";
                string2 = string2 + "Scale4687";
                string3 = string3 + "Scale4687Imp";
                break;
            }
            case 110: {
                string = string + "Scale4696";
                string2 = string2 + "Scale4696";
                string3 = string3 + "Scale4696Imp";
                break;
            }
            default: {
                throw new RuntimeException("Device subtype not supported by IBM JavaPOS services: " + scaleDevInfo.toString());
            }
        }
        this.createJposEntry(string, this.getLogicalName(), string2, string3, scaleDevInfo);
    }

    void visitHardTotals(HardTotalsDevInfo hardTotalsDevInfo) {
        String string = "com.ibm.jpos.services.IBMHardTotals";
        String string2 = "com.ibm.jpos.services.IBMHardTotals";
        String string3 = "com.ibm.jpos.services.poss.IBMHardTotalsImp";
        this.createJposEntry(string, this.getLogicalName(), string2, string3, hardTotalsDevInfo);
    }

    void visitToneIndicator(ToneIndicatorDevInfo toneIndicatorDevInfo) {
        String string = "com.ibm.jpos.services.IBMToneIndicator";
        String string2 = "com.ibm.jpos.services.IBMToneIndicator";
        String string3 = "com.ibm.jpos.services.poss.POSSToneIndicatorServiceImp";
        this.createJposEntry(string, this.getLogicalName(), string2, string3, toneIndicatorDevInfo);
    }
}

