/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jpos.config.auto;

import com.ibm.jpos.config.auto.DevInfo;
import com.ibm.jpos.config.auto.DevInfoVisitor;
import com.ibm.jpos.config.auto.PosDevId;

abstract class PosDevInfo
implements DevInfo {
    private String logicalName = "";
    private PosDevId posDevId = null;
    private boolean online = false;

    public PosDevInfo(PosDevId posDevId) {
        this.posDevId = posDevId;
        this.online = false;
    }

    public String toString() {
        return this.getDevCatName() + ":" + this.getPosDevId().getUniqueKey() + ": online = " + this.isOnline() + ", bus = " + (this.getBus() == 8 ? "USB" : "SIO");
    }

    public int getDeviceNumber() {
        return this.getPosDevId().getDeviceNumber();
    }

    public int getSlotNumber() {
        return this.getPosDevId().getSlotNumber();
    }

    public int getPortNumber() {
        return this.getPosDevId().getPortNumber();
    }

    public byte getType() {
        return this.getPosDevId().getType();
    }

    public byte getSubtype() {
        return this.getPosDevId().getSubtype();
    }

    public String getUniqueKey() {
        return this.getPosDevId().getUniqueKey();
    }

    public int getBus() {
        return this.getSlotNumber() == 8 ? 8 : 1;
    }

    public String getLogicalName() {
        return this.logicalName;
    }

    public boolean isOnline() {
        return this.online;
    }

    void setOnline(boolean bl) {
        this.online = bl;
    }

    void setLogicalName(String string) {
        this.logicalName = string;
    }

    public abstract void accept(DevInfoVisitor var1);

    public abstract String getDevCatName();

    protected PosDevId getPosDevId() {
        return this.posDevId;
    }
}

