/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jpos.services;

import com.ibm.jpos.services.CashDrawerServiceImp;
import com.ibm.jpos.services.CashDrawerServiceState;
import com.ibm.jpos.services.DeviceService;
import com.ibm.jpos.util.Timer;
import com.ibm.jpos.util.Timerable;
import jpos.JposException;
import jpos.services.CashDrawerService17;

public abstract class CashDrawerService
extends DeviceService
implements CashDrawerService17 {
    private Timer timer = null;
    private boolean timerExpired = false;
    public static final String CASHDRAWER_DEVCAT = "com.ibm.jpos.services.CashDrawerService";

    public CashDrawerService(CashDrawerServiceImp cashDrawerServiceImp) {
        super(cashDrawerServiceImp);
        this.setDeviceServiceState(new CashDrawerServiceState());
    }

    public boolean getCapStatus() throws JposException {
        CashDrawerServiceState cashDrawerServiceState;
        CashDrawerServiceState cashDrawerServiceState2 = cashDrawerServiceState = this.getCashDrawerServiceState();
        synchronized (cashDrawerServiceState2) {
            cashDrawerServiceState.isOpen();
            boolean bl = cashDrawerServiceState.getCapStatus();
            return bl;
        }
    }

    public boolean getCapStatusMultiDrawerDetect() throws JposException {
        CashDrawerServiceState cashDrawerServiceState;
        CashDrawerServiceState cashDrawerServiceState2 = cashDrawerServiceState = this.getCashDrawerServiceState();
        synchronized (cashDrawerServiceState2) {
            cashDrawerServiceState.isOpen();
            boolean bl = cashDrawerServiceState.getCapStatusMultiDrawerDetect();
            return bl;
        }
    }

    public synchronized void setDeviceEnabled(boolean bl) throws JposException {
        this.getDeviceServiceState().isOpen();
        this.getDeviceServiceImp().setDeviceEnabled(bl);
        this.getDeviceServiceState().setDeviceEnabled(bl);
    }

    public boolean getDrawerOpened() throws JposException {
        CashDrawerServiceState cashDrawerServiceState;
        CashDrawerServiceState cashDrawerServiceState2 = cashDrawerServiceState = this.getCashDrawerServiceState();
        synchronized (cashDrawerServiceState2) {
            cashDrawerServiceState.isOpenEnable();
            boolean bl = cashDrawerServiceState.getDrawerOpened();
            return bl;
        }
    }

    public synchronized void release() throws JposException {
        super.releaseSharable();
    }

    public synchronized void checkHealth(int n) throws JposException {
        this.getDeviceServiceState().isOpenEnable();
        this.checkClaimedService();
        this.checkCheckHealthArg(n);
        this.getDeviceServiceImp().checkHealth(n);
    }

    public synchronized void openDrawer() throws JposException {
        this.getCashDrawerServiceState().isOpenEnable();
        this.checkClaimedService();
        this.checkOnline();
        this.getCashDrawerServiceImp().openDrawer();
    }

    public synchronized void waitForDrawerClose(int n, int n2, int n3, int n4) throws JposException {
        CashDrawerServiceState cashDrawerServiceState = this.getCashDrawerServiceState();
        cashDrawerServiceState.checkNegativeValue(n2);
        cashDrawerServiceState.checkNegativeValue(n3);
        cashDrawerServiceState.checkNegativeValue(n4);
        cashDrawerServiceState.isOpenEnable();
        this.checkOnline();
        this.checkClaimedService();
        if (!cashDrawerServiceState.getDrawerOpened()) {
            return;
        }
        this.commonWaitForDrawerClose(n, n2, n3, n4);
    }

    public final String getDeviceCategory() {
        return CASHDRAWER_DEVCAT;
    }

    protected CashDrawerServiceState getCashDrawerServiceState() {
        return (CashDrawerServiceState)this.getDeviceServiceState();
    }

    protected CashDrawerServiceImp getCashDrawerServiceImp() {
        return (CashDrawerServiceImp)this.getDeviceServiceImp();
    }

    protected Timer getTimer() {
        if (this.timer == null) {
            this.timer = new Timer(new Timerable(){

                public void timerExpired() {
                    CashDrawerService.this.timerExpired = true;
                }
            });
        }
        return this.timer;
    }

    protected void commonWaitForDrawerClose(int n, int n2, int n3, int n4) throws JposException {
        this.timerExpired = false;
        Timer timer = this.getTimer();
        timer.reset();
        CashDrawerServiceState cashDrawerServiceState = (CashDrawerServiceState)this.getDeviceServiceState();
        timer.setTime(n);
        timer.start();
        while (cashDrawerServiceState.getDrawerOpened()) {
            if (this.timerExpired) {
                this.getCashDrawerServiceImp().beep(n2, n3, n4);
            }
            try {
                Thread.currentThread();
                Thread.sleep(this.getCashDrawerServiceImp().getWaitDrawerCloseWaitTime());
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.checkOnline();
        }
    }
}

