/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jpos.services;

import com.ibm.jpos.services.DeviceServiceState;
import com.ibm.jpos.services.InputDeviceServiceState;
import java.awt.Point;
import jpos.JposException;

public class SignatureCaptureServiceState
extends DeviceServiceState
implements InputDeviceServiceState {
    private boolean autoDisable = false;
    private int dataCount = 0;
    private boolean dataEventEnabled = false;
    private int maximumX = 0;
    private int maximumY = 0;
    private byte[] rawData = null;
    private boolean realTimeDataEnabled = false;
    private Point[] pointArray = null;
    private static final int SIGNATURECAPTURE_SERVICE_VERSION = 1007331;
    private static final int MAX_MAXIMUMX = 65536;
    private static final int MAX_MAXIMUMY = 65536;

    SignatureCaptureServiceState() {
    }

    public boolean getCapDisplay() {
        return false;
    }

    public boolean getCapRealTimeData() {
        return false;
    }

    public boolean getCapUserTerminated() {
        return false;
    }

    public synchronized boolean getAutoDisable() {
        return this.autoDisable;
    }

    public synchronized int getDataCount() {
        return this.dataCount;
    }

    public synchronized boolean getDataEventEnabled() {
        return !this.getCapRealTimeData() ? false : this.dataEventEnabled;
    }

    public synchronized int getMaximumX() {
        return this.maximumX;
    }

    public synchronized int getMaximumY() {
        return this.maximumY;
    }

    public synchronized Point[] getPointArray() {
        return this.pointArray;
    }

    public synchronized byte[] getRawData() {
        return this.rawData;
    }

    public synchronized boolean getRealTimeDataEnabled() {
        return this.realTimeDataEnabled;
    }

    public synchronized void setAutoDisable(boolean bl) {
        this.autoDisable = bl;
    }

    public synchronized void setDataCount(int n) throws JposException {
        this.checkNegativeValue(n);
        this.dataCount = n;
    }

    public synchronized void setDataEventEnabled(boolean bl) {
        this.dataEventEnabled = bl;
    }

    public synchronized void setMaximumX(int n) throws JposException {
        this.checkMaximumXValue(n);
        this.maximumX = n;
    }

    public synchronized void setMaximumY(int n) throws JposException {
        this.checkMaximumYValue(n);
        this.maximumY = n;
    }

    public synchronized void setPointArray(Point[] pointArray) throws JposException {
        this.checkNullValue(pointArray);
        this.pointArray = pointArray;
    }

    public synchronized void setRawData(byte[] byArray) throws JposException {
        this.checkNullValue(byArray);
        this.rawData = byArray;
    }

    synchronized void setRealTimeDataEnabled(boolean bl) {
        this.realTimeDataEnabled = bl;
    }

    public synchronized void setDeviceEnabled(boolean bl) {
        super.setDeviceEnabled(bl);
    }

    public void checkMaximumXValue(int n) throws JposException {
        this.checkNegativeValue(n);
        if (n > 65536) {
            throw new JposException(106);
        }
    }

    public void checkMaximumYValue(int n) throws JposException {
        this.checkNegativeValue(n);
        if (n > 65536) {
            throw new JposException(106);
        }
    }

    synchronized void initProperties() throws JposException {
        super.initProperties();
        this.setDeviceServiceVersion(1007331);
        this.setAutoDisable(false);
        this.setDataCount(0);
        this.setDataEventEnabled(false);
        this.setMaximumX(0);
        this.setMaximumY(0);
        this.setRawData(new byte[0]);
        this.setRealTimeDataEnabled(false);
        this.setPointArray(new Point[0]);
    }
}

