/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jpos.services.ibmprinter;

import java.awt.image.ImageConsumer;
import java.awt.image.ImageProducer;
import java.awt.image.MemoryImageSource;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Vector;

class BmpImageProducer
implements ImageProducer {
    private String spec = null;
    private ImageProducer ip = null;
    private Vector consumers = new Vector();

    public BmpImageProducer(String string) {
        this.spec = string;
    }

    public synchronized void addConsumer(ImageConsumer imageConsumer) {
        if (!this.consumers.contains(imageConsumer)) {
            this.consumers.add(imageConsumer);
            try {
                this.ip.addConsumer(imageConsumer);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public synchronized boolean isConsumer(ImageConsumer imageConsumer) {
        return this.consumers.contains(imageConsumer);
    }

    public synchronized void removeConsumer(ImageConsumer imageConsumer) {
        this.consumers.remove(imageConsumer);
        try {
            this.ip.removeConsumer(imageConsumer);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public synchronized void requestTopDownLeftRightResend(ImageConsumer imageConsumer) {
        try {
            this.getImageProducer().requestTopDownLeftRightResend(imageConsumer);
        }
        catch (Exception exception) {
            imageConsumer.imageComplete(1);
        }
    }

    /*
     * Unable to fully structure code
     */
    public synchronized void startProduction(ImageConsumer var1_1) {
        block3: {
            try {
                this.getImageProducer(var1_1).startProduction(var1_1);
                break block3;
            }
            catch (Exception var2_2) {
                var3_3 = this.consumers.elements();
                ** while (var3_3.hasMoreElements())
            }
lbl-1000:
            // 1 sources

            {
                ((ImageConsumer)var3_3.nextElement()).imageComplete(1);
                continue;
            }
        }
    }

    private ImageProducer getImageProducer(ImageConsumer imageConsumer) {
        if (imageConsumer != null && !this.consumers.contains(imageConsumer)) {
            this.consumers.add(imageConsumer);
        }
        return this.getImageProducer();
    }

    private ImageProducer getImageProducer() {
        if (this.ip == null) {
            BmpInputStream bmpInputStream = null;
            try {
                try {
                    bmpInputStream = new BmpInputStream(new URL(this.spec).openStream());
                }
                catch (MalformedURLException malformedURLException) {
                    bmpInputStream = new BmpInputStream(new FileInputStream(this.spec));
                }
                if (bmpInputStream.readChar() != 'B' || bmpInputStream.readChar() != 'M') {
                    throw new Exception("Not a BMP");
                }
                bmpInputStream.skip(16L);
                int n = bmpInputStream.readInt();
                int n2 = bmpInputStream.readInt();
                bmpInputStream.skip(2L);
                short s = bmpInputStream.readShort();
                int n3 = bmpInputStream.readInt();
                bmpInputStream.skip(20L);
                int[] nArray = new int[1 << s];
                int n4 = 0;
                while (n4 < nArray.length) {
                    nArray[n4] = bmpInputStream.readInt() | 0xFF000000;
                    ++n4;
                }
                if (n3 != 0) {
                    throw new Exception("Unsupported compression type");
                }
                if (s < 1 || s > 8) {
                    throw new Exception("Unsupported color depth");
                }
                int[] nArray2 = new int[n2 * n];
                int n5 = 8 / s;
                int n6 = n / n5 + (n % n5 != 0 ? 1 : 0);
                int n7 = n6 % 4 > 0 ? 4 - n6 % 4 : 0;
                int n8 = (1 << s) - 1;
                int[] nArray3 = new int[n5];
                int n9 = 0;
                while (n9 < n5) {
                    nArray3[n9] = 8 - (n9 + 1) * s;
                    ++n9;
                }
                int n10 = 0;
                int n11 = 0;
                int n12 = n2 - 1;
                while (n12 >= 0) {
                    int n13 = n12 * n;
                    int n14 = 0;
                    while (n14 < n) {
                        if (n14 % n5 == 0) {
                            n10 = 0;
                            n11 = bmpInputStream.read();
                        }
                        nArray2[n13++] = nArray[n11 >> nArray3[n10++] & n8];
                        ++n14;
                    }
                    bmpInputStream.skip(n7);
                    --n12;
                }
                this.ip = new MemoryImageSource(n, n2, nArray2, 0, n);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.ip != null) {
                Enumeration enumeration = this.consumers.elements();
                while (enumeration.hasMoreElements()) {
                    this.ip.addConsumer((ImageConsumer)enumeration.nextElement());
                }
            }
        }
        return this.ip;
    }

    private class BmpInputStream
    extends BufferedInputStream {
        public BmpInputStream(InputStream inputStream) {
            super(inputStream);
        }

        public int readInt() throws IOException {
            return this.read() & 0xFF | (this.read() & 0xFF) << 8 | (this.read() & 0xFF) << 16 | (this.read() & 0xFF) << 24;
        }

        public short readShort() throws IOException {
            return (short)(this.read() & 0xFF | (this.read() & 0xFF) << 8);
        }

        public char readChar() throws IOException {
            return (char)(this.read() & 0xFF);
        }
    }
}

