/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jpos.services.poss;

import com.ibm.jpos.services.POSPrinterServiceState;
import com.ibm.jpos.services.ibmprinter.CacheVector;
import com.ibm.jpos.services.ibmprinter.PrintBitmapUtil;
import com.ibm.jpos.services.ibmprinter.PrintDataParseException;
import com.ibm.jpos.services.ibmprinter.PrinterFont;
import com.ibm.jpos.services.ibmprinter.SetBitmapData;
import com.ibm.jpos.services.poss.POSSPrintDataCompiler;
import com.ibm.jpos.util.ByteBuffer;
import com.ibm.jpos.util.Tracer;
import com.ibm.poss.Printer;
import jpos.JposException;
import jpos.POSPrinterConst;

public class POSPrinter4610POSSPrintDataCompiler
extends POSSPrintDataCompiler
implements POSPrinterConst,
Printer {
    private static final String className = "POSPrinter4610POSSPrintDataCompiler";
    private PrinterFont selectedPrinterFont = null;

    POSPrinter4610POSSPrintDataCompiler(POSPrinterServiceState pOSPrinterServiceState) throws JposException {
        super(pOSPrinterServiceState);
    }

    public byte[] compile(int n, String string, int n2, PrintBitmapUtil printBitmapUtil, PrinterFont[] printerFontArray) throws JposException {
        return super.compile(n, string, n2, printBitmapUtil, printerFontArray);
    }

    public void validate(int n, String string, int n2, PrintBitmapUtil printBitmapUtil, PrinterFont[] printerFontArray) throws JposException {
        super.validate(n, string, n2, printBitmapUtil, printerFontArray);
    }

    public PrinterFont getSelectedPrinterFont() {
        return this.selectedPrinterFont;
    }

    protected byte[] getPrologueBytes() throws PrintDataParseException, JposException {
        Tracer.trace((int)4, (String)className, (String)"getPrologueBytes()", (String)"Entry");
        PrinterFont[] printerFontArray = this.getPrinterFonts();
        ByteBuffer byteBuffer = new ByteBuffer();
        String string = "";
        int n = 0;
        int n2 = -1;
        switch (this.getStation()) {
            case 1: {
                string = "JrnLineChars";
                n = this.getServiceState().getJrnLineChars();
                break;
            }
            case 2: {
                string = "RecLineChars";
                n = this.getServiceState().getRecLineChars();
                break;
            }
            case 4: {
                string = "SlpLineChars";
                n = this.getServiceState().getSlpLineChars();
                break;
            }
            default: {
                throw new JposException(111);
            }
        }
        Tracer.trace((int)4, (String)className, (String)"getPrologueBytes()", (String)(string + " == " + n));
        int n3 = 0;
        while (n3 < printerFontArray.length) {
            if (printerFontArray[n3].station == this.getStation()) {
                if (printerFontArray[n3].lineChars == n) {
                    n2 = n3;
                    break;
                }
                if (printerFontArray[n3].lineChars > n && (n2 == -1 || printerFontArray[n2].lineChars > printerFontArray[n3].lineChars)) {
                    n2 = n3;
                }
            }
            ++n3;
        }
        if (n2 == -1) {
            throw new JposException(111);
        }
        this.selectedPrinterFont = printerFontArray[n2];
        switch (printerFontArray[n2].fontType) {
            case 2: {
                byteBuffer.append(27).append(58);
                Tracer.trace((int)4, (String)className, (String)"getPrologueBytes()", (String)"using spread font");
                break;
            }
            case 1: {
                byteBuffer.append(27).append(59);
                Tracer.trace((int)4, (String)className, (String)"getPrologueBytes()", (String)"using normal font");
                break;
            }
            case 3: {
                byteBuffer.append(27).append(60);
                Tracer.trace((int)4, (String)className, (String)"getPrologueBytes()", (String)"using small font");
                break;
            }
            case 5: {
                byteBuffer.append(27).append(61).append((byte)n);
                Tracer.trace((int)4, (String)className, (String)"getPrologueBytes()", (String)"using dbcs font");
            }
        }
        switch (this.getRotation()) {
            case 257: {
                this.reverseText();
                this.setInverted(true);
                byteBuffer.append(27).append(33).append(5);
                byteBuffer.append(27).append(33).append(6);
                break;
            }
            case 258: {
                this.reverseLines();
                this.setInverted(false);
                byteBuffer.append(27).append(33).append(133);
                byteBuffer.append(27).append(33).append(6);
                break;
            }
            case 259: {
                this.reverseText();
                this.reverseLines();
                this.setInverted(true);
                byteBuffer.append(27).append(33).append(5);
                byteBuffer.append(27).append(33).append(134);
                break;
            }
            default: {
                this.setInverted(false);
                byteBuffer.append(27).append(33).append(133);
                byteBuffer.append(27).append(33).append(134);
            }
        }
        Tracer.trace((int)4, (String)className, (String)"getPrologueBytes()", (String)"Exit");
        return byteBuffer.getBytes();
    }

    protected byte[] getNewlineBytes() {
        return new byte[]{10};
    }

    protected byte[] getCRBytes() throws JposException {
        return new byte[]{10};
    }

    protected byte[] getEmptyBytes() throws JposException {
        if (this.getStation() == 2) {
            throw new JposException(106, "partial line end with nothing!");
        }
        return new byte[]{10};
    }

    protected byte[] getFeedPaperCutAndStampBytes(int n) throws PrintDataParseException, JposException {
        byte[] byArray = this.getFeedAndPaperCutBytes(n);
        byte[] byArray2 = this.getFireStampBytes();
        int n2 = byArray.length + byArray2.length;
        byte[] byArray3 = new byte[n2];
        int n3 = 0;
        while (n3 < n2) {
            byArray3[n3] = n3 < byArray.length ? byArray[n3] : byArray2[n3 - byArray.length];
            ++n3;
        }
        return byArray3;
    }

    protected byte[] getFireStampBytes() throws PrintDataParseException, JposException {
        return this.getPrintBitmapBytes(1, -1);
    }

    protected byte[] getPrintBitmapBytes(int n, int n2) throws PrintDataParseException, JposException {
        byte by;
        byte[] byArray = new byte[]{};
        SetBitmapData setBitmapData = this.getSetBitmapData(this.getStation(), n);
        if (setBitmapData == null) {
            if (this.isValidating()) {
                throw new JposException(111);
            }
            return byArray;
        }
        switch (setBitmapData.getAlignment()) {
            case -2: {
                by = 1;
                break;
            }
            case -3: {
                by = 2;
                break;
            }
            default: {
                by = 0;
            }
        }
        try {
            byArray = by != 0 ? new byte[]{27, 67, 27, 27, 67, 97, 27, 67, by, 27, 112, 0, (byte)this.getPrintBitmapUtil().cacheVector.get((int)CacheVector.BITMAP, (int)this.getStation(), (int)n).index, 10, 27, 67, 27, 27, 67, 97, 27, 67, 0} : new byte[]{27, 112, 0, (byte)this.getPrintBitmapUtil().cacheVector.get((int)CacheVector.BITMAP, (int)this.getStation(), (int)n).index, 10};
        }
        catch (Exception exception) {
            throw new JposException(111);
        }
        return byArray;
    }

    protected byte[] getShadingBytes() throws PrintDataParseException, JposException {
        if (this.isValidating()) {
            throw new JposException(111);
        }
        return new byte[0];
    }

    protected byte[] getShadingBytes(int n) throws PrintDataParseException, JposException {
        if (this.isValidating()) {
            throw new JposException(111);
        }
        return new byte[0];
    }

    protected byte[] getNormalBytes() {
        return new byte[]{27, 70, 27, 33, -127, 27, 33, -126, 27, 33, -125, 27, 33, -124, 27, 33, -123};
    }
}

