/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jpos.services.poss;

import com.ibm.jpos.services.DeviceServiceAbstraction;
import com.ibm.jpos.services.POSPrinterServiceImp;
import com.ibm.jpos.services.ibmprinter.PrinterFont;
import com.ibm.jpos.services.poss.POSPrinter4610EImp;
import com.ibm.jpos.util.ByteEncoder;
import com.ibm.jpos.util.JposEntryInfo;
import com.ibm.jpos.util.Tracer;
import com.ibm.poss.PosArg;
import com.ibm.poss.PosDef;
import com.ibm.poss.PosException;
import jpos.JposException;
import jpos.POSPrinterConst;

public class POSPrinter4610SSTImp
extends POSPrinter4610EImp
implements PosDef,
POSPrinterServiceImp,
POSPrinterConst {
    private static final String className = "POSPrinter4610SSTImp";
    private boolean narrowPaper = false;

    protected POSPrinter4610SSTImp(DeviceServiceAbstraction deviceServiceAbstraction) throws JposException {
        super(deviceServiceAbstraction);
        Tracer.trace((int)4, (String)className, (String)"Constructor()", (String)"Entry");
        Tracer.trace((int)4, (String)className, (String)"Constructor()", (String)"Exit");
    }

    public void processDynamicCapabilities() throws JposException {
        int n;
        PosArg[] posArgArray;
        Tracer.trace((int)4, (String)className, (String)"processDynamicCapabilities()", (String)"Entry");
        boolean bl = false;
        JposEntryInfo jposEntryInfo = this.serviceState.getJposEntryInfo();
        if (jposEntryInfo != null && (posArgArray = (PosArg[])jposEntryInfo.getPropertyValue("colorMode")) != null) {
            n = Integer.decode((String)posArgArray);
            bl = n == 2;
        }
        Tracer.trace((int)4, (String)className, (String)"processDynamicCapabilities()", (String)("colorMode = " + bl));
        this.serviceState.setCapRec2Color(bl);
        if (bl) {
            this.serviceState.setCapRecColor(3);
            try {
                posArgArray = new PosArg[]{new PosArg("printColorMode", 1)};
                this.posDevice.ioctl(305, posArgArray);
            }
            catch (PosException posException) {
                throw new JposException(111, posException.getMessage(), (Exception)posException);
            }
        }
        try {
            posArgArray = new PosArg[]{new PosArg("crWidth", 0)};
            this.posDevice.ioctl(302, posArgArray);
            n = (Integer)posArgArray[0].getValue();
            if (n == 1) {
                this.narrowPaper = true;
                this.serviceState.setRecLineChars(30);
                this.serviceState.setRecLineWidth(400);
                this.serviceStateReset = false;
            }
        }
        catch (PosException posException) {
            throw new JposException(111, posException.getMessage(), (Exception)posException);
        }
        Tracer.trace((int)4, (String)className, (String)"processDynamicCapabilities()", (String)"Exit");
    }

    protected PrinterFont[] getPrinterFonts() throws JposException {
        Tracer.trace((int)4, (String)className, (String)"getPrinterFonts()", (String)"Entry");
        PrinterFont[] printerFontArray = null;
        try {
            int n = ByteEncoder.getCodePage((int)this.serviceState.getCharacterSet());
            switch (n) {
                case 949: 
                case 951: 
                case 1088: {
                    if (this.narrowPaper) {
                        printerFontArray = new PrinterFont[]{new PrinterFont(2, 26, 400, 1, 0, 34)};
                        if (!this.serviceStateReset) {
                            this.serviceState.setRecLineChars(26);
                            this.serviceStateReset = true;
                        }
                    } else {
                        printerFontArray = new PrinterFont[]{new PrinterFont(2, 38, 576, 1, 0, 34)};
                        if (!this.serviceStateReset) {
                            this.serviceState.setRecLineChars(38);
                            this.serviceStateReset = true;
                        }
                    }
                    break;
                }
                case 932: 
                case 950: 
                case 1381: {
                    if (this.narrowPaper) {
                        printerFontArray = new PrinterFont[]{new PrinterFont(2, 26, 400, 5, 0, 34), new PrinterFont(2, 30, 400, 5, 0, 34), new PrinterFont(2, 33, 400, 5, 0, 34)};
                        if (!this.serviceStateReset) {
                            this.serviceState.setRecLineChars(26);
                            this.serviceStateReset = true;
                        }
                    } else {
                        printerFontArray = new PrinterFont[]{new PrinterFont(2, 38, 576, 5, 0, 34), new PrinterFont(2, 44, 576, 5, 0, 34), new PrinterFont(2, 48, 576, 5, 0, 34)};
                        if (!this.serviceStateReset) {
                            this.serviceState.setRecLineChars(38);
                            this.serviceStateReset = true;
                        }
                    }
                    break;
                }
                default: {
                    if (this.narrowPaper) {
                        printerFontArray = new PrinterFont[]{new PrinterFont(2, 30, 400, 1, 0, 34), new PrinterFont(2, 23, 400, 2, 0, 34), new PrinterFont(2, 33, 400, 3, 0, 34), new PrinterFont(2, 40, 400, 4, 0, 34)};
                        break;
                    }
                    printerFontArray = new PrinterFont[]{new PrinterFont(2, 44, 576, 1, 0, 34), new PrinterFont(2, 34, 576, 2, 0, 34), new PrinterFont(2, 48, 576, 3, 0, 34), new PrinterFont(2, 57, 576, 4, 0, 34)};
                    break;
                }
            }
        }
        catch (Exception exception) {
            this.checkPrinterErrorCause();
            throw this.createJposException(exception);
        }
        Tracer.trace((int)4, (String)className, (String)"getPrinterFonts()", (String)"Exit");
        return printerFontArray;
    }

    public synchronized void setCharacterSet(int n) throws JposException {
        Tracer.trace((int)4, (String)className, (String)("setCharacterSet(" + n + ")"), (String)"Entry");
        super.setCharacterSet(n);
        try {
            this.serviceState.setCapSlpLeft90(false);
            this.serviceState.setSlpSidewaysMaxChars(0);
            this.serviceState.setSlpSidewaysMaxLines(0);
        }
        catch (Exception exception) {
            this.checkPrinterErrorCause();
            throw this.createJposException(exception);
        }
        Tracer.trace((int)4, (String)className, (String)"setCharacterSet()", (String)"Exit");
    }
}

