/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jpos.services.poss;

import com.ibm.jpos.services.DeviceServiceAbstraction;
import com.ibm.jpos.services.LineDisplayServiceImp;
import com.ibm.jpos.services.LineDisplayServiceState;
import com.ibm.jpos.services.ServiceInstanceImp;
import com.ibm.jpos.services.poss.POSSDeviceServiceImp;
import com.ibm.jpos.services.poss.POSSImpFactory;
import com.ibm.jpos.util.ByteEncoder;
import com.ibm.jpos.util.Tracer;
import com.ibm.poss.PosArg;
import com.ibm.poss.PosException;
import java.io.UnsupportedEncodingException;
import jpos.JposException;

public abstract class POSSLineDisplayServiceImp
extends POSSDeviceServiceImp
implements LineDisplayServiceImp {
    LineDisplayServiceState serviceState = null;
    boolean refresh = false;
    ByteEncoder be = null;
    char[][] displayBuffer;
    private static final String className = "POSSLineDisplayServiceImp";

    protected POSSLineDisplayServiceImp(DeviceServiceAbstraction deviceServiceAbstraction) throws JposException {
        super(deviceServiceAbstraction);
        this.serviceState = (LineDisplayServiceState)deviceServiceAbstraction.getDeviceServiceState();
    }

    protected final String getPOSSDeviceClass() {
        this.displayBuffer = new char[this.serviceState.getRows()][this.serviceState.getColumns()];
        int n = 0;
        while (n < this.serviceState.getRows()) {
            int n2 = 0;
            while (n2 < this.serviceState.getColumns()) {
                this.displayBuffer[n][n2] = 32;
                ++n2;
            }
            ++n;
        }
        return "PosDisplay";
    }

    public static ServiceInstanceImp createImp(DeviceServiceAbstraction deviceServiceAbstraction) throws JposException {
        return POSSImpFactory.createImp(deviceServiceAbstraction);
    }

    public void setDeviceEnabled(boolean bl) throws JposException {
        super.setDeviceEnabled(bl);
        try {
            if (bl) {
                int n = this.serviceState.getCharacterSet();
                this.be = new ByteEncoder(n == 998 ? 437 : n);
                int n2 = this.be.getCodePage();
                this.getPosDevice().setCodePage(n2);
            }
        }
        catch (PosException posException) {
            try {
                int n = this.getPosDevice().getCodePage();
                this.be = new ByteEncoder(n);
            }
            catch (Exception exception) {}
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new JposException(111, unsupportedEncodingException.getMessage(), (Exception)unsupportedEncodingException);
        }
    }

    public void setCharacterSet(int n) throws JposException {
        Tracer.trace((int)4, (String)className, (String)("setCharacterSet(" + n + ")"), (String)"Entry");
        int[] nArray = this.serviceState.getValidCharacterSets();
        int n2 = -1;
        if (n == 998) {
            n2 = 0;
        } else {
            int n3 = 0;
            while (n3 < nArray.length) {
                if (nArray[n3] == n) {
                    n2 = n3;
                    break;
                }
                ++n3;
            }
        }
        if (n2 == -1) {
            throw new JposException(106);
        }
        PosArg[] posArgArray = new PosArg[1];
        try {
            this.be = new ByteEncoder(n == 998 ? 437 : n);
            int n4 = this.be.getCodePage();
            this.getPosDevice().setCodePage(n4);
            if (this.refresh && this.be.isDBCSCodePage()) {
                String string = new String(this.displayBuffer[0]);
                int n5 = 1;
                while (n5 < this.serviceState.getRows()) {
                    string = string + new String(this.displayBuffer[n5]);
                    ++n5;
                }
                this.refresh = false;
                this.displayText(string, 0);
            }
            Tracer.trace((int)4, (String)className, (String)("CodePage = " + n4), (String)"Set");
        }
        catch (PosException posException) {
            if (posException.getErrorCode() == 317) {
                throw new JposException(108, posException.getMessage(), (Exception)posException);
            }
            throw new JposException(111, posException.getMessage(), (Exception)posException);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            Tracer.trace((int)4, (String)className, (String)"setcharset", (String)"Unsupported CODE PAGE EXCEPTION in Linedisplay");
            throw new JposException(111, "Codepage failure");
        }
        Tracer.trace((int)4, (String)className, (String)"setCharacterSet()", (String)"Exit");
    }

    public void setCurrentWindow(int n) throws JposException {
        Tracer.trace((int)4, (String)className, (String)("setCurrentWindow(" + n + ")"), (String)"Entry");
        if (n != 0) {
            throw new JposException(106);
        }
        Tracer.trace((int)4, (String)className, (String)"setCurrentWindow()", (String)"Exit");
    }

    public void setCursorUpdate(boolean bl) throws JposException {
    }

    public void setDeviceBrightness(int n) throws JposException {
        throw new JposException(106);
    }

    public void setInterCharacterWait(int n) throws JposException {
        throw new JposException(106);
    }

    public void setMarqueeFormat(int n) throws JposException {
        throw new JposException(106);
    }

    public void setMarqueeRepeatWait(int n) throws JposException {
        throw new JposException(106);
    }

    public void setMarqueeType(int n) throws JposException {
        throw new JposException(106);
    }

    public void setMarqueeUnitWait(int n) throws JposException {
        throw new JposException(106);
    }

    public void setCursorType(int n) throws JposException {
        throw new JposException(106);
    }

    public void setMapCharacterSet(boolean bl) throws JposException {
        throw new JposException(106);
    }

    public void setScreenMode(int n) throws JposException {
        throw new JposException(106);
    }

    public void clearDescriptors() throws JposException {
        Tracer.trace((int)4, (String)className, (String)"clearDescriptors()", (String)"Entry");
        PosArg[] posArgArray = new PosArg[]{new PosArg("displayLightsOn", 0)};
        try {
            this.getPosDevice().ioctl(305, posArgArray);
        }
        catch (PosException posException) {
            if (posException.getErrorCode() == 317) {
                throw new JposException(108, posException.getMessage(), (Exception)posException);
            }
            throw new JposException(111, posException.getMessage(), (Exception)posException);
        }
        Tracer.trace((int)4, (String)className, (String)"clearDescriptors()", (String)"Exit");
    }

    public void clearText() throws JposException {
        Tracer.trace((int)4, (String)className, (String)"clearText()", (String)"Entry");
        int n = 0;
        while (n < this.serviceState.getDeviceRows()) {
            int n2 = 0;
            while (n2 < this.serviceState.getDeviceColumns()) {
                this.displayBuffer[n][n2] = 32;
                ++n2;
            }
            ++n;
        }
        try {
            this.getPosDevice().ioctl(4401);
        }
        catch (PosException posException) {
            if (posException.getErrorCode() == 317) {
                throw new JposException(108, posException.getMessage(), (Exception)posException);
            }
            throw new JposException(111, posException.getMessage(), (Exception)posException);
        }
        Tracer.trace((int)4, (String)className, (String)"clearText()", (String)"Entry");
    }

    public void createWindow(int n, int n2, int n3, int n4, int n5, int n6) throws JposException {
        throw new JposException(106);
    }

    public void destroyWindow() throws JposException {
        throw new JposException(106);
    }

    public int putDisplayBuffer(int[] nArray, int[] nArray2, byte[] byArray, int n) throws JposException {
        this.displayBuffer[nArray[0]][nArray2[0]] = (char)byArray[n];
        return 0;
    }

    /*
     * Unable to fully structure code
     */
    public void displayText(String var1_1, int var2_2) throws JposException {
        Tracer.trace((int)4, (String)"POSSLineDisplayServiceImp", (String)("displayText(" + var1_1 + ", " + var2_2 + ")"), (String)"Entry");
        var3_3 = this.be.getBytes(var1_1);
        var4_4 = this.serviceState.getRows();
        var5_5 = this.serviceState.getColumns();
        var6_6 = new int[]{this.serviceState.getCursorRow()};
        var7_7 = new int[]{this.serviceState.getCursorColumn()};
        var8_8 = 0;
        while (var8_8 < var3_3.length) {
            block12: {
                block11: {
                    if (var7_7[0] == var5_5) {
                        if (var6_6[0] < var4_4 - 1) {
                            var6_6[0] = var6_6[0] + 1;
                        } else {
                            this.scrollText(1, 1);
                        }
                        var7_7[0] = 0;
                    }
                    if (var3_3[var8_8] != 13) break block11;
                    var7_7[0] = 0;
                    ** GOTO lbl-1000
                }
                if (var3_3[var8_8] != 10) break block12;
                var7_7[0] = var5_5 + 1;
                ** GOTO lbl-1000
            }
            var9_9 = this.putDisplayBuffer(var6_6, var7_7, var3_3, var8_8);
            var7_7[0] = var7_7[0] + 1;
            if (var9_9 != 0) {
                ++var8_8;
                var7_7[0] = var7_7[0] + 1;
            } else if (var7_7[0] > var5_5) {
                if (var6_6[0] < var4_4 - 1) {
                    var6_6[0] = var6_6[0] + 1;
                    var7_7[0] = 0;
                } else if (var8_8 != var3_3.length - 1) {
                    this.scrollText(1, 1);
                    var7_7[0] = 0;
                }
            }
            ++var8_8;
        }
        if (this.serviceState.getCursorUpdate()) {
            this.serviceState.setCursorRow(var6_6[0]);
            this.serviceState.setCursorColumn(var7_7[0]);
        }
        this.updateDisplayFromBuffer();
        Tracer.trace((int)4, (String)"POSSLineDisplayServiceImp", (String)"displayText()", (String)"Exit");
    }

    private void updateDisplayFromBuffer() throws JposException {
        Tracer.trace((int)4, (String)className, (String)"updateDisplayFromBuffer()", (String)"Entry");
        PosArg[] posArgArray = new PosArg[]{new PosArg("displayCursor", 0)};
        try {
            this.getPosDevice().ioctl(305, posArgArray);
        }
        catch (PosException posException) {
            if (posException.getErrorCode() == 317) {
                throw new JposException(108, posException.getMessage(), (Exception)posException);
            }
            throw new JposException(111, posException.getMessage(), (Exception)posException);
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < this.serviceState.getRows()) {
            stringBuffer.append(new String(this.displayBuffer[n]));
            ++n;
        }
        try {
            this.getPosDevice().write(new String(stringBuffer));
        }
        catch (PosException posException) {
            if (posException.getErrorCode() == 317) {
                throw new JposException(108, posException.getMessage(), (Exception)posException);
            }
            throw new JposException(111, posException.getMessage(), (Exception)posException);
        }
        Tracer.trace((int)4, (String)className, (String)"updateDisplayFromBuffer()", (String)"Exit");
    }

    public void displayTextAt(int n, int n2, String string, int n3) throws JposException {
    }

    public void refreshWindow(int n) throws JposException {
        if (n != 0) {
            throw new JposException(106);
        }
    }

    public void setCursorColumn(int n) throws JposException {
    }

    public void setCursorRow(int n) throws JposException {
    }

    public void scrollText(int n, int n2) throws JposException {
        Tracer.trace((int)4, (String)className, (String)("scrollText(" + n + ", " + n2 + ")"), (String)"Entry");
        int n3 = this.serviceState.getRows();
        int n4 = this.serviceState.getColumns();
        char[] cArray = new char[n4];
        switch (n) {
            case 1: {
                int n5 = 0;
                while (n5 < n2) {
                    int n6 = 0;
                    while (n6 < n3 - 1) {
                        System.arraycopy(this.displayBuffer[n6 + 1], 0, this.displayBuffer[n6], 0, n4);
                        ++n6;
                    }
                    int n7 = 0;
                    while (n7 < n4) {
                        this.displayBuffer[n3 - 1][n7] = 32;
                        ++n7;
                    }
                    ++n5;
                }
                break;
            }
            case 2: {
                int n8 = 0;
                while (n8 < n2) {
                    int n9 = n3 - 1;
                    while (n9 > 0) {
                        System.arraycopy(this.displayBuffer[n9 - 1], 0, this.displayBuffer[n9], 0, n4);
                        --n9;
                    }
                    int n10 = 0;
                    while (n10 < n4) {
                        this.displayBuffer[0][n10] = 32;
                        ++n10;
                    }
                    ++n8;
                }
                break;
            }
            case 3: 
            case 4: {
                if (this.be.isDBCSCodePage()) {
                    this.refresh = true;
                }
                n = n == 3 ? n2 : -n2;
                int n11 = 0;
                while (n11 < n3) {
                    int n12;
                    char c;
                    System.arraycopy(this.displayBuffer[n11], 0, cArray, 0, this.displayBuffer[n11].length);
                    if (n >= cArray.length || -cArray.length >= n && n < 0) {
                        this.clearText();
                        return;
                    }
                    if (n > 0) {
                        c = cArray[n - 1];
                        System.arraycopy(cArray, n, cArray, 0, cArray.length - n);
                        n12 = 1;
                        while (n12 <= n) {
                            cArray[cArray.length - n12] = 32;
                            ++n12;
                        }
                    } else {
                        n12 = -n;
                        System.arraycopy(cArray, 0, cArray, n12, cArray.length - n12);
                        c = cArray[cArray.length - 1];
                        int n13 = 0;
                        while (n13 < n12) {
                            cArray[n13] = 32;
                            ++n13;
                        }
                    }
                    if (this.be.isDBCSCodePage() && this.be.isDBCSLeadByte((byte)c)) {
                        cArray[n > 0 ? 0 : cArray.length - 1] = 32;
                    }
                    System.arraycopy(cArray, 0, this.displayBuffer[n11], 0, n4);
                    ++n11;
                }
                break;
            }
            default: {
                throw new JposException(106);
            }
        }
        this.updateDisplayFromBuffer();
        Tracer.trace((int)4, (String)className, (String)"scrollText()", (String)"Exit");
    }

    public abstract void setDescriptor(int var1, int var2) throws JposException;
}

