/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jpos.util;

public class ByteBuffer {
    protected byte[] byteArray;
    protected int byteCount;
    protected int capacityIncrement;

    public ByteBuffer(int n, int n2) {
        this.byteArray = new byte[n];
        this.byteCount = 0;
        this.capacityIncrement = n2;
    }

    public ByteBuffer(int n) {
        this(n, 16);
    }

    public ByteBuffer() {
        this(16, 16);
    }

    public void setByteCount(int n) {
        if (n > this.byteArray.length) {
            byte[] byArray = new byte[n];
            System.arraycopy(this.byteArray, 0, byArray, 0, this.byteCount);
            this.byteArray = byArray;
        }
        int n2 = this.byteCount;
        while (n2 < n) {
            this.byteArray[n2] = 0;
            ++n2;
        }
        this.byteCount = n;
    }

    public int getByteCount() {
        return this.byteCount;
    }

    public ByteBuffer append(byte[] byArray) {
        if (this.byteCount + byArray.length > this.byteArray.length) {
            byte[] byArray2 = new byte[this.byteCount + byArray.length + this.capacityIncrement];
            System.arraycopy(this.byteArray, 0, byArray2, 0, this.byteCount);
            this.byteArray = byArray2;
        }
        System.arraycopy(byArray, 0, this.byteArray, this.byteCount, byArray.length);
        this.byteCount += byArray.length;
        return this;
    }

    public ByteBuffer append(byte[] byArray, int n, int n2) {
        if (this.byteCount + n2 > this.byteArray.length) {
            byte[] byArray2 = new byte[this.byteCount + n2 + this.capacityIncrement];
            System.arraycopy(this.byteArray, 0, byArray2, 0, this.byteCount);
            this.byteArray = byArray2;
        }
        System.arraycopy(byArray, n, this.byteArray, this.byteCount, n2);
        this.byteCount += n2;
        return this;
    }

    public ByteBuffer append(int n) {
        this.append((byte)n);
        return this;
    }

    public ByteBuffer append(byte by) {
        if (this.byteCount + 1 > this.byteArray.length) {
            byte[] byArray = new byte[this.byteCount + 1 + this.capacityIncrement];
            System.arraycopy(this.byteArray, 0, byArray, 0, this.byteCount);
            this.byteArray = byArray;
        }
        this.byteArray[this.byteCount++] = by;
        return this;
    }

    public ByteBuffer append(ByteBuffer byteBuffer) {
        if (this.byteCount + byteBuffer.getByteCount() > this.byteArray.length) {
            byte[] byArray = new byte[this.byteCount + byteBuffer.getByteCount() + this.capacityIncrement];
            System.arraycopy(this.byteArray, 0, byArray, 0, this.byteCount);
            this.byteArray = byArray;
        }
        System.arraycopy(byteBuffer.byteArray, 0, this.byteArray, this.byteCount, byteBuffer.getByteCount());
        this.byteCount += byteBuffer.getByteCount();
        return this;
    }

    public byte[] getBytes() {
        byte[] byArray = new byte[this.byteCount];
        System.arraycopy(this.byteArray, 0, byArray, 0, this.byteCount);
        return byArray;
    }

    public byte byteAt(int n) {
        if (n < this.byteCount) {
            return this.byteArray[n];
        }
        throw new ArrayIndexOutOfBoundsException();
    }
}

