/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jpos.util;

import jpos.config.JposEntry;

public final class JposEntryInfo {
    private JposEntry jposEntry = null;
    private String logicalName = null;
    private String impClassName = null;
    private String abstractionClassName = null;
    public static final String IMPCLASS_BC_ENTRY_NAME = "impClass";
    public static final String ABSTRACTIONCLASS_BC_ENTRY_NAME = "abstractionClass";

    public JposEntryInfo(String string, JposEntry jposEntry) {
        this.jposEntry = jposEntry;
        this.logicalName = string;
    }

    public JposEntry getJposEntry() {
        return this.jposEntry;
    }

    public String getLogicalName() {
        return this.logicalName;
    }

    public String getImpClassName() {
        if (this.impClassName == null) {
            this.searchForImpClassName();
        }
        return this.impClassName;
    }

    public String getAbstractionClassName() {
        if (this.abstractionClassName == null) {
            this.searchForAbstractionClassName();
        }
        return this.abstractionClassName;
    }

    public Object getPropertyValue(String string) {
        Object object = null;
        if (this.jposEntry.hasPropertyWithName(this.logicalName + "." + string)) {
            object = this.jposEntry.getPropertyValue(this.logicalName + "." + string);
        } else if (this.jposEntry.hasPropertyWithName(string)) {
            object = this.jposEntry.getPropertyValue(string);
        }
        return object;
    }

    public boolean hasPropertyWithName(String string) {
        return this.jposEntry.hasPropertyWithName(string);
    }

    private void searchForImpClassName() {
        this.impClassName = null;
        if (this.jposEntry.hasPropertyWithName(this.logicalName + "." + IMPCLASS_BC_ENTRY_NAME)) {
            this.impClassName = (String)this.jposEntry.getPropertyValue(this.logicalName + "." + IMPCLASS_BC_ENTRY_NAME);
        } else if (this.jposEntry.hasPropertyWithName(IMPCLASS_BC_ENTRY_NAME)) {
            this.impClassName = (String)this.jposEntry.getPropertyValue(IMPCLASS_BC_ENTRY_NAME);
        }
    }

    private void searchForAbstractionClassName() {
        this.abstractionClassName = null;
        if (this.jposEntry.hasPropertyWithName(this.logicalName + "." + ABSTRACTIONCLASS_BC_ENTRY_NAME)) {
            this.abstractionClassName = (String)this.jposEntry.getPropertyValue(this.logicalName + "." + ABSTRACTIONCLASS_BC_ENTRY_NAME);
        } else if (this.jposEntry.hasPropertyWithName(ABSTRACTIONCLASS_BC_ENTRY_NAME)) {
            this.abstractionClassName = (String)this.jposEntry.getPropertyValue(ABSTRACTIONCLASS_BC_ENTRY_NAME);
        }
    }
}

