/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.poss;

import com.ibm.poss.Device;
import com.ibm.poss.DeviceEventListener;
import com.ibm.poss.Errno;
import com.ibm.poss.Pos;
import com.ibm.poss.PosArg;
import com.ibm.poss.PosDef;
import com.ibm.poss.PosException;
import com.ibm.poss.PosQMsg;
import com.ibm.poss.PosScaleData;
import com.ibm.poss.Queue;
import com.ibm.poss.ShutdownHook;
import com.ibm.poss.SystemEventListener;
import java.util.Enumeration;
import java.util.Vector;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class PosSubsystem
extends Thread
implements Errno,
Device,
PosDef {
    private static boolean systemAvailable = true;
    private static int posInitErrno = 0;
    private static boolean trace = false;
    private static boolean debug = false;
    private static final boolean assert = true;
    private static Vector deviceEventListenerVector = new Vector();
    private static int posNreadTimeout = 0;

    private PosSubsystem() {
        if (trace) {
            System.err.println("--> Entry: PosSubsystem.PosSubsystem");
        }
        posNreadTimeout = 0;
        PosArg[] posArgArray = new PosArg[]{new PosArg("readTimeout", posNreadTimeout)};
        int n = 4;
        while (true) {
            try {
                PosSubsystem.initialize("PosSubsystem", "-", posArgArray);
            }
            catch (PosException posException) {
                if (n == 0) {
                    posInitErrno = posException.getErrorCode();
                    systemAvailable = false;
                    return;
                }
                try {
                    Thread.sleep(500L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                --n;
                continue;
            }
            break;
        }
        this.setName("PosSubsystem");
        this.start();
        if (trace) {
            System.err.println("<-- Exit : PosSubsystem.PosSubsystem");
        }
    }

    public static boolean isSystemAvailable() {
        return systemAvailable;
    }

    public static void addSystemEventListener(SystemEventListener systemEventListener) {
        if (trace) {
            System.err.println("--> Entry: PosSubsystem.addSystemEventListener");
        }
        SystemEventListenerManager.addSystemEventListener(systemEventListener);
        if (trace) {
            System.err.println("<-- Exit : PosSubsystem.addSystemEventListener");
        }
    }

    public static void removeSystemEventListener(SystemEventListener systemEventListener) {
        if (trace) {
            System.err.println("--> Entry: PosSubsystem.removeSystemEventListener");
        }
        SystemEventListenerManager.removeSystemEventListener(systemEventListener);
        if (trace) {
            System.err.println("<-- Exit : PosSubsystem.removeSystemEventListener");
        }
    }

    public static boolean isDeviceOnline(int n, int n2, int n3) {
        if (trace) {
            System.err.println("--> Entry: PosSubsystem.isDeviceOnline");
        }
        boolean bl = DeviceState.isOnline(n, n2, n3);
        if (trace) {
            System.err.println("<-- Exit : PosSubsystem.isDeviceOnline == " + (bl ? "true" : "false"));
        }
        return bl;
    }

    public void run() {
        if (trace) {
            System.err.println("--> Entry: PosSubsystem.run");
        }
        int n = -1;
        int n2 = -1;
        int n3 = -1;
        int n4 = -1;
        DeviceEventListener deviceEventListener = null;
        PosQMsg posQMsg = null;
        int n5 = 0;
        block47: while (true) {
            posQMsg = new PosQMsg();
            try {
                PosSubsystem.read(posQMsg);
                n5 = posQMsg.getMsg();
            }
            catch (PosException posException) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                switch (posException.getErrorCode()) {
                    case 337: {
                        n5 = -1;
                        break;
                    }
                    default: {
                        continue block47;
                    }
                }
            }
            if (trace) {
                System.err.print("\tPosSubsystem.run: event occurred: ");
                switch (n5) {
                    case 16897: {
                        System.err.println("POSM_KBD_STATUS_CHANGE");
                        break;
                    }
                    case 16898: {
                        System.err.println("POSM_KBD_WM_CHAR");
                        break;
                    }
                    case 16899: {
                        System.err.println("POSM_MSR_DATA_AVAIL");
                        break;
                    }
                    case 16900: {
                        System.err.println("POSM_PRN_CHASE_COMPLETE");
                        break;
                    }
                    case 16912: {
                        System.err.println("POSM_PRN_DATA_AVAIL");
                        break;
                    }
                    case 16913: {
                        System.err.println("POSM_PRN_FISCAL_ERROR");
                        break;
                    }
                    case 16914: {
                        System.err.println("POSM_PRN_FISCAL_STATUS");
                        break;
                    }
                    case 16901: {
                        System.err.println("POSM_PRN_PRINTER_ERROR");
                        break;
                    }
                    case 16902: {
                        System.err.println("POSM_PRN_STATUS_CHANGE");
                        break;
                    }
                    case 16903: {
                        System.err.println("POSM_RS232_BREAK_DETECTED");
                        break;
                    }
                    case 16904: {
                        System.err.println("POSM_RS232_DATA_AVAIL");
                        break;
                    }
                    case 16905: {
                        System.err.println("POSM_RS232_XMIT_ABORT");
                        break;
                    }
                    case 16906: {
                        System.err.println("POSM_RS232_XMIT_COMPLETE");
                        break;
                    }
                    case 16907: {
                        System.err.println("POSM_SCAN_DATA_AVAIL");
                        break;
                    }
                    case 16908: {
                        System.err.println("POSM_SYS_DEVICE_OFFLINE");
                        break;
                    }
                    case 16909: {
                        System.err.println("POSM_SYS_DEVICE_ONLINE");
                        break;
                    }
                    case 16915: {
                        System.err.println("POSM_SYS_DEVICE_RELEASED");
                        break;
                    }
                    case 16910: {
                        System.err.println("POSM_TILL_CLOSED");
                        break;
                    }
                    case 16911: {
                        System.err.println("POSM_TILL_OPENED");
                        break;
                    }
                    case 16918: {
                        System.err.println("POSM_TOUCH_DATA");
                        break;
                    }
                    case -1: {
                        System.err.println("Poison Cookie! AHHHHHHHH!!!!");
                        break;
                    }
                    default: {
                        System.err.println(n5 + "???");
                    }
                }
            }
            switch (n5) {
                case -1: {
                    Object object;
                    systemAvailable = false;
                    Enumeration enumeration = DeviceState.takeAllDevicesOffline();
                    while (enumeration.hasMoreElements()) {
                        posQMsg = (PosQMsg)enumeration.nextElement();
                        n = posQMsg.getMp1MiddleBottomByte() & 0xFF;
                        n2 = posQMsg.getMp1TopByte() & 0xFF;
                        n3 = posQMsg.getMp1MiddleTopByte() & 0xFF;
                        object = deviceEventListenerVector;
                        synchronized (object) {
                            enumeration = deviceEventListenerVector.elements();
                            while (enumeration.hasMoreElements()) {
                                deviceEventListener = (DeviceEventListener)enumeration.nextElement();
                                if (deviceEventListener.getPosNdeviceNumber() != n || deviceEventListener.getPosNslotNumber() != n2 || deviceEventListener.getPosNportNumber() != n3) continue;
                                try {
                                    deviceEventListener.deviceEventOccurred(posQMsg);
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                            }
                        }
                        SystemEventListenerManager.systemEventOccurred(posQMsg);
                    }
                    Pos.term();
                    return;
                }
                case 16908: 
                case 16909: {
                    Object object;
                    n = posQMsg.getMp1MiddleBottomByte() & 0xFF;
                    n2 = posQMsg.getMp1TopByte() & 0xFF;
                    n3 = posQMsg.getMp1MiddleTopByte() & 0xFF;
                    if (trace) {
                        System.err.println("\t\tPosNdeviceNumber : 0x" + Integer.toHexString(n));
                        System.err.println("\t\tPosNslotNumber   : 0x" + Integer.toHexString(n2));
                        System.err.println("\t\tPosNportNumber   : 0x" + Integer.toHexString(n3));
                    }
                    Enumeration enumeration = deviceEventListenerVector;
                    synchronized (enumeration) {
                        object = deviceEventListenerVector.elements();
                        while (object.hasMoreElements()) {
                            deviceEventListener = (DeviceEventListener)object.nextElement();
                            if (deviceEventListener.getPosNdeviceNumber() != n || deviceEventListener.getPosNslotNumber() != n2 || deviceEventListener.getPosNportNumber() != n3) continue;
                            try {
                                deviceEventListener.deviceEventOccurred(posQMsg);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                    }
                    SystemEventListenerManager.systemEventOccurred(posQMsg);
                    break;
                }
                default: {
                    Object object;
                    n4 = posQMsg.getMp1BottomByte() & 0xFF;
                    Enumeration enumeration = deviceEventListenerVector;
                    synchronized (enumeration) {
                        object = deviceEventListenerVector.elements();
                        while (object.hasMoreElements()) {
                            deviceEventListener = (DeviceEventListener)object.nextElement();
                            if (deviceEventListener.getDescriptor() != n4) continue;
                            deviceEventListener.deviceEventOccurred(posQMsg);
                            break;
                        }
                        break;
                    }
                }
            }
            Thread.yield();
        }
    }

    static PosQMsg getOnlinePosQMsg(int n, int n2, int n3) {
        if (trace) {
            System.err.println("--> Entry: PosSubsystem.getOnlinePosQMsg");
            System.err.println("<-- Exit : PosSubsystem.getOnlinePosQMsg");
        }
        return DeviceState.getOnlinePosQMsg((byte)n, (byte)n2, (byte)n3);
    }

    static void addDeviceEventListener(DeviceEventListener deviceEventListener) {
        if (trace) {
            System.err.println("--> Entry: PosSubsystem.addDeviceEventListener");
        }
        deviceEventListenerVector.addElement(deviceEventListener);
        if (trace) {
            System.err.println("<-- Exit : PosSubsystem.addDeviceEventListener");
        }
    }

    static void removeDeviceEventListener(DeviceEventListener deviceEventListener) {
        if (trace) {
            System.err.println("--> Entry: PosSubsystem.removeDeviceEventListener");
        }
        deviceEventListenerVector.removeElement(deviceEventListener);
        if (trace) {
            System.err.println("<-- Exit : PosSubsystem.removeDeviceEventListener");
        }
    }

    static synchronized void close(int n) throws PosException {
        if (trace) {
            System.err.println("--> Entry: PosSubsystem.close");
        }
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (Pos.close(n) == -1) {
            int n2 = PosSubsystem.remapErrno(Pos.errno());
            throw new PosException(n2, "PosClose == -1, errno == " + n2);
        }
        if (trace) {
            System.err.println("<-- Exit : PosSubsystem.close");
        }
    }

    static synchronized void initialize(String string, String string2, PosArg[] posArgArray) throws PosException {
        if (trace) {
            System.err.println("--> Entry: PosSubsystem.initialize");
        }
        if (Pos.initialize(string, string2, posArgArray) == -1) {
            throw new PosException(Pos.errno(), "PosInitialize == -1, errno == " + Pos.errno());
        }
        Runtime.getRuntime().addShutdownHook(new ShutdownHook());
        if (trace) {
            System.err.println("<-- Exit : PosSubsystem.initialize");
        }
    }

    static synchronized void ioctl(int n, int n2, PosArg[] posArgArray, int n3) throws PosException {
        if (trace) {
            System.err.println("--> Entry: PosSubsystem.ioctl");
        }
        if (Pos.ioctl(n, n2, posArgArray, n3) == -1) {
            int n4 = PosSubsystem.remapErrno(Pos.errno());
            throw new PosException(n4, "PosIOCtl == -1, errno == " + n4);
        }
        if (trace) {
            System.err.println("<-- Exit : PosSubsystem.ioctl");
        }
    }

    static synchronized int open(String string, String string2, PosArg[] posArgArray) throws PosException {
        int n;
        if (trace) {
            System.err.println("--> Entry: PosSubsystem.open");
        }
        if (trace) {
            System.err.println("\tPosSubsystem.open: PosArgs:");
            n = 0;
            while (n < posArgArray.length) {
                System.err.print("\t\t" + posArgArray[n].getName() + ": ");
                Object object = posArgArray[n].getValue();
                if (object instanceof Integer) {
                    System.err.println("0x" + Integer.toHexString((Integer)object));
                } else {
                    System.err.print(object);
                }
                ++n;
            }
        }
        if ((n = Pos.open(string, string2, posArgArray)) == -1) {
            if (posInitErrno != 0) {
                throw new PosException(317, "PosInitialize == -1, errno == " + posInitErrno);
            }
            int n2 = PosSubsystem.remapErrno(Pos.errno());
            throw new PosException(n2, "PosOpen == -1, errno == " + n2);
        }
        if (trace) {
            System.err.println("<-- Exit : PosSubsystem.open");
        }
        return n;
    }

    static synchronized int read(int n, byte[] byArray) throws PosException {
        int n2;
        if (trace) {
            System.err.println("--> Entry: PosSubsystem.read");
        }
        if ((n2 = Pos.read(n, byArray)) == -1) {
            int n3 = PosSubsystem.remapErrno(Pos.errno());
            throw new PosException(n3, "PosRead == -1, errno == " + n3);
        }
        if (trace) {
            System.err.println("<-- Exit : PosSubsystem.read");
        }
        return n2;
    }

    static synchronized int read(PosQMsg posQMsg) throws PosException {
        int n;
        if (trace) {
            System.err.println("--> Entry: PosSubsystem.read");
        }
        if ((n = Pos.read(posQMsg)) != posQMsg.length()) {
            int n2 = Pos.errno();
            throw new PosException(n2, "PosRead == -1, errno == " + n2);
        }
        if (trace) {
            System.err.println("<-- Exit : PosSubsystem.read");
        }
        return n;
    }

    static synchronized int read(int n, PosScaleData posScaleData) throws PosException {
        int n2;
        if (trace) {
            System.err.println("--> Entry: PosSubsystem.read");
        }
        if ((n2 = Pos.read(n, posScaleData)) == -1) {
            int n3 = PosSubsystem.remapErrno(Pos.errno());
            throw new PosException(n3, "PosRead == -1, errno == " + n3);
        }
        if (trace) {
            System.err.println("<-- Exit : PosSubsystem.read");
        }
        return n2;
    }

    static synchronized void term() throws PosException {
        if (trace) {
            System.err.println("--> Entry: PosSubsystem.term");
        }
        Pos.term();
        if (trace) {
            System.err.println("<-- Exit : PosSubsystem.term");
        }
    }

    static synchronized int write(int n, byte[] byArray, int n2) throws PosException {
        int n3;
        if (trace) {
            System.err.println("--> Entry: PosSubsystem.write");
        }
        if ((n3 = Pos.write(n, byArray, n2)) == -1) {
            int n4 = PosSubsystem.remapErrno(Pos.errno());
            throw new PosException(n4, "PosWrite == -1, errno == " + n4);
        }
        if (trace) {
            System.err.println("<-- Exit : PosSubsystem.write");
        }
        return n3;
    }

    static synchronized int write(int n, String string) throws PosException {
        int n2;
        if (trace) {
            System.err.println("--> Entry: PosSubsystem.write");
        }
        if ((n2 = Pos.write(n, string)) == -1) {
            int n3 = PosSubsystem.remapErrno(Pos.errno());
            throw new PosException(n3, "PosWrite == -1, errno == " + n3);
        }
        if (trace) {
            System.err.println("<-- Exit : PosSubsystem.write");
        }
        return n2;
    }

    static synchronized int write(int n, byte[] byArray) throws PosException {
        int n2;
        if (trace) {
            System.err.println("--> Entry: PosSubsystem.write");
        }
        if ((n2 = Pos.write(n, byArray)) == -1) {
            int n3 = PosSubsystem.remapErrno(Pos.errno());
            throw new PosException(n3, "PosWrite == -1, errno == " + n3);
        }
        if (trace) {
            System.err.println("<-- Exit : PosSubsystem.write");
        }
        return n2;
    }

    private static int remapErrno(int n) {
        switch (n) {
            case 337: {
                n = 317;
            }
        }
        return n;
    }

    static {
        if (!System.getProperty("TracePosSubsystem", "false").equals("false")) {
            trace = true;
        }
        if (!System.getProperty("DebugPosSubsystem", "false").equals("false")) {
            debug = true;
            trace = true;
        }
        if (trace) {
            System.err.println("--> Entry: PosSubsystem.static");
        }
        new PosSubsystem();
        if (trace) {
            System.err.println("<-- Exit : PosSubsystem.static");
        }
    }

    private static class SystemEventMessenger
    extends Thread
    implements PosDef {
        private Queue queue = new Queue();
        private SystemEventListener listener = null;

        SystemEventMessenger(SystemEventListener systemEventListener) {
            if (trace) {
                System.err.println("--> Entry: PosSubsystem$SystemEventMessenger.SystemEventMessenger");
            }
            this.listener = systemEventListener;
            this.start();
            Enumeration enumeration = DeviceState.getOnlinePosQMsgs();
            while (enumeration.hasMoreElements()) {
                this.post((PosQMsg)enumeration.nextElement());
            }
            if (trace) {
                System.err.println("<-- Exit : PosSubsystem$SystemEventMessenger.SystemEventMessenger");
            }
        }

        SystemEventListener getListener() {
            if (trace) {
                System.err.println("--> Entry: PosSubsystem$SystemEventMessenger.getListener");
                System.err.println("<-- Exit : PosSubsystem$SystemEventMessenger.getListener");
            }
            return this.listener;
        }

        void post(PosQMsg posQMsg) {
            if (trace) {
                System.err.println("--> Entry: PosSubsystem$SystemEventMessenger.post");
            }
            if (this.queue.size() < 200) {
                this.queue.write(posQMsg);
            }
            if (trace) {
                System.err.println("<-- Exit : PosSubsystem$SystemEventMessenger.post");
            }
        }

        private void kill() {
            if (trace) {
                System.err.println("--> Entry: PosSubsystem$SystemEventMessenger.kill");
            }
            this.queue.clear();
            this.queue.write(new PosQMsg(-1));
            this.queue = null;
            if (trace) {
                System.err.println("<-- Exit : PosSubsystem$SystemEventMessenger.kill");
            }
        }

        public void run() {
            if (trace) {
                System.err.println("--> Entry: PosSubsystem$SystemEventMessenger.run");
            }
            PosQMsg posQMsg = null;
            block9: while (true) {
                posQMsg = (PosQMsg)this.queue.read();
                int n = posQMsg.getMp1MiddleBottomByte() & 0xFF;
                int n2 = posQMsg.getMp1TopByte() & 0xFF;
                int n3 = posQMsg.getMp1MiddleTopByte() & 0xFF;
                byte by = posQMsg.getMp1BottomByte();
                byte by2 = posQMsg.getMp2BottomByte();
                switch (posQMsg.getMsg()) {
                    case 16908: {
                        if (trace) {
                            System.err.println("*** SystemEventMessenger.run: calling listener.posmSysDeviceOffline( 0x" + Integer.toHexString(n) + ", 0x" + Integer.toHexString(n2) + ", 0x" + Integer.toHexString(n3) + ")");
                        }
                        try {
                            this.listener.posmSysDeviceOffline(n, n2, n3, by, by2);
                        }
                        catch (Exception exception) {
                            if (!trace) break;
                            System.err.println("*** SystemEventMessenger.run: listener threw exception:");
                            exception.printStackTrace();
                        }
                        continue block9;
                    }
                    case 16909: {
                        if (trace) {
                            System.err.println("*** SystemEventMessenger.run: calling listener.posmSysDeviceOnline( 0x" + Integer.toHexString(n) + ", 0x" + Integer.toHexString(n2) + ", 0x" + Integer.toHexString(n3));
                        }
                        try {
                            this.listener.posmSysDeviceOnline(n, n2, n3, by, by2);
                        }
                        catch (Exception exception) {
                            if (!trace) break;
                            System.err.println("*** SystemEventMessenger.run: listener threw exception:");
                            exception.printStackTrace();
                        }
                        continue block9;
                    }
                    case -1: {
                        this.listener = null;
                        if (trace) {
                            System.err.println("<-- Exit : PosSubsystem$SystemEventMessenger.run");
                        }
                        return;
                    }
                }
            }
        }
    }

    private static class DeviceState
    implements PosDef {
        private static Vector deviceStateVector = new Vector();
        private byte deviceNumber;
        private byte slotNumber;
        private byte portNumber;
        private byte type;
        private byte subtype;
        private boolean online = true;

        private DeviceState(byte by, byte by2, byte by3, byte by4, byte by5) {
            if (trace) {
                System.err.println("--> Entry: PosSubsystem$DeviceState.DeviceState");
            }
            this.deviceNumber = by;
            this.slotNumber = by2;
            this.portNumber = by3;
            this.type = by4;
            this.subtype = by5;
            deviceStateVector.addElement(this);
            if (trace) {
                System.err.println("<-- Exit : PosSubsystem$DeviceState.DeviceState");
            }
        }

        static boolean isOnline(int n, int n2, int n3) {
            if (trace) {
                System.err.println("--> Entry: PosSubsystem$DeviceState.isOnline");
            }
            DeviceState deviceState = null;
            boolean bl = false;
            byte by = (byte)n;
            byte by2 = (byte)n2;
            byte by3 = (byte)n3;
            Vector vector = deviceStateVector;
            synchronized (vector) {
                Enumeration enumeration = deviceStateVector.elements();
                while (enumeration.hasMoreElements()) {
                    deviceState = (DeviceState)enumeration.nextElement();
                    if (deviceState.deviceNumber == by && deviceState.slotNumber == by2 && deviceState.portNumber == by3) {
                        bl = deviceState.online;
                        break;
                    }
                    deviceState = null;
                }
            }
            if (trace) {
                System.err.println("<-- Exit : PosSubsystem$DeviceState.isOnline");
            }
            return bl;
        }

        static PosQMsg getOnlinePosQMsg(byte by, byte by2, byte by3) {
            if (trace) {
                System.err.println("--> Entry: PosSubsystem$DeviceState.getOnlinePosQMsg");
            }
            DeviceState deviceState = null;
            PosQMsg posQMsg = null;
            Vector vector = deviceStateVector;
            synchronized (vector) {
                Enumeration enumeration = deviceStateVector.elements();
                while (enumeration.hasMoreElements()) {
                    deviceState = (DeviceState)enumeration.nextElement();
                    if (deviceState.deviceNumber == by && deviceState.slotNumber == by2 && deviceState.portNumber == by3 && deviceState.online) {
                        posQMsg = new PosQMsg(16909);
                        posQMsg.setMp1TopByte(deviceState.slotNumber);
                        posQMsg.setMp1MiddleTopByte(deviceState.portNumber);
                        posQMsg.setMp1MiddleBottomByte(deviceState.deviceNumber);
                        posQMsg.setMp1BottomByte(deviceState.type);
                        posQMsg.setMp2BottomByte(deviceState.subtype);
                        break;
                    }
                    deviceState = null;
                }
            }
            if (trace) {
                System.err.println("<-- Exit : PosSubsystem$DeviceState.getOnlinePosQMsg");
            }
            return posQMsg;
        }

        static Enumeration getOnlinePosQMsgs() {
            if (trace) {
                System.err.println("--> Entry: PosSubsystem$DeviceState.getOnlinePosQMsgs");
            }
            Vector<PosQMsg> vector = new Vector<PosQMsg>();
            DeviceState deviceState = null;
            PosQMsg posQMsg = null;
            Vector vector2 = deviceStateVector;
            synchronized (vector2) {
                Enumeration enumeration = deviceStateVector.elements();
                while (enumeration.hasMoreElements()) {
                    deviceState = (DeviceState)enumeration.nextElement();
                    if (!deviceState.online) continue;
                    posQMsg = new PosQMsg(16909);
                    posQMsg.setMp1TopByte(deviceState.slotNumber);
                    posQMsg.setMp1MiddleTopByte(deviceState.portNumber);
                    posQMsg.setMp1MiddleBottomByte(deviceState.deviceNumber);
                    posQMsg.setMp1BottomByte(deviceState.type);
                    posQMsg.setMp2BottomByte(deviceState.subtype);
                    vector.addElement(posQMsg);
                    if (!trace) continue;
                    System.err.println("\tSynthesized an online msg for d/s/p 0x" + Integer.toHexString(deviceState.deviceNumber & 0xFF) + "/0x" + Integer.toHexString(deviceState.slotNumber & 0xFF) + "/0x" + Integer.toHexString(deviceState.portNumber & 0xFF) + " type=0x" + Integer.toHexString(deviceState.type & 0xFF) + " subtype=0x" + Integer.toHexString(deviceState.subtype & 0xFF));
                    System.err.println("\tverifying PosQMsg: d/s/p 0x" + Integer.toHexString(posQMsg.getMp1MiddleBottomByte() & 0xFF) + "/0x" + Integer.toHexString(posQMsg.getMp1TopByte() & 0xFF) + "/0x" + Integer.toHexString(posQMsg.getMp1MiddleTopByte() & 0xFF) + " type=0x" + Integer.toHexString(posQMsg.getMp1BottomByte()) + " subtype=0x" + Integer.toHexString(posQMsg.getMp2BottomByte()));
                }
            }
            if (trace) {
                System.err.println("<-- Exit : PosSubsystem$DeviceState.getOnlinePosQMsgs");
            }
            return vector.elements();
        }

        static void update(PosQMsg posQMsg) {
            int n;
            if (trace) {
                System.err.println("--> Entry: PosSubsystem$DeviceState.update");
            }
            if ((n = posQMsg.getMsg()) == 16908 || n == 16909) {
                boolean bl;
                byte by = posQMsg.getMp1MiddleBottomByte();
                byte by2 = posQMsg.getMp1TopByte();
                byte by3 = posQMsg.getMp1MiddleTopByte();
                boolean bl2 = bl = n == 16909;
                if (trace) {
                    System.err.println("\tdeviceNumber: 0x" + Integer.toHexString(by & 0xFF));
                    System.err.println("\tslotNumber:   0x" + Integer.toHexString(by2 & 0xFF));
                    System.err.println("\tportNumber:   0x" + Integer.toHexString(by3 & 0xFF));
                    System.err.println("\tonline:      " + (bl ? "true" : "false"));
                }
                DeviceState deviceState = null;
                Vector vector = deviceStateVector;
                synchronized (vector) {
                    Enumeration enumeration = deviceStateVector.elements();
                    while (enumeration.hasMoreElements()) {
                        deviceState = (DeviceState)enumeration.nextElement();
                        if (deviceState.deviceNumber == by && deviceState.slotNumber == by2 && deviceState.portNumber == by3) {
                            deviceState.online = bl;
                            break;
                        }
                        deviceState = null;
                    }
                    if (deviceState == null && bl) {
                        byte by4 = posQMsg.getMp1BottomByte();
                        byte by5 = posQMsg.getMp2BottomByte();
                        deviceState = new DeviceState(by, by2, by3, by4, by5);
                    }
                }
            }
            if (trace) {
                System.err.println("<-- Exit : PosSubsystem$DeviceState.update");
            }
        }

        static Enumeration takeAllDevicesOffline() {
            if (trace) {
                System.err.println("--> Entry: PosSubsystem$DeviceState.takeAllDevicesOffline");
            }
            Vector<PosQMsg> vector = new Vector<PosQMsg>();
            DeviceState deviceState = null;
            PosQMsg posQMsg = null;
            Vector vector2 = deviceStateVector;
            synchronized (vector2) {
                Enumeration enumeration = deviceStateVector.elements();
                while (enumeration.hasMoreElements()) {
                    deviceState = (DeviceState)enumeration.nextElement();
                    deviceState.online = false;
                    posQMsg = new PosQMsg(16908);
                    posQMsg.setMp1TopByte(deviceState.slotNumber);
                    posQMsg.setMp1MiddleTopByte(deviceState.portNumber);
                    posQMsg.setMp1MiddleBottomByte(deviceState.deviceNumber);
                    posQMsg.setMp1BottomByte(deviceState.type);
                    posQMsg.setMp2BottomByte(deviceState.subtype);
                    vector.addElement(posQMsg);
                    if (trace) {
                        System.err.println("\tSynthesized an offline msg for d/s/p 0x" + Integer.toHexString(deviceState.deviceNumber & 0xFF) + "/0x" + Integer.toHexString(deviceState.slotNumber & 0xFF) + "/0x" + Integer.toHexString(deviceState.portNumber & 0xFF) + " type=0x" + Integer.toHexString(deviceState.type & 0xFF) + " subtype=0x" + Integer.toHexString(deviceState.subtype & 0xFF));
                        System.err.println("\tverifying PosQMsg: d/s/p 0x" + Integer.toHexString(posQMsg.getMp1MiddleBottomByte() & 0xFF) + "/0x" + Integer.toHexString(posQMsg.getMp1TopByte() & 0xFF) + "/0x" + Integer.toHexString(posQMsg.getMp1MiddleTopByte() & 0xFF) + " type=0x" + Integer.toHexString(posQMsg.getMp1BottomByte()) + " subtype=0x" + Integer.toHexString(posQMsg.getMp2BottomByte()));
                    }
                    deviceState = null;
                }
            }
            if (trace) {
                System.err.println("<-- Exit : PosSubsystem$DeviceState.takeAllDevicesOffline");
            }
            return vector.elements();
        }
    }

    private static abstract class SystemEventListenerManager {
        private static Vector messengerVector = new Vector();

        private SystemEventListenerManager() {
        }

        static void addSystemEventListener(SystemEventListener systemEventListener) {
            if (trace) {
                System.err.println("--> Entry: PosSubsystem$SystemEventListenerManager.addSystemEventListener");
            }
            SystemEventMessenger systemEventMessenger = new SystemEventMessenger(systemEventListener);
            messengerVector.addElement(systemEventMessenger);
            if (trace) {
                System.err.println("<-- Exit : PosSubsystem$SystemEventListenerManager.addSystemEventListener");
            }
        }

        static void removeSystemEventListener(SystemEventListener systemEventListener) {
            if (trace) {
                System.err.println("--> Entry: PosSubsystem$SystemEventListenerManager.removeSystemEventListener");
            }
            SystemEventMessenger systemEventMessenger = null;
            Vector vector = messengerVector;
            synchronized (vector) {
                Enumeration enumeration = messengerVector.elements();
                while (enumeration.hasMoreElements()) {
                    systemEventMessenger = (SystemEventMessenger)enumeration.nextElement();
                    if (systemEventMessenger.getListener() != systemEventListener) continue;
                    messengerVector.removeElement(systemEventMessenger);
                    systemEventMessenger.kill();
                    break;
                }
            }
            if (trace) {
                System.err.println("<-- Exit : PosSubsystem$SystemEventListenerManager.removeSystemEventListener");
            }
        }

        static void systemEventOccurred(PosQMsg posQMsg) {
            if (trace) {
                System.err.println("--> Entry: PosSubsystem$SystemEventListenerManager.systemEventOccurred");
            }
            DeviceState.update(posQMsg);
            Vector vector = messengerVector;
            synchronized (vector) {
                Enumeration enumeration = messengerVector.elements();
                while (enumeration.hasMoreElements()) {
                    ((SystemEventMessenger)enumeration.nextElement()).post(posQMsg);
                }
            }
            if (trace) {
                System.err.println("<-- Exit : PosSubsystem$SystemEventListenerManager.systemEventOccurred");
            }
        }
    }
}

