/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jpos.services;

import com.ibm.jpos.services.DeviceService;
import com.ibm.jpos.services.DeviceServiceState;
import com.ibm.jpos.services.MotionSensorServiceImp;
import com.ibm.jpos.services.MotionSensorServiceState;
import com.ibm.jpos.util.Timer;
import com.ibm.jpos.util.Timerable;
import com.ibm.jutil.Util;
import jpos.JposException;
import jpos.services.MotionSensorService19;

public abstract class MotionSensorService
extends DeviceService
implements MotionSensorService19 {
    private Timer timer = null;
    private boolean timerExpired = false;
    public static final String MOTIONSENSOR_DEVCAT = "com.ibm.jpos.services.MotionSensorService";
    public int DEFAULT_WAITTIME_MOTION_NOTIFICATION = 200;

    public MotionSensorService(MotionSensorServiceImp imp) {
        super(imp);
        this.setDeviceServiceState(new MotionSensorServiceState());
    }

    public synchronized void claim(int timeout) throws JposException {
        throw new JposException(106);
    }

    public void release() throws JposException {
        throw new JposException(106);
    }

    public synchronized void checkHealth(int level) throws JposException {
        if (this.tracer.isOn()) {
            this.enhTrace(this.getClass().getName(), this.getinstanceID(), this.gettimeStamp() - DeviceService.getFsttmStamp(), "-->checkHealth," + level);
        }
        this.getDeviceServiceState().isOpenEnable();
        this.checkCheckHealthArg(level);
        this.getDeviceServiceImp().checkHealth(level);
        if (this.tracer.isOn()) {
            this.enhTrace(this.getClass().getName(), this.getinstanceID(), this.gettimeStamp() - DeviceService.getFsttmStamp(), "<--checkHealth," + level);
        }
    }

    public synchronized void setDeviceEnabled(boolean deviceEnabled) throws JposException {
        if (this.tracer.isOn()) {
            this.enhTrace(this.getClass().getName(), this.getinstanceID(), this.gettimeStamp() - DeviceService.getFsttmStamp(), "-->setDeviceEnabled," + deviceEnabled);
        }
        this.getDeviceServiceState().isOpen();
        DeviceServiceState state = this.getDeviceServiceState();
        if (!state.getDeviceEnabled()) {
            this.checkOnline();
        }
        this.getDeviceServiceImp().setDeviceEnabled(deviceEnabled);
        this.getDeviceServiceState().setDeviceEnabled(deviceEnabled);
        if (this.tracer.isOn()) {
            this.enhTrace(this.getClass().getName(), this.getinstanceID(), this.gettimeStamp() - DeviceService.getFsttmStamp(), "<--setDeviceEnabled," + deviceEnabled);
        }
    }

    public synchronized void compareFirmwareVersion(String firmwareFileName, int[] result) throws JposException {
        if (this.tracer.isOn()) {
            this.enhTrace(this.getClass().getName(), this.getinstanceID(), this.gettimeStamp() - DeviceService.getFsttmStamp(), "-->compareFirmwareVersion");
        }
        this.getDeviceServiceState().isOpenEnable();
        if (!this.getDeviceServiceState().getCapCompareFirmwareVersion()) {
            throw new JposException(106);
        }
        this.getDeviceServiceImp().compareFirmwareVersion(firmwareFileName, result);
        if (this.tracer.isOn()) {
            this.enhTrace(this.getClass().getName(), this.getinstanceID(), this.gettimeStamp() - DeviceService.getFsttmStamp(), "<--compareFirmwareVersion");
        }
    }

    public synchronized void retrieveStatistics(String[] statisticsBuffer) throws JposException {
        if (this.tracer.isOn()) {
            this.enhTrace(this.getClass().getName(), this.getinstanceID(), this.gettimeStamp() - DeviceService.getFsttmStamp(), "-->retrieveStatistics," + Util.toString((String[])statisticsBuffer));
        }
        if (!this.getDeviceServiceState().getCapStatisticsReporting()) {
            throw new JposException(106);
        }
        this.getDeviceServiceState().isOpenEnable();
        this.getDeviceServiceImp().retrieveStatistics(statisticsBuffer);
        if (this.tracer.isOn()) {
            this.enhTrace(this.getClass().getName(), this.getinstanceID(), this.gettimeStamp() - DeviceService.getFsttmStamp(), "<--retrieveStatistics," + Util.toString((String[])statisticsBuffer));
        }
    }

    public synchronized void updateFirmware(String firmwareFileName) throws JposException {
        if (this.tracer.isOn()) {
            this.enhTrace(this.getClass().getName(), this.getinstanceID(), this.gettimeStamp() - DeviceService.getFsttmStamp(), "-->updateFirmware");
        }
        this.getDeviceServiceState().isOpenEnable();
        if (!this.getDeviceServiceState().getCapUpdateFirmware()) {
            throw new JposException(106);
        }
        this.getDeviceServiceImp().updateFirmware(firmwareFileName);
        if (this.tracer.isOn()) {
            this.enhTrace(this.getClass().getName(), this.getinstanceID(), this.gettimeStamp() - DeviceService.getFsttmStamp(), "<--updateFirmware");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getTimeout() throws JposException {
        MotionSensorServiceState state;
        MotionSensorServiceState motionSensorServiceState = state = this.getMotionSensorServiceState();
        synchronized (motionSensorServiceState) {
            state.isOpenEnable();
            if (this.tracer.isOn()) {
                this.enhTrace(this.getClass().getName(), this.getinstanceID(), this.gettimeStamp() - DeviceService.getFsttmStamp(), "getTimeout," + state.getTimeout());
            }
            return state.getTimeout();
        }
    }

    public synchronized void setTimeout(int timeout) throws JposException {
        MotionSensorServiceState state = this.getMotionSensorServiceState();
        if (this.tracer.isOn()) {
            this.enhTrace(this.getClass().getName(), this.getinstanceID(), this.gettimeStamp() - DeviceService.getFsttmStamp(), "setTimeout," + timeout);
        }
        state.isOpenEnable();
        this.checkTimeoutArgument(timeout);
        this.getMotionSensorServiceImp().setTimeout(timeout);
        state.setTimeout(timeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getMotion() throws JposException {
        MotionSensorServiceState state;
        MotionSensorServiceState motionSensorServiceState = state = this.getMotionSensorServiceState();
        synchronized (motionSensorServiceState) {
            state.isOpenEnable();
            if (this.tracer.isOn()) {
                this.enhTrace(this.getClass().getName(), this.getinstanceID(), this.gettimeStamp() - DeviceService.getFsttmStamp(), "getMotion," + state.getMotion());
            }
            return state.getMotion();
        }
    }

    public synchronized void waitForMotion(int timeout) throws JposException {
        MotionSensorServiceState state = this.getMotionSensorServiceState();
        if (this.tracer.isOn()) {
            this.enhTrace(this.getClass().getName(), this.getinstanceID(), this.gettimeStamp() - DeviceService.getFsttmStamp(), "waitForMotion," + timeout);
        }
        this.checkTimeoutArg(timeout);
        state.isOpenEnable();
        this.checkOnline();
        if (state.getMotion()) {
            return;
        }
        this.commonWaitForMotion(timeout);
    }

    protected Timer getTimer() {
        if (this.timer == null) {
            this.timer = new Timer(new Timerable(){

                public void timerExpired() {
                    MotionSensorService.this.timerExpired = true;
                }
            });
        }
        return this.timer;
    }

    protected void commonWaitForMotion(int timeout) throws JposException {
        MotionSensorServiceState state = (MotionSensorServiceState)this.getDeviceServiceState();
        this.timerExpired = false;
        if (timeout != -1) {
            Timer timer = this.getTimer();
            timer.reset();
            timer.setTime(timeout);
            timer.start();
        }
        while (!state.getMotion()) {
            if (this.timerExpired && timeout != -1) {
                throw new JposException(112);
            }
            try {
                Thread.currentThread();
                Thread.sleep(this.getWaitForMotionNotification());
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.checkOnline();
        }
    }

    public int getWaitForMotionNotification() {
        return this.DEFAULT_WAITTIME_MOTION_NOTIFICATION;
    }

    protected MotionSensorServiceImp getMotionSensorServiceImp() {
        return (MotionSensorServiceImp)this.getDeviceServiceImp();
    }

    protected MotionSensorServiceState getMotionSensorServiceState() {
        return (MotionSensorServiceState)this.getDeviceServiceState();
    }

    public final String getDeviceCategory() {
        return MOTIONSENSOR_DEVCAT;
    }

    protected void checkTimeoutArgument(int i) throws JposException {
        if (i < 0) {
            throw new JposException(106);
        }
    }
}

