/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jpos.services;

import com.ibm.jpos.services.DeviceService;
import com.ibm.jpos.services.ServiceKey;
import java.util.Enumeration;
import java.util.Vector;

public class ServiceInfo {
    private ServiceKey serviceKey = null;
    private Vector deviceServices = new Vector();
    private DeviceService claimedService = null;
    private DeviceService parentService = null;
    public static final String DEVICESERVICE_KEY_NOT_MATCHING_SERVICEINFO_KEY = "JavaPOS Internal ServiceRegistry Error: DeviceService.State.ServiceKey does not match ServiceInfo.ServiceKey";

    public ServiceInfo(ServiceKey sK) {
        this.serviceKey = sK;
    }

    public String toString() {
        StringBuffer sB = new StringBuffer();
        sB.append("---------------------------------------\n");
        sB.append("ServiceInfo for key = " + this.getServiceKey().toString() + "\n");
        sB.append("    Number of DeviceService = " + this.deviceServices.size() + "\n");
        sB.append("    ClaimedService = " + this.getClaimedService() + "\n");
        for (int i = 0; i < this.deviceServices.size(); ++i) {
            sB.append("        DeviceService #" + i + " " + this.deviceServices.elementAt(i) + "\n");
        }
        sB.append("---------------------------------------");
        return sB.toString();
    }

    public ServiceKey getServiceKey() {
        return this.serviceKey;
    }

    public DeviceService getClaimedService() {
        return this.claimedService;
    }

    public void setClaimedService(DeviceService dS) {
        if (dS == null) {
            this.claimedService = null;
            return;
        }
        if (!this.deviceServices.contains(dS)) {
            this.deviceServices.addElement(dS);
        }
        this.claimedService = dS;
    }

    public Enumeration getDeviceServices() {
        return this.deviceServices.elements();
    }

    public void addDeviceService(DeviceService dS) throws IllegalArgumentException {
        if (!dS.getDeviceServiceState().getServiceKey().equals(this.getServiceKey())) {
            throw new IllegalArgumentException(DEVICESERVICE_KEY_NOT_MATCHING_SERVICEINFO_KEY);
        }
        if (!this.deviceServices.contains(dS)) {
            this.deviceServices.addElement(dS);
        }
    }

    public void removeDeviceService(DeviceService dS) throws IllegalArgumentException {
        if (!dS.getDeviceServiceState().getServiceKey().equals(this.getServiceKey())) {
            throw new IllegalArgumentException(DEVICESERVICE_KEY_NOT_MATCHING_SERVICEINFO_KEY);
        }
        this.deviceServices.removeElement(dS);
    }

    public boolean containsDeviceService(DeviceService dS) {
        return this.deviceServices.contains(dS);
    }
}

