/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jpos.services;

import com.ibm.jpos.services.DeviceService;
import com.ibm.jpos.services.ServiceInfo;
import com.ibm.jpos.services.ServiceKey;
import java.util.Enumeration;
import java.util.Hashtable;

public final class ServiceRegistry {
    private Hashtable hashTable = new Hashtable();
    private static ServiceRegistry instance = null;

    private ServiceRegistry() {
    }

    public static synchronized ServiceRegistry getInstance() {
        if (instance == null) {
            instance = new ServiceRegistry();
        }
        return instance;
    }

    public String toString() {
        StringBuffer sB = new StringBuffer();
        sB.append("=======================================\n");
        sB.append("Service Registry Contents\n");
        sB.append("Number of (ServiceKey, ServiceInfo) pairs = " + this.hashTable.size() + "\n");
        Enumeration keys = this.hashTable.keys();
        int count = 0;
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            sB.append("~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~\n");
            sB.append("<ServiceKey, ServiceInfo> pair #" + count++ + "\n");
            sB.append("ServiceKey = " + key + "\n");
            sB.append(this.hashTable.get(key.toString()).toString() + "\n");
            sB.append("~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~\n");
        }
        sB.append("=======================================\n");
        return sB.toString();
    }

    public synchronized int getServiceInfoCount() {
        return this.hashTable.size();
    }

    public synchronized void setServiceInfo(ServiceKey sKey, ServiceInfo sInfo) {
        if (!this.hashTable.containsKey(sKey.toString())) {
            this.hashTable.put(sKey.toString(), sInfo);
        }
    }

    public ServiceInfo getServiceInfo(ServiceKey sKey) {
        return (ServiceInfo)this.hashTable.get(sKey.toString());
    }

    public synchronized void addDeviceService(ServiceKey sKey, DeviceService dS) {
        ServiceInfo sInfo = null;
        if (this.hashTable.containsKey(sKey.toString())) {
            sInfo = (ServiceInfo)this.hashTable.get(sKey.toString());
        } else {
            sInfo = new ServiceInfo(sKey);
            this.hashTable.put(sKey.toString(), sInfo);
        }
        sInfo.addDeviceService(dS);
    }

    public synchronized void removeDeviceService(ServiceKey sKey, DeviceService dS) {
        if (!this.hashTable.containsKey(sKey.toString())) {
            return;
        }
        ((ServiceInfo)this.hashTable.get(sKey.toString())).removeDeviceService(dS);
    }

    public synchronized boolean containsDeviceService(ServiceKey sKey, DeviceService dS) {
        if (!this.hashTable.containsKey(sKey.toString())) {
            return false;
        }
        return ((ServiceInfo)this.hashTable.get(sKey.toString())).containsDeviceService(dS);
    }

    public synchronized DeviceService getClaimedService(ServiceKey sKey) {
        if (!this.hashTable.containsKey(sKey.toString())) {
            return null;
        }
        return ((ServiceInfo)this.hashTable.get(sKey.toString())).getClaimedService();
    }

    public synchronized void setClaimedService(ServiceKey sKey, DeviceService dS) {
        if (!this.hashTable.containsKey(sKey.toString())) {
            return;
        }
        ServiceInfo sInfo = (ServiceInfo)this.hashTable.get(sKey.toString());
        sInfo.setClaimedService(dS);
    }
}

