/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jpos.util;

import com.ibm.jpos.util.DefaultLogEntry;
import com.ibm.jpos.util.LogEntryMsg;
import com.ibm.jpos.util.LogEntryMsgHelper;
import java.io.Serializable;
import java.text.SimpleDateFormat;

public class LogEntry
extends DefaultLogEntry
implements Serializable {
    private char[] storeControllerId = null;
    private short terminalNumber = 0;
    private short severity = 1;
    private char messageGroup = (char)74;
    private short messageNumber = 0;
    private short logSection = 0;
    private short source = 0;
    private short eventCode = 0;
    private char[] uniqueData = null;
    private static final int MESSAGEGROUP_SIZE = 2;
    private static final int UNIQUEDATA_SIZE = 18;
    private static final int STORE_CONTROLLER_ID_SIZE = 2;
    private static final short MIN_TERMINALNUMBER = 0;
    private static final short MAX_TERMINALNUMBER = 999;
    public static final short MIN_SEVERITY = 1;
    public static final short MAX_SEVERITY = 5;
    public static final short MIN_LOGSECTION = 0;
    public static final short MAX_LOGSECTION = 9;
    public static final short MIN_SOURCE = 0;
    public static final short MAX_SOURCE = 999;
    public static final short MIN_EVENTCODE = 0;
    public static final short MAX_EVENTCODE = 999;

    public static LogEntry copy(LogEntry logEntry) {
        LogEntry newLogEntry = new LogEntry();
        newLogEntry.setMessage(logEntry.getMessage());
        newLogEntry.setData(logEntry.getData());
        newLogEntry.setStoreControllerId(logEntry.getStoreControllerId());
        newLogEntry.setTerminalNumber(logEntry.getTerminalNumber());
        newLogEntry.setSeverity(logEntry.getSeverity());
        newLogEntry.setMessageGroup(logEntry.getMessageGroup());
        newLogEntry.setMessageNumber(logEntry.getMessageNumber());
        newLogEntry.setSource(logEntry.getSource());
        newLogEntry.setEventCode(logEntry.getEventCode());
        newLogEntry.setUniqueData(logEntry.getUniqueData());
        return newLogEntry;
    }

    public char[] getStoreControllerId() {
        return this.storeControllerId;
    }

    public short getTerminalNumber() {
        return this.terminalNumber;
    }

    public short getSeverity() {
        return this.severity;
    }

    public char getMessageGroup() {
        return this.messageGroup;
    }

    public short getMessageNumber() {
        return this.messageNumber;
    }

    public String getMessageText() {
        return LogEntryMsgHelper.getMessageText(this.getMessageNumber());
    }

    public short getLogSection() {
        return this.logSection;
    }

    public short getSource() {
        return this.source;
    }

    public short getEventCode() {
        return this.eventCode;
    }

    public char[] getUniqueData() {
        return this.uniqueData;
    }

    public void setStoreControllerId(char[] charArray) throws IllegalArgumentException {
        if (charArray == null || charArray.length < 2) {
            throw new IllegalArgumentException(LogEntryMsg.INVALID_LOGENTRY_STORECONTROLLERID_PROPERTY_MSG);
        }
        this.storeControllerId = new char[2];
        for (int i = 0; i < 2; ++i) {
            if (charArray[i] < 'C' || charArray[i] > 'Z') {
                throw new IllegalArgumentException(LogEntryMsg.INVALID_LOGENTRY_STORECONTROLLERID_PROPERTY_MSG);
            }
            this.storeControllerId[i] = charArray[i];
        }
    }

    public void setTerminalNumber(short s) throws IllegalArgumentException {
        if (s < 0 || s > 999) {
            throw new IllegalArgumentException(LogEntryMsg.INVALID_LOGENTRY_TERMINALNUMBER_PROPERTY_MSG);
        }
        this.terminalNumber = s;
    }

    public void setSeverity(short s) {
        if (s < 1 || s > 5) {
            throw new IllegalArgumentException(LogEntryMsg.INVALID_LOGENTRY_SEVERITY_PROPERTY_MSG);
        }
        this.severity = s;
    }

    public void setMessageGroup(char c) throws IllegalArgumentException {
        if (c < 'A' || c > 'Z') {
            throw new IllegalArgumentException(LogEntryMsg.INVALID_LOGENTRY_MESSAGEGROUP_PROPERTY_MSG);
        }
        this.messageGroup = c;
    }

    public void setMessageNumber(short s) {
        if (s < 0 || s > 10000) {
            throw new IllegalArgumentException(LogEntryMsg.INVALID_LOGENTRY_MESSAGENUMBER_PROPERTY_MSG);
        }
        this.messageNumber = s;
    }

    public void setLogSection(short s) {
        if (s < 0 || s > 9) {
            throw new IllegalArgumentException(LogEntryMsg.INVALID_LOGENTRY_LOGSECTION_PROPERTY_MSG);
        }
        this.logSection = s;
    }

    public void setSource(short s) {
        if (s < 0 || s > 999) {
            throw new IllegalArgumentException(LogEntryMsg.INVALID_LOGENTRY_SOURCE_PROPERTY_MSG);
        }
        this.source = s;
    }

    public void setEventCode(short s) {
        if (s < 0 || s > 999) {
            throw new IllegalArgumentException(LogEntryMsg.INVALID_LOGENTRY_EVENTCODE_PROPERTY_MSG);
        }
        this.eventCode = s;
    }

    public void setUniqueData(char[] charArray) throws IllegalArgumentException {
        if (charArray == null) {
            throw new IllegalArgumentException(LogEntryMsg.INVALID_LOGENTRY_UNIQUEDATA_PROPERTY_MSG);
        }
        int arrayLength = charArray.length > 18 ? 18 : charArray.length;
        this.uniqueData = new char[18];
        for (int i = 0; i < arrayLength; ++i) {
            this.uniqueData[i] = charArray[i];
        }
    }

    public String toString() {
        String s = "\n-------------------------------------------------\n";
        s = s + "ID: " + String.valueOf(this.getID()) + ", ";
        s = s + "message: " + this.getMessage() + "\n\n";
        s = s + new SimpleDateFormat().format(this.getDateStamp()) + " ";
        s = s + (this.getStoreControllerId() == null ? "" : String.copyValueOf(this.getStoreControllerId())) + " ";
        s = s + String.valueOf(this.getTerminalNumber()) + " ";
        s = s + String.valueOf(this.getSeverity()) + " ";
        s = s + String.valueOf(this.getMessageGroup()) + String.valueOf(this.getMessageNumber()) + " ";
        s = s + this.getMessageText() + " ";
        s = s + "B" + String.valueOf(this.getLogSection()) + "/";
        s = s + "S" + String.valueOf(this.getSource()) + "/";
        s = s + "E" + String.valueOf(this.getEventCode()) + " ";
        s = s + (this.getUniqueData() == null ? "" : String.copyValueOf(this.getUniqueData()));
        s = s + "\n-------------------------------------------------";
        return s;
    }
}

