/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.posj;

import com.ibm.jutil.logging.LogHelper;
import com.ibm.posj.HandleRegistry;
import com.ibm.posj.PosException;
import com.ibm.posj.bus.HandlePopulator;
import com.ibm.posj.event.PosSystemEvent;
import com.ibm.posj.event.PosSystemListener;
import com.ibm.posj.util.DevBus;
import java.util.Enumeration;
import java.util.Iterator;

public interface PosSystem {
    public HandleRegistry getHandleRegistry();

    public void addPosSystemListener(PosSystemListener var1);

    public void removePosSystemListener(PosSystemListener var1);

    public void start() throws PosException;

    public boolean isStarted();

    public void startPopulator(DevBus var1) throws PosException;

    public boolean isPopulatorStarted(DevBus var1);

    public LogHelper getLogHelper();

    public PopulatorRegistry getPopulatorRegistry();

    public EventHelper getEventHelper();

    public Properties getProperties();

    public int getListenerCount();

    public static interface PopulatorRegistry {
        public void addPopulator(HandlePopulator var1);

        public void removePopulator(HandlePopulator var1);

        public boolean containsPopulator(HandlePopulator var1);

        public boolean containsPopulator(String var1);

        public Iterator getPopulators();

        public boolean isEmpty();

        public int getSize();
    }

    public static interface Properties {
        public static final String POSJ_PROPERTIES_FILENAME = "posj.properties";
        public static final String POSJ_HANDLEPOPULATOR_PROP_NAME = "posj.bus.handle.populator.class";
        public static final String POSJ_HANDLEPOPULATOR_LINUX_PROP_NAME = "posj.bus.handle.populator.linux.class";
        public static final String POSJ_HANDLEPOPULATOR_QNX_PROP_NAME = "posj.bus.handle.populator.qnx.class";

        public void loadProperties();

        public boolean isLoaded();

        public Exception getLastException();

        public String getPropertyString(String var1);

        public boolean isPropertyDefined(String var1);

        public Enumeration getPropertyNames();

        public Enumeration getPropertyValuesWithPattern(String var1);
    }

    public static interface EventHelper {
        public void addPosSystemListener(PosSystemListener var1);

        public void removePosSystemListener(PosSystemListener var1);

        public void firePosDeviceAttached(PosSystemEvent var1);

        public void firePosDeviceDetached(PosSystemEvent var1);

        public int getListenerCount();
    }
}

