/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.posj.bus.hid;

import com.ibm.hid.HidDevice;
import com.ibm.hid.ReportEvent;
import com.ibm.jutil.Util;
import com.ibm.posj.Handle;
import com.ibm.posj.HandleCmd;
import com.ibm.posj.HandleException;
import com.ibm.posj.HandleKey;
import com.ibm.posj.SystemCmd;
import com.ibm.posj.bus.HandleImpVisitor;
import com.ibm.posj.bus.KeylockHandleImp;
import com.ibm.posj.bus.hid.AbstractHidHandleImp;
import com.ibm.posj.bus.hid.HidHandleImp;
import com.ibm.posj.bus.hid.HidHandleImpVisitor;
import com.ibm.posj.bus.hid.HidKeylockStrategy;
import com.ibm.posj.event.ErrorEvent;
import com.ibm.posj.event.StatusEvent;
import com.ibm.posj.util.DevCat;
import com.ibm.posj.util.DevCats;
import com.ibm.posj.util.KeylockUtil;
import com.ibm.posj.util.PosjUtil;

public class HidKeylockHandleImp
extends AbstractHidHandleImp
implements HidHandleImp,
KeylockHandleImp {
    private HidKeylockStrategy strategy = null;
    private int deviceId = -1;
    private Object lockObj = new Object();
    public static final int DELAY = 500;
    public static final int ERROR_BIT = 7;
    public static final int DEV_INFO_BIT = 2;
    public static final int POSITION_BYTE1 = 4;
    public static final int POSITION_BYTE2 = 5;
    public static final byte[] KL_STATUS_REQUEST_CMD = new byte[]{0, 32};
    public static final byte[] KL_DEVINFO_REQUEST_CMD = new byte[]{0, 0, 1};

    public HidKeylockHandleImp(HandleKey key, HidDevice device, HidKeylockStrategy strategy) {
        super(key, device);
        this.strategy = strategy;
    }

    public void init() throws HandleException {
        super.init();
        if (this.isTracerOn()) {
            this.traceNormal("Using strategy: " + this.getStrategy());
        }
    }

    public void accept(HidHandleImpVisitor visitor) {
        visitor.visitHidKeylockHandleImp(this);
    }

    public void accept(HandleImpVisitor visitor) {
        visitor.visitKeylock(this);
    }

    public DevCat getDevCat() {
        return DevCats.KEYLOCK_DEVCAT;
    }

    public void submit(HandleCmd cmd) throws HandleException {
        block9: {
            if (this.isLocked.isTrue()) {
                throw new HandleException("Attempting to submit to Keylock while flashing");
            }
            if (cmd == null) {
                throw new HandleException("Attempted to submit a null command to handle");
            }
            try {
                if (cmd.getCode() == 101) {
                    this.submitCmd(cmd.getName(), KL_STATUS_REQUEST_CMD);
                    break block9;
                }
                if (cmd.getCode() == 103) {
                    this.submitDevInfoCmd((SystemCmd.DeviceInfoRequestCmd)cmd);
                    break block9;
                }
                throw new HandleException("Invalid SystemCmd object submitted!");
            }
            catch (HandleException he) {
                this.setHandleCmdResultInError(cmd, true);
                throw he;
            }
            finally {
                cmd.setCompleted(true);
            }
        }
    }

    public boolean isComposite() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void submitDevInfoCmd(SystemCmd.DeviceInfoRequestCmd devInfoCmd) throws HandleException {
        if (this.deviceId == -1) {
            Object object = this.lockObj;
            synchronized (object) {
                this.submitCmd(devInfoCmd.getName(), KL_DEVINFO_REQUEST_CMD);
                try {
                    this.lockObj.wait(500L);
                }
                catch (InterruptedException ie) {
                    // empty catch block
                }
            }
            if (this.deviceId == -1) {
                object = this.lockObj;
                synchronized (object) {
                    this.submitCmd(devInfoCmd.getName(), KL_DEVINFO_REQUEST_CMD);
                    try {
                        this.lockObj.wait(500L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
        }
        if (this.deviceId == -1) {
            devInfoCmd.setDeviceId(2910);
        } else {
            devInfoCmd.setDeviceId(this.deviceId);
        }
        devInfoCmd.setFirmwareLevel(this.getBCDLevel());
        devInfoCmd.setSerialNumber(this.getSerialNumber());
    }

    protected void parseAndFireDataEvent(byte[] report) {
        int handlePosition = -1;
        boolean bit4 = false;
        boolean bit5 = false;
        Handle.EventHelper eventHelper = null;
        if (this.getHandle() == null) {
            return;
        }
        eventHelper = this.getHandle().getEventHelper();
        try {
            this.checkForCmdRejectError(report);
        }
        catch (HandleException he) {
            eventHelper.fireErrorEvent(new ErrorEvent(this, -101, "Keylock Command Rejected"));
        }
        bit4 = PosjUtil.isBitSelected(report[this.getStrategy().getKeylockStatusByteIndex()], 4);
        bit5 = PosjUtil.isBitSelected(report[this.getStrategy().getKeylockStatusByteIndex()], 5);
        if (report.length != 16 || report[0] != 0 || report[1] != 0 || report[2] != 0 || report[3] != 0 || report[4] != 0 || report[5] != 0 || report[6] != 0 || report[7] != 0 || report[8] != 0 || report[9] != 0 || report[10] != 0 || report[11] != 0 || report[12] != 0 || report[13] != 0 || report[14] != 0 || report[15] != 0) {
            handlePosition = KeylockUtil.isDBCS(this.deviceId) ? (bit5 ? (bit4 ? 3 : 2) : (bit4 ? 1 : 4)) : (bit4 ? 3 : 2);
            eventHelper.fireStatusEvent(new StatusEvent(this, handlePosition));
            if (this.isTracerOn()) {
                this.traceNormal(" ----> fireStatusEvent :" + handlePosition);
            }
        } else if (this.isTracerOn()) {
            this.traceNormal(" This event is likely a bogus event from disconnection, and will be ignored");
        }
    }

    protected void checkForCmdRejectError(byte[] response) throws HandleException {
        byte Rejected = response[this.getStrategy().getErrorStatusByteIndex()];
        if (PosjUtil.isBitSelected(Rejected, 7)) {
            throw new HandleException("Command Rejected by Keylock");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void reportEventOccurred(ReportEvent rE) {
        try {
            if (this.getHandle() == null || !this.getHandle().isInit()) {
                return;
            }
        }
        catch (HandleException handleException) {
            // empty catch block
        }
        if (this.isTracerOn()) {
            this.traceNormal("->reportEventOccurred : " + Util.toFormatedHexString((byte[])rE.getData()));
        }
        if (this.isDevInfoResult(rE.getData()) && this.deviceId == -1) {
            this.deviceId = this.getStrategy().getDeviceId(rE.getData());
            Object object = this.lockObj;
            synchronized (object) {
                this.lockObj.notifyAll();
            }
            if (this.isTracerOn()) {
                this.traceNormal("reportEventOccurred(): deviceId to use ->" + this.deviceId + ", SBCS=" + !KeylockUtil.isDBCS(this.deviceId));
            }
        }
        this.parseAndFireDataEvent(rE.getData());
        if (this.isTracerOn()) {
            this.traceNormal("<- reportEventOccurred() ");
        }
    }

    protected boolean isDevInfoResult(byte[] response) {
        if (response.length >= 6) {
            return PosjUtil.isBitSelected(response[this.getStrategy().getDevInfoPosition()], 2);
        }
        return false;
    }

    protected HidKeylockStrategy getStrategy() {
        return this.strategy;
    }

    protected void reinitialize() throws HandleException {
        this.submit(this.getHandle().getSystemCmdFactory().createStatusRequestCmd());
    }
}

