/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.posj.bus.hid.javaxusb;

import com.ibm.jutil.tracing.Tracer;
import com.ibm.jutil.tracing.TracerFactory;
import com.ibm.posj.bus.hid.javaxusb.IBM4610PrinterInitializer;
import com.ibm.posj.bus.hid.javaxusb.IBM4689PrinterInitializer;
import com.ibm.posj.bus.hid.javaxusb.POSKeyboardInitializer;
import com.ibm.posj.bus.hid.javaxusb.ProtocolConverterInitializer;
import com.ibm.posj.bus.hid.javaxusb.UsbHandlePopulator;
import com.ibm.posj.bus.hid.javaxusb.UsbIDUtil;
import java.util.ArrayList;
import java.util.List;
import javax.usb.UsbDevice;
import javax.usb.UsbDeviceDescriptor;
import javax.usb.event.UsbDeviceDataEvent;
import javax.usb.event.UsbDeviceErrorEvent;
import javax.usb.event.UsbDeviceEvent;
import javax.usb.event.UsbDeviceListener;

public class UsbInitializationManager {
    private UsbHandlePopulator usbHandlePopulator = null;
    private UsbIDUtil usbIDUtil = UsbIDUtil.getInstance();
    private final Tracer tracer = TracerFactory.getInstance().createTracer("HID", "UsbInitializationManager");
    private List printers = null;
    private UsbDevice systemKeyboard = null;
    private final UsbDeviceListener sysKbdListener = new UsbDeviceListener(){

        public void usbDeviceDetached(UsbDeviceEvent udE) {
            UsbInitializationManager.this.systemKeyboard = null;
            udE.getUsbDevice().removeUsbDeviceListener((UsbDeviceListener)this);
        }

        public void errorEventOccurred(UsbDeviceErrorEvent udeE) {
        }

        public void dataEventOccurred(UsbDeviceDataEvent uddE) {
        }
    };

    UsbInitializationManager(UsbHandlePopulator populator) {
        this.usbHandlePopulator = populator;
    }

    public boolean initializeUsbDevice(UsbDevice device) {
        short pid;
        String serial;
        UsbDeviceDescriptor udd;
        boolean initialized = true;
        if (this.usbIDUtil.isKbdAsSystemKeyboard(device.getUsbDeviceDescriptor().idVendor(), device.getUsbDeviceDescriptor().idProduct())) {
            if (this.existSystemKeyboard() && !this.isSystemKeyboard(device)) {
                this.tracer.println("IBM keyboard : System keyboard already attached");
            } else {
                this.tracer.println("IBM keyboard : device will be used as system keyboard");
                if (!this.isSystemKeyboard(device)) {
                    this.systemKeyboard = device;
                    device.addUsbDeviceListener(this.sysKbdListener);
                }
            }
        }
        if (this.usbIDUtil.isKbdRenumerationRequired(device.getUsbDeviceDescriptor().idVendor(), device.getUsbDeviceDescriptor().idProduct())) {
            if (this.isSystemKeyboard(device)) {
                return true;
            }
            POSKeyboardInitializer initializer = new POSKeyboardInitializer();
            initializer.setUsbDevice(device);
            initializer.setUsbHandlePopulator(this.usbHandlePopulator);
            return initializer.initialize();
        }
        if (this.usbIDUtil.isOEMScannerRenumerationRequired(device.getUsbDeviceDescriptor().idVendor(), device.getUsbDeviceDescriptor().idProduct())) {
            ProtocolConverterInitializer initializer = new ProtocolConverterInitializer();
            initializer.setUsbDevice(device);
            initializer.setUsbHandlePopulator(this.usbHandlePopulator);
            initialized = initializer.initialize();
        }
        if (UsbIDUtil.isIBM4610((udd = device.getUsbDeviceDescriptor()).idVendor(), udd.idProduct()) && !this.usbHandlePopulator.isInitialized()) {
            try {
                serial = device.getSerialNumberString();
                pid = udd.idProduct();
                if (17717 == pid && null == this.printers) {
                    this.printers = new ArrayList(3);
                }
                if (!this.printers.contains(serial)) {
                    this.printers.add(serial);
                    if (UsbIDUtil.isPrinterAdapterResetNeeded(device.getUsbDeviceDescriptor().bcdDevice())) {
                        IBM4610PrinterInitializer initializer = new IBM4610PrinterInitializer();
                        initializer.setUsbDevice(device);
                        initializer.setUsbHandlePopulator(this.usbHandlePopulator);
                        return initializer.initialize();
                    }
                    return initialized;
                }
            }
            catch (Exception e) {
                this.tracer.print(e);
                return initialized;
            }
        }
        if (UsbIDUtil.isIBM4689(udd.idVendor(), udd.idProduct()) && !this.usbHandlePopulator.isInitialized()) {
            try {
                serial = device.getSerialNumberString();
                pid = udd.idProduct();
                if (17719 == pid && null == this.printers) {
                    this.printers = new ArrayList(3);
                }
                if (!this.printers.contains(serial)) {
                    this.printers.add(serial);
                    IBM4689PrinterInitializer initializer = new IBM4689PrinterInitializer();
                    initializer.setUsbDevice(device);
                    initializer.setUsbHandlePopulator(this.usbHandlePopulator);
                    return initializer.initialize();
                }
            }
            catch (Exception e) {
                this.tracer.print(e);
                return initialized;
            }
        }
        return initialized;
    }

    protected boolean existSystemKeyboard() {
        return null != this.systemKeyboard;
    }

    protected boolean isSystemKeyboard(UsbDevice device) {
        try {
            if (this.systemKeyboard == null) {
                return false;
            }
            return this.systemKeyboard.getSerialNumberString().equalsIgnoreCase(device.getSerialNumberString());
        }
        catch (Exception uee) {
            this.tracer.print(uee);
            return false;
        }
    }
}

