/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.posj.printer;

import com.ibm.jutil.BooleanMonitor;
import com.ibm.jutil.ByteBuffer;
import com.ibm.jutil.logging.LogHelper;
import com.ibm.jutil.tasks.AbstractTask;
import com.ibm.jutil.tasks.FifoScheduler;
import com.ibm.jutil.tasks.SharedThreader;
import com.ibm.jutil.tasks.Task;
import com.ibm.jutil.tasks.TaskScheduler;
import com.ibm.jutil.tracing.Tracer;
import com.ibm.posj.DefaultPOSPrinterCmd;
import com.ibm.posj.HandleException;
import com.ibm.posj.HandleKey;
import com.ibm.posj.HandleKeyVisitor;
import com.ibm.posj.IBM4610PrinterCmd;
import com.ibm.posj.POSPrinterCmd;
import com.ibm.posj.bus.PrinterBusWriter;
import com.ibm.posj.bus.PrinterPacket;
import com.ibm.posj.bus.printer.cmds.DefaultCmdList;
import com.ibm.posj.bus.printer.cmds.PrintCmd;
import com.ibm.posj.bus.printer.cmds.PrintCmdList;
import com.ibm.posj.printer.CmdCompleteStatusVisitor;
import com.ibm.posj.printer.CmdLoadedStatusVisitor;
import com.ibm.posj.printer.IBMPrinterImp;
import com.ibm.posj.printer.InputQueue;
import com.ibm.posj.printer.InputReceiver;
import com.ibm.posj.printer.OutputProcessor;
import com.ibm.posj.printer.PrinterWriter;
import com.ibm.posj.printer.RetryInputQueue;
import com.ibm.posj.printer.StatusVisitor;
import com.ibm.posj.printer.SubmissionContainer;
import com.ibm.posj.printer.event.PrintDataEvent;
import com.ibm.posj.printer.event.PrintErrorEvent;
import com.ibm.posj.printer.event.PrintStatus;
import com.ibm.posj.util.DevBus;
import com.ibm.posj.util.DevBuses;
import com.ibm.posj.util.DevCat;
import com.ibm.posj.util.DevCats;
import java.util.ArrayList;
import java.util.List;

public abstract class DefaultPrinterWriter
extends PrinterWriter
implements StatusVisitor.ResponseProcessor,
InputReceiver {
    private static HandleKey wKey = new WriterKey();
    private LogHelper logger = null;
    private TaskScheduler errorScheduler = new FifoScheduler();
    private ErrorTask errorTask = new ErrorTask();
    private List errList = new ArrayList(10);
    protected SubmissionContainer sentQueue;
    protected InputQueue input = null;
    protected OutputProcessor outProcessor = null;
    protected PrinterPacket packet;
    private SharedThreader errorThread = new SharedThreader();
    protected PrintStatus lastStatus;
    protected PrinterBusWriter parent = null;
    private BooleanMonitor errorBlock = new BooleanMonitor(false);
    private BooleanMonitor errorPending = new BooleanMonitor(false);
    private BooleanMonitor errorPause = new BooleanMonitor(false);
    private BooleanMonitor idleMonitor = new BooleanMonitor(true);
    private PrintCmd errorCmd = null;
    private boolean onLine = false;
    protected PrinterWriter.PrinterWriterUser mainImp = null;
    protected PrintCmdList currentCmd = null;

    public DefaultPrinterWriter(PrinterBusWriter parent, PrinterPacket packet, LogHelper logger) {
        if (DefaultPrinterWriter.getTracer().isOn()) {
            Tracer tracer = DefaultPrinterWriter.getTracer();
            DefaultPrinterWriter.getTracer();
            tracer.print(1, "PrinterWriter Version 1.35.8.8");
        }
        this.packet = packet;
        this.parent = parent;
        this.logger = logger;
        this.sentQueue = new SubmissionContainer();
        this.errorPending.set(false);
        this.input = new InputQueue(this);
        this.outProcessor = new OutputProcessor(new DefaultOuputWriterInterface());
        this.onLine(null);
        this.input.start();
        this.input.sendNextCmd();
    }

    public boolean isOnline() {
        return this.onLine;
    }

    public boolean isOutputPending() {
        PrintCmdList p = this.sentQueue.getNextCmdListToComplete();
        boolean flag = false;
        if (this.currentCmd != null) {
            flag = this.currentCmd.isOutputList();
        }
        flag = flag || p != null;
        return flag;
    }

    public POSPrinterCmd getNextProcessCmd() {
        PrintCmdList l = this.sentQueue.getNextCmdListToComplete();
        if (null == l) {
            l = this.currentCmd;
        }
        if (null == l) {
            return null;
        }
        PrintCmd pc = l.getErrorResponsePending();
        POSPrinterCmd pcmd = null;
        if (null != pc) {
            pcmd = pc.getHandleCmd();
        }
        return pcmd;
    }

    public ByteBuffer getFormattedBuffer() {
        return this.packet.format();
    }

    public PrintStatus getCurrentStatus() {
        return this.lastStatus;
    }

    public BooleanMonitor getIdleKey() {
        return this.idleMonitor;
    }

    public void setMainImp(PrinterWriter.PrinterWriterUser imp) {
        this.mainImp = imp;
    }

    public int getMaxCmdLen() {
        return this.packet.getMaximum();
    }

    public void processSend() {
        this.processSent();
    }

    public void processComplete(POSPrinterCmd dpc) {
        this.commandComplete(dpc);
    }

    public boolean isStatusPending() {
        return this.parent.isStatusPending();
    }

    public synchronized void writePrintCmds() {
        try {
            this.errorBlock.waitForFalse(5000);
        }
        catch (Exception e) {
            return;
        }
        if (DefaultPrinterWriter.getTracer().isOn()) {
            DefaultPrinterWriter.getTracer().println("writePrintCmds " + this.input);
        }
        if (this.input.isEmpty()) {
            this.input.sendNextCmd();
            return;
        }
        if (null != this.currentCmd) {
            return;
        }
        PrintCmdList cCmd = this.input.getNextList();
        if (cCmd == null) {
            this.input.sendNextCmd();
            return;
        }
        if (!cCmd.hasCommands() || 0 >= cCmd.getDataSize() || cCmd.isFullyComplete()) {
            block16: {
                if (DefaultPrinterWriter.getTracer().isOn()) {
                    DefaultPrinterWriter.print("Tossing a bad cmd??? " + cCmd);
                }
                try {
                    while (cCmd.commandComplete() != null) {
                        try {
                            cCmd.commandComplete().getHandleCmd().setCompleted(true);
                        }
                        catch (Exception ce) {
                            DefaultPrinterWriter.getTracer().print(ce);
                        }
                    }
                    cCmd.recycle();
                    cCmd = null;
                }
                catch (Exception e) {
                    if (!DefaultPrinterWriter.getTracer().isOn()) break block16;
                    DefaultPrinterWriter.getTracer().print(e);
                }
            }
            this.input.sendNextCmd();
            return;
        }
        if (DefaultPrinterWriter.getTracer().isOn()) {
            DefaultPrinterWriter.print("------------------------------wpc " + cCmd);
        }
        if ((null != this.lastStatus && this.lastStatus.isHardwareError() || !this.isOnline()) && null == (cCmd = this.writeErrorCmd(cCmd))) {
            return;
        }
        this.flush(cCmd);
        if (DefaultPrinterWriter.getTracer().isOn()) {
            DefaultPrinterWriter.print("writePrintCmds>>");
        }
    }

    public HandleKey getHandleKey() {
        return wKey;
    }

    public void receivePrintStatus(PrintStatus ps) {
        block7: {
            try {
                if (DefaultPrinterWriter.getTracer().isOn()) {
                    DefaultPrinterWriter.getTracer().println("writer->>recPrintStatus " + ps + " " + this.currentCmd);
                }
                if (ps.getData()[0] == 0 && ps.getData()[1] == 0 && ps.getData()[2] == 0) {
                    if (DefaultPrinterWriter.getTracer().isOn()) {
                        DefaultPrinterWriter.print("THIS IS TRASH???");
                    }
                    return;
                }
                if (this.lastStatus != null) {
                    this.lastStatus.recycle();
                }
                this.lastStatus = ps;
                this.errorPause.set(false);
                this.outProcessor.processStatus(ps, this.currentCmd);
                this.postStatusProcess(ps);
                this.sentQueue.format();
                if (DefaultPrinterWriter.getTracer().isOn()) {
                    DefaultPrinterWriter.getTracer().println("writer<<-recPrintStatus");
                }
            }
            catch (Exception as) {
                if (!DefaultPrinterWriter.getTracer().isOn()) break block7;
                DefaultPrinterWriter.getTracer().print(as);
            }
        }
    }

    public void postStatusProcess(PrintStatus ps) {
        boolean cFlag = 0 >= this.sentQueue.size() && null == this.currentCmd;
        DefaultPrinterWriter.getTracer().println("Poststatus " + cFlag + " imonitor " + this.idleMonitor.isTrue());
        if (null == this.currentCmd && ps.getStatus(9) || cFlag) {
            if (DefaultPrinterWriter.getTracer().isOn()) {
                DefaultPrinterWriter.getTracer().println("Set idlemonitor");
            }
            if (this.idleMonitor.isFalse()) {
                this.idleMonitor.set(true);
            }
        } else if (this.idleMonitor.isTrue()) {
            this.idleMonitor.set(false);
        }
        if (cFlag) {
            if (DefaultPrinterWriter.getTracer().isOn()) {
                DefaultPrinterWriter.getTracer().println(">>Clear all error list<< - " + this.errorPending.isTrue());
            }
            if (0 < this.errList.size()) {
                this.errList.clear();
            }
            if (this.errorPending.isTrue()) {
                this.errorPending.set(false);
                this.input.sendNextCmd();
            }
        }
        try {
            if (DefaultPrinterWriter.getTracer().isOn()) {
                DefaultPrinterWriter.getTracer().println(ps.checkCmdComplete() + "\n Q cnt sent" + this.sentQueue + "\n\npending" + this.input);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void receivePrintDataEvent(PrintDataEvent pevent) {
        if (DefaultPrinterWriter.getTracer().isOn()) {
            DefaultPrinterWriter.getTracer().println("receivePrintData");
        }
        PrintCmdList p = this.sentQueue.getNextCmdListToComplete();
        int i = 1;
        while (p != null) {
            DefaultPOSPrinterCmd req;
            if (null == p) {
                this.input.sendNextCmd();
                if (DefaultPrinterWriter.getTracer().isOn()) {
                    DefaultPrinterWriter.getTracer().println(">>DataEventOccured");
                }
                return;
            }
            PrintCmd cmd = p.getResponsePending();
            DefaultPOSPrinterCmd defaultPOSPrinterCmd = req = cmd == null ? null : (DefaultPOSPrinterCmd)cmd.getHandleCmd();
            if (req instanceof POSPrinterCmd.DataRequesterCmd) {
                IBM4610PrinterCmd.StartScanCmd ssc = null;
                if (req instanceof IBM4610PrinterCmd.StartScanCmd) {
                    ssc = (IBM4610PrinterCmd.StartScanCmd)req;
                }
                if (ssc == null || ssc.getRequestData() == null) {
                    req.setRequestedData(pevent.getDataBuffer());
                }
                if (ssc != null && ssc.isScanAndMicrRead()) break;
                this.commandComplete(req);
                break;
            }
            p = this.sentQueue.getCmdListToComplete(i++);
        }
    }

    public void offLine(Object eObject) {
        this.onLine = false;
        PrintStatus pee = (PrintStatus)this.getCurrentStatus().clone();
        pee.setOfflineStatus();
        this.sentQueue.format();
        this.processSent();
        this.errList.add(pee);
        this.errorScheduler.post((Task)this.errorTask);
        this.input.sendNextCmd();
    }

    public void onLine(Object eObject) {
        this.onLine = true;
    }

    protected void checkForHang() {
        this.parent.respondToFreeze();
    }

    protected boolean responsePending() {
        return this.sentQueue.size() > 0 || this.currentCmd != null;
    }

    protected InputQueue getInputQ() {
        return this.input;
    }

    protected PrintErrorEvent setPostErrorEvent(byte station, byte priority) {
        PrintErrorEvent event = null;
        if (!this.isOnline()) {
            PrintStatus.ErrorStruct es = new PrintStatus.ErrorStruct();
            es.type = (byte)2;
            es.code = (short)256;
            event = PrintErrorEvent.createErrorEvent(this, station, es);
        } else if (-1 == station) {
            event = this.getCurrentStatus().getCachedError((byte)-1);
        } else {
            if (0 < (station & 8)) {
                event = this.getCurrentStatus().getCachedError((byte)8);
            }
            if (0 < (station & 2) && (priority | 8) > 0 && null == event) {
                event = this.getCurrentStatus().getCachedError((byte)2);
            }
            if (!(0 >= (station & 4) && 0 >= (station | 0x14) || null != event || (priority | 8) <= 0 && (priority | 2) <= 0)) {
                event = this.getCurrentStatus().getCachedError((byte)4);
            }
        }
        return event;
    }

    protected void rejectImmediateCmd(PrintCmdList pcl, PrintErrorEvent error) {
        block3: {
            try {
                PrintCmd prtCmd = pcl.getPending();
                if (prtCmd.getParent().handleImmediateError(prtCmd, error)) {
                    this.input.quickRetry(pcl);
                }
            }
            catch (Exception e) {
                if (!DefaultPrinterWriter.getTracer().isOn()) break block3;
                DefaultPrinterWriter.getTracer().getTracerOutput().print("Error Extracting immediate cmd ");
                DefaultPrinterWriter.getTracer().getTracerOutput().print(e);
            }
        }
    }

    protected PrintCmdList createPrintCmdList() {
        return DefaultCmdList.getFactory().createPrintCmdList(this.getMaxCmdLen());
    }

    protected abstract CmdLoadedStatusVisitor getCmdLoadVisitor();

    protected abstract CmdCompleteStatusVisitor getCmdCompleteVisitor();

    protected PrintCmdList findErrorList() {
        PrintCmdList badCl = this.sentQueue.getNextCmdListToComplete();
        int i = 1;
        while (null != badCl && null == badCl.getErrorResponsePending() && null != (badCl = this.sentQueue.getCmdListToComplete(i++))) {
        }
        return badCl;
    }

    protected void delegateError(PrintStatus ps) {
        PrintErrorEvent pe0 = null;
        try {
            if (DefaultPrinterWriter.getTracer().isOn()) {
                DefaultPrinterWriter.print("delegateError<< sq" + ps);
            }
            PrintCmdList badCl = null;
            if (DefaultPrinterWriter.getTracer().isOn()) {
                DefaultPrinterWriter.print("delegateError>>>SWError-->" + ps.getSWError());
            }
            if (null != ps.getSWError()) {
                badCl = this.currentCmd == null ? this.sentQueue.getLastSent() : this.currentCmd;
                pe0 = ps.getSWError();
            } else if (ps.isHardwareError() && (badCl = this.findErrorList()) != null) {
                PrintCmd errorCmd = badCl.getErrorResponsePending();
                if (DefaultPrinterWriter.getTracer().isOn()) {
                    DefaultPrinterWriter.print("ERResponsePending " + badCl.getErrorResponsePending());
                }
                if ((pe0 = ps.getCachedError(errorCmd.getHandleCmd().getImpliedStations())) == null) {
                    ps.recycle();
                    this.errorPending.set(false);
                    return;
                }
            }
            if (null == badCl) {
                if (null != this.currentCmd && ps.getSWError() != null) {
                    this.processSent();
                    badCl = this.currentCmd;
                    this.currentCmd = null;
                } else {
                    ps.recycle();
                    this.errorPending.set(false);
                    this.input.sendNextCmd();
                    return;
                }
            }
            ps.recycle();
            if (this.isOnline()) {
                this.parent.clearBuffers();
                ((IBMPrinterImp)this.mainImp).cancelRotateMode();
            }
            this.fireErrorToHandler(pe0, badCl);
        }
        catch (Exception noParent) {
            if (DefaultPrinterWriter.getTracer().isOn()) {
                DefaultPrinterWriter.print("delegateError Should not be here 2");
            }
            this.errorBlock.set(true);
            this.mainImp.handleError(null, pe0);
            this.errorBlock.set(false);
        }
        this.input.sendNextCmd();
    }

    protected void fireErrorToHandler(PrintErrorEvent pe, PrintCmdList badCl) {
        if (DefaultPrinterWriter.getTracer().isOn()) {
            DefaultPrinterWriter.print(">>fireErrorToHandler");
        }
        Object parent = badCl.getParent();
        PrintCmd printCmd = this.errorCmd = pe.getErrorType() == 2 ? badCl.getErrorResponsePending() : badCl.getResponsePending();
        if (this.errorCmd == null && pe.getPrinterErrorCode() == 256) {
            this.errorCmd = badCl.getPending();
        }
        pe.setOffender(((DefaultPOSPrinterCmd)this.errorCmd.getHandleCmd()).getOwnerCmd());
        if (null != this.currentCmd) {
            this.processSent();
        }
        if (0 == pe.getErrorStation()) {
            pe.setErrorStation(this.errorCmd.getStation());
        }
        if (parent instanceof RetryInputQueue) {
            this.errorBlock.set(true);
            RetryInputQueue pws = (RetryInputQueue)parent;
            pws.handleError(this.errorCmd, pe);
            this.errList.clear();
            this.resendCmds();
            this.errorThread.setActionObject((SharedThreader.ActionObject)pws);
            this.errorBlock.set(false);
            this.errorPending.set(false);
        } else {
            if (DefaultPrinterWriter.getTracer().isOn()) {
                DefaultPrinterWriter.print("delegateError Should not be here 1");
            }
            this.errorBlock.set(true);
            this.mainImp.handleError(this.errorCmd, pe);
            this.resendCmds();
            this.errorBlock.set(false);
        }
        if (DefaultPrinterWriter.getTracer().isOn()) {
            DefaultPrinterWriter.print("<<fireErrorToHandler");
        }
    }

    protected boolean getErrorPending() {
        return this.errorPending.isTrue();
    }

    protected void commandComplete(POSPrinterCmd pospc) {
        if (DefaultPrinterWriter.getTracer().isOn()) {
            DefaultPrinterWriter.print(">>cmdComplete " + pospc);
        }
        if (pospc == null) {
            return;
        }
        PrintCmd pcmd = ((DefaultPOSPrinterCmd)pospc).getPrintCmd();
        if (null == pcmd) {
            pospc.setCompleted(true);
            return;
        }
        pcmd.setSucceeded(true);
        PrinterWriter.PrinterWriterUser pws = pcmd.getParent();
        if (pws == null) {
            POSPrinterCmd err = pcmd.getHandleCmd();
            if (err == null) {
                return;
            }
            err.setCompleted(true);
            err.recycle();
        } else {
            if (pcmd.getHandleCmd().getMasterCmd() == pcmd.getHandleCmd()) {
                this.sentQueue.format();
            }
            pws.handleCmdComplete(pcmd);
        }
    }

    protected void processSent() {
        if (null == this.currentCmd) {
            return;
        }
        if (DefaultPrinterWriter.getTracer().isOn()) {
            DefaultPrinterWriter.print(Thread.currentThread().getName() + ">~~~~~~~~Move~~~~~~~~<" + this.currentCmd);
        }
        if (DefaultPrinterWriter.getTracer().isOn()) {
            this.parent.timeStamp().cmdLoaded(this.currentCmd);
        }
        this.sentQueue.addToContainer(this.currentCmd);
        this.currentCmd = null;
        if (DefaultPrinterWriter.getTracer().isOn()) {
            DefaultPrinterWriter.print(Thread.currentThread().getName() + "<~~~~~~~~Move~~~~~~~~>" + this.currentCmd);
        }
    }

    protected void readExtraData() {
        if (this.getCurrentStatus().isExtendedData()) {
            this.parent.processExtraData(this.getCurrentStatus());
        }
    }

    protected void flush(PrintCmdList pcl) {
        block7: {
            if (null == pcl) {
                return;
            }
            try {
                pcl.setWriteToBuffer(this.getFormattedBuffer());
                ByteBuffer b = pcl.getWriteBuffer();
                if (!this.isOnline()) {
                    return;
                }
                if (DefaultPrinterWriter.getTracer().isOn()) {
                    this.parent.timeStamp().flush(pcl, b);
                }
                this.currentCmd = pcl;
                this.packet.send(b);
                if (pcl.isAutoLoad()) {
                    if (DefaultPrinterWriter.getTracer().isOn()) {
                        DefaultPrinterWriter.print(">>>DOING AUTOLOADING<<<");
                    }
                    this.processSent();
                    this.input.sendNextCmd();
                }
            }
            catch (Exception e) {
                this.logger.addLogEntry(1010, e.toString(), "POSPrinter", 5);
                if (!DefaultPrinterWriter.getTracer().isOn()) break block7;
                DefaultPrinterWriter.getTracer().print(e);
            }
        }
    }

    private PrintCmdList writeErrorCmd(PrintCmdList tCmd) {
        if (!this.isOnline()) {
            if (DefaultPrinterWriter.getTracer().isOn()) {
                DefaultPrinterWriter.print("Offline");
            }
            this.rejectList(tCmd);
            return null;
        }
        if (tCmd.compareStations(this.lastStatus.getErrorStation())) {
            if (DefaultPrinterWriter.getTracer().isOn()) {
                DefaultPrinterWriter.print("Restructuring");
            }
            PrintCmdList ncurrent = this.createPrintCmdList();
            tCmd.restructure(ncurrent, this.lastStatus.getErrorStation());
            this.sentQueue.format();
            if (!ncurrent.hasCommands()) {
                if (DefaultPrinterWriter.getTracer().isOn()) {
                    DefaultPrinterWriter.print("Restructuring none can filter");
                }
                this.rejectList(tCmd);
                return null;
            }
            if (!tCmd.hasCommands()) {
                tCmd.recycle();
            } else {
                tCmd.reset();
                this.input.quickRetry(tCmd);
            }
            tCmd = ncurrent;
        }
        return tCmd;
    }

    private void rejectList(PrintCmdList tCmd) {
        block3: {
            tCmd.setError(true);
            DefaultPOSPrinterCmd c = (DefaultPOSPrinterCmd)tCmd.getPending().getHandleCmd();
            PrintErrorEvent event = null;
            event = c.getOwnerCmd().getStation() == 0 ? this.setPostErrorEvent((byte)2, (byte)2) : this.setPostErrorEvent(c.getOwnerCmd().getStation(), c.getStation());
            PrintCmdList temp = tCmd;
            tCmd = null;
            temp.reset();
            this.input.quickRetry(temp);
            this.fireErrorToHandler(event, temp);
            try {
                if (this.isOnline()) {
                    this.parent.clearBuffers();
                    ((IBMPrinterImp)this.mainImp).cancelRotateMode();
                }
            }
            catch (HandleException he) {
                if (!DefaultPrinterWriter.getTracer().isOn()) break block3;
                DefaultPrinterWriter.getTracer().print((Exception)he);
            }
        }
        this.input.sendNextCmd();
    }

    private void resendCmds() {
        block3: {
            if (DefaultPrinterWriter.getTracer().isOn()) {
                DefaultPrinterWriter.print("resending cmds");
            }
            this.input.resendCmds();
            try {
                this.sentQueue.resendCmds();
            }
            catch (Exception e) {
                if (!DefaultPrinterWriter.getTracer().isOn()) break block3;
                DefaultPrinterWriter.getTracer().print(e);
            }
        }
    }

    static class WriterKey
    implements HandleKey {
        private String string = "WriterKey";

        WriterKey() {
        }

        public void accept(HandleKeyVisitor visitor) {
            visitor.visitUnknownHandleKey(this);
        }

        public String toString() {
            return this.string;
        }

        public int hashCode() {
            return this.string.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj == null || !(obj instanceof WriterKey)) {
                return false;
            }
            return obj.toString().equals(this.string);
        }

        public DevCat getDevCat() {
            return DevCats.UNKNOWN_DEVCAT;
        }

        public DevBus getDevBus() {
            return DevBuses.UNKNOWN_DEVBUS;
        }
    }

    private class DefaultOuputWriterInterface
    implements OutputProcessor.WriterInterface {
        private DefaultOuputWriterInterface() {
        }

        public void forceLoad() {
            DefaultPrinterWriter.this.processSent();
        }

        public CmdCompleteStatusVisitor getCmdCompleteVisitor() {
            return DefaultPrinterWriter.this.getCmdCompleteVisitor();
        }

        public CmdLoadedStatusVisitor getCmdLoadVisitor() {
            return DefaultPrinterWriter.this.getCmdLoadVisitor();
        }

        public boolean getErrorPending() {
            return DefaultPrinterWriter.this.getErrorPending();
        }

        public SubmissionContainer getSentQueue() {
            return DefaultPrinterWriter.this.sentQueue;
        }

        public boolean isStatusPending() {
            return DefaultPrinterWriter.this.isStatusPending();
        }

        public void setError(PrintStatus e) {
            if (null != e) {
                if (null != (e = (PrintStatus)e.clone()).getSWError()) {
                    PrinterWriter.getTracer().println("-----directreport-----");
                    DefaultPrinterWriter.this.delegateError(e);
                }
                if (!DefaultPrinterWriter.this.errList.isEmpty()) {
                    PrintStatus p1 = (PrintStatus)DefaultPrinterWriter.this.errList.get(DefaultPrinterWriter.this.errList.size() - 1);
                    if (!p1.errorCompare(e)) {
                        PrinterWriter.getTracer().println("appending error 1 " + e);
                        DefaultPrinterWriter.this.errorPending.set(true);
                        DefaultPrinterWriter.this.errList.add(e);
                        DefaultPrinterWriter.this.errorScheduler.post((Task)DefaultPrinterWriter.this.errorTask);
                    }
                } else {
                    PrinterWriter.getTracer().println("appending error 2 " + e);
                    DefaultPrinterWriter.this.errorPending.set(true);
                    DefaultPrinterWriter.this.errList.add(e);
                    DefaultPrinterWriter.this.errorScheduler.post((Task)DefaultPrinterWriter.this.errorTask);
                }
            }
        }

        public void sendNext() {
            if (PrinterWriter.getTracer().isOn()) {
                PrinterWriter.getTracer().println("sendnext");
            }
            DefaultPrinterWriter.this.input.sendNextCmd();
        }
    }

    private class ErrorTask
    extends AbstractTask {
        private ErrorTask() {
        }

        public void executeTask() {
            block14: {
                if (DefaultPrinterWriter.this.errList.isEmpty()) {
                    if (PrinterWriter.getTracer().isOn()) {
                        PrinterWriter.getTracer().println("All errors apparently have been cleared!!!!!");
                    }
                    return;
                }
                try {
                    do {
                        if (PrinterWriter.getTracer().isOn()) {
                            PrinterWriter.print("Error task posted<---------------------");
                        }
                        try {
                            DefaultPrinterWriter.this.errorPause.set(true);
                            DefaultPrinterWriter.this.errorPause.waitForFalse(PrinterWriter.NONRESPONDING_TIMEOUT);
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                    } while (!DefaultPrinterWriter.this.errorPause.isTrue());
                    if (PrinterWriter.getTracer().isOn()) {
                        PrinterWriter.print("Error task posted--------------------->");
                    }
                    if (0 < DefaultPrinterWriter.this.sentQueue.size()) {
                        while (DefaultPrinterWriter.this.errList.size() > 0) {
                            DefaultPrinterWriter.this.delegateError((PrintStatus)DefaultPrinterWriter.this.errList.remove(0));
                        }
                    } else {
                        if (PrinterWriter.getTracer().isOn()) {
                            PrinterWriter.print("Empty resetting error ");
                        }
                        DefaultPrinterWriter.this.errorPending.set(false);
                        if (!DefaultPrinterWriter.this.errList.isEmpty()) {
                            DefaultPrinterWriter.this.errList.remove(0);
                        }
                        DefaultPrinterWriter.this.input.sendNextCmd();
                    }
                }
                catch (Exception e) {
                    if (!PrinterWriter.getTracer().isOn()) break block14;
                    PrinterWriter.getTracer().print(e);
                }
            }
        }
    }
}

