/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.posj.printer.parser.ibm4689;

import com.ibm.jutil.ByteBuffer;
import com.ibm.jutil.ByteEncoder;
import com.ibm.jutil.Util;
import com.ibm.jutil.tracing.Tracer;
import com.ibm.jutil.tracing.TracerFactory;
import com.ibm.posj.POSPrinterCmd;
import com.ibm.posj.bus.printer.cmds.ibm4689.Cmd4689;
import com.ibm.posj.printer.parser.DefaultPrinterEscCmdV;
import com.ibm.posj.printer.parser.ParserLine;
import com.ibm.posj.printer.parser.PrinterEscCmd;
import com.ibm.posj.printer.parser.PrinterEscCmdProcessor;
import com.ibm.posj.printer.parser.PrinterParserElement;
import com.ibm.posj.printer.parser.PrinterParserEscCmd;
import com.ibm.posj.printer.parser.PrinterParserLine;
import com.ibm.posj.printer.parser.ibm4689.Printer4689PropertiesManager;
import java.util.ArrayList;
import java.util.List;

public class Printer4689ParserLine
extends PrinterParserLine
implements ParserLine {
    private LeftText leftText = null;
    private CenterText centerText = null;
    private RightText rightText = null;
    private Cmd4689 cmdBytes = new Cmd4689();
    private boolean dataTruncated = false;
    private ByteBuffer highMagnificationChars = null;
    private static Tracer parserTracer = TracerFactory.getInstance().createTracer("POSPrinter", "4689ParserLine");
    Printer4689PropertiesManager propMngr = null;
    AppendPropertyVisitor appendVisitor = new AppendPropertyVisitor();
    private ByteBuffer lineMasterText = ByteBuffer.getByteBufferFactory().createByteBuffer();

    public Printer4689ParserLine(PrinterEscCmdProcessor escCmdProc) {
        super(escCmdProc);
    }

    public void buildLineMasterCmd(boolean addLineFeedAtTheEnd) {
        this.lineMasterText.reset();
        if (Printer4689ParserLine.getTracer().isOn()) {
            this.trace("buildLineMasterCmd >>");
        }
        int leftTextLimit = this.getLeftText().isTextPresent() ? this.getLeftText().getRightLimit() : 0;
        int rightTextLimit = this.getRightText().isTextPresent() ? this.getRightText().getLeftLimit() : 0;
        int spaces = 0;
        if (this.getLeftText().isTextPresent()) {
            if (Printer4689ParserLine.getTracer().isOn()) {
                this.trace("LeftText().isTextPresent()");
            }
            this.appendAlignedText((IBM4689AlignedText)this.getLeftText());
        }
        if (this.getCenterText().isTextPresent()) {
            if (Printer4689ParserLine.getTracer().isOn()) {
                this.trace("CenterText().isTextPresent()");
            }
            int leftChars = 0;
            if (this.getLeftText().isTextPresent()) {
                leftChars = this.getLeftText().getTextSize();
                if (leftTextLimit < this.getState().getLineChars(this.getStation()) / 2) {
                    spaces = this.getCenterText().getLeftLimit() - leftChars;
                }
            } else {
                spaces = (this.getState().getLineChars(this.getStation()) - this.getCenterText().getTextSize()) / 2;
            }
            ((LineElement)((IBM4689AlignedText)this.getCenterText()).getElemList().get(0)).setAlignSpaces(spaces);
            this.appendAlignedText((IBM4689AlignedText)this.getCenterText());
        }
        if (this.getRightText().isTextPresent()) {
            if (Printer4689ParserLine.getTracer().isOn()) {
                this.trace("RightText().isTextPresent()");
            }
            spaces = this.getState().getLineChars(this.getStation()) - rightTextLimit - this.getRightText().getTextSize();
            ((LineElement)((IBM4689AlignedText)this.getRightText()).getElemList().get(0)).setAlignSpaces(spaces);
            this.appendAlignedText((IBM4689AlignedText)this.getRightText());
        }
        this.lineMasterText.append(this.getHighMagnificationChars());
        this.highMagnificationChars.reset();
        if (!this.getPropMngr().isDoubleHigh()) {
            this.getPropMngr().setLineHighMagnification((byte)0);
        }
        if (Printer4689ParserLine.getTracer().isOn()) {
            this.trace("buildLineMasterCmd <<");
        }
    }

    public int appendElement(PrinterParserElement parserElement) {
        if (Printer4689ParserLine.getTracer().isOn()) {
            this.trace("appendElement >>");
        }
        int appendedChars = 0;
        IBM4689AlignedText alignedText = (IBM4689AlignedText)this.getAlignedText();
        LineElement lineElem = alignedText.getCurrentLineElement();
        if (parserElement.getElementType() == 2) {
            PrinterParserEscCmd parserEscCmd = (PrinterParserEscCmd)parserElement;
            if (parserEscCmd.isProperty()) {
                PrinterEscCmd escCmd = ((PrinterParserEscCmd)parserElement).getEscCmd();
                try {
                    alignedText.createNewElement();
                    this.updateState((PrinterParserEscCmd)parserElement);
                    escCmd.accept(this.getAppendVisitor());
                }
                catch (IllegalArgumentException e) {
                    if (Printer4689ParserLine.getTracer().isOn()) {
                        this.trace(e.toString());
                    }
                }
                catch (IllegalAccessException e) {
                    if (Printer4689ParserLine.getTracer().isOn()) {
                        this.trace(e.toString());
                    }
                }
            }
        } else if (parserElement.getElementType() == 1 || parserElement.getElementType() == 5) {
            if (Printer4689ParserLine.getTracer().isOn()) {
                this.trace("element type is = " + parserElement.getElementType());
            }
            appendedChars = alignedText.appendText(parserElement);
            this.charsInLine += appendedChars * this.getWideMagnification();
            if (this.charsInLine >= this.getState().getLineChars(this.getStation())) {
                this.lineCompleted = true;
            }
        }
        if (Printer4689ParserLine.getTracer().isOn()) {
            this.trace("Printer4689ParserLine.appendElement <<");
        }
        return appendedChars;
    }

    public void reset() {
        super.reset();
        this.getPropMngr().reset();
        this.resetText();
        this.getHighMagnificationChars().reset();
    }

    public void resetText() {
        if (Printer4689ParserLine.getTracer().isOn()) {
            this.trace("resetText");
        }
        this.charsInLine = 0;
        this.lineMasterText.reset();
        this.lineCompleted = false;
        ((IBM4689AlignedText)this.getLeftText()).init();
        ((IBM4689AlignedText)this.getCenterText()).init();
        ((IBM4689AlignedText)this.getRightText()).init();
    }

    public PrinterParserLine.AlignedText getCenterText() {
        if (this.centerText == null) {
            this.centerText = new CenterText();
        }
        return this.centerText;
    }

    public PrinterParserLine.AlignedText getLeftText() {
        if (this.leftText == null) {
            this.leftText = new LeftText();
        }
        return this.leftText;
    }

    public PrinterParserLine.AlignedText getRightText() {
        if (this.rightText == null) {
            this.rightText = new RightText();
        }
        return this.rightText;
    }

    public ByteBuffer getLineMasterText() {
        return this.lineMasterText;
    }

    public AppendPropertyVisitor getAppendVisitor() {
        return this.appendVisitor;
    }

    public boolean isDataTruncated() {
        return this.dataTruncated;
    }

    public void setDataTruncated(boolean dataTruncated) {
        this.dataTruncated = dataTruncated;
    }

    public ByteBuffer getHighMagnificationChars() {
        if (this.highMagnificationChars == null) {
            this.highMagnificationChars = ByteBuffer.getByteBufferFactory().createByteBuffer();
        }
        return this.highMagnificationChars;
    }

    protected void appendAlignedText(IBM4689AlignedText alignedText) {
        List elemList = alignedText.getElemList();
        if (Printer4689ParserLine.getTracer().isOn()) {
            this.trace("appendAlignedText elemList.size() = " + elemList.size());
        }
        for (int i = 0; i < elemList.size(); ++i) {
            byte elemType = ((LineElement)elemList.get(i)).getElementType();
            LineElement e = (LineElement)elemList.get(i);
            if (e.getAlignSpaces() > 0) {
                this.lineMasterText.append(this.createSpacesBuffer(e.getAlignSpaces()));
            }
            this.appendTextProperties(e);
            if (e.getPropMngr().isDoubleHigh()) {
                if (e.getPropMngr().isDoubleWide()) {
                    this.addDoubleHighWideChars(e.getText().getByteCount());
                } else {
                    this.addDoubleHighChars(e.getText().getByteCount());
                }
            } else if (!e.getPropMngr().isDoubleHigh() && this.getPropMngr().getLineHighMagnification() == 3 && e.getText().getByteCount() > 0) {
                this.getHighMagnificationChars().append(this.createSpacesBuffer(e.getText().getByteCount()));
            }
            if (e.getPropMngr().isDoubleWide()) {
                e.setText(this.addDoubleWideChars(e.getText()));
            }
            this.lineMasterText.append(e.getText());
        }
    }

    protected Printer4689PropertiesManager getPropMngr() {
        if (this.propMngr == null) {
            this.propMngr = new Printer4689PropertiesManager();
        }
        return this.propMngr;
    }

    protected int getWideMagnification() {
        byte magnification = this.getState().getFontWideMagnification(this.getStation());
        if (magnification < 1) {
            throw new IllegalArgumentException("Invalid wide maginification");
        }
        return magnification;
    }

    protected void trace(String s) {
        if (Printer4689ParserLine.getTracer().isOn()) {
            Printer4689ParserLine.getTracer().println(3, s);
        }
    }

    protected static Tracer getTracer() {
        return parserTracer;
    }

    private void appendTextProperties(LineElement elem) {
        if (elem.getPropMngr().isNormalMode()) {
            if (elem.getText().getByteCount() > 0) {
                if (Printer4689ParserLine.getTracer().isOn()) {
                    this.trace("IS NORMAL MODE!");
                }
                this.lineMasterText.append(this.cmdBytes.NORMAL_MODE);
            }
        } else {
            if (elem.getPropMngr().isBold()) {
                this.lineMasterText.append(this.cmdBytes.EMPHASIZE_MODE);
            }
            if (elem.getPropMngr().isUnderline()) {
                this.lineMasterText.append(this.cmdBytes.UNDERLINE_MODE);
            }
            if (elem.getPropMngr().isReverseVideo()) {
                this.lineMasterText.append(this.cmdBytes.REVERSE_VIDEO);
            }
            if (elem.getPropMngr().isDoubleHigh()) {
                if (elem.getPropMngr().isDoubleWide()) {
                    this.lineMasterText.append(this.cmdBytes.DOUBLE_HIGH_WIDE_MODE);
                } else {
                    this.lineMasterText.append(this.cmdBytes.DOUBLE_HIGH_MODE);
                }
            } else if (elem.getPropMngr().isDoubleWide()) {
                this.lineMasterText.append(this.cmdBytes.DOUBLE_WIDE_MODE);
            }
        }
    }

    private ByteBuffer createSpacesBuffer(int spaces) {
        if (Printer4689ParserLine.getTracer().isOn()) {
            this.trace("addSpaces >>");
        }
        if (Printer4689ParserLine.getTracer().isOn()) {
            this.trace("spaces to add = " + spaces);
        }
        if (spaces <= 0) {
            throw new IllegalArgumentException("0 is an illegal argument in createSpacesBuffer");
        }
        ByteBuffer tmp = ByteBuffer.getByteBufferFactory().createByteBuffer();
        tmp.append(this.cmdBytes.CHAR_ATTRB_NORMAL);
        for (int i = 0; i < spaces; ++i) {
            tmp.append(32);
        }
        return tmp;
    }

    private ByteBuffer addDoubleWideChars(ByteBuffer text) {
        ByteEncoder bEnc;
        int count;
        int bufferPosition;
        block7: {
            bufferPosition = 1;
            count = text.getByteCount();
            bEnc = null;
            try {
                bEnc = this.getEscCmdProcessor().getByteEncoder();
            }
            catch (IllegalAccessException iaE) {
                if (!Printer4689ParserLine.getTracer().isOn()) break block7;
                this.trace("IllegalAccessException caught");
            }
        }
        for (int i = 1; i < count; ++i) {
            if (bEnc.isDBCSChar(text, bufferPosition - 1)) {
                if (++bufferPosition >= text.getByteCount()) {
                    text.append(0);
                    text.append(0);
                } else {
                    ++i;
                    text.insert((byte)0, bufferPosition++);
                    text.insert((byte)0, bufferPosition);
                }
            } else {
                text.insert((byte)0, bufferPosition);
            }
            bufferPosition += 2;
        }
        text.append(0);
        return text;
    }

    private void addDoubleHighChars(int count) {
        this.getHighMagnificationChars().append(this.cmdBytes.LINE_ATTRB_NORMAL);
        for (int i = 0; i < count; ++i) {
            this.getHighMagnificationChars().append(this.cmdBytes.DOUBLE_HIGH_MODE);
            this.getHighMagnificationChars().append(0);
        }
    }

    private void addDoubleHighWideChars(int count) {
        this.getHighMagnificationChars().append(this.cmdBytes.LINE_ATTRB_NORMAL);
        for (int i = 0; i < count; ++i) {
            this.getHighMagnificationChars().append(this.cmdBytes.DOUBLE_HIGH_WIDE_MODE);
            this.getHighMagnificationChars().append(0);
        }
    }

    class AppendPropertyVisitor
    extends DefaultPrinterEscCmdV {
        AppendPropertyVisitor() {
        }

        public POSPrinterCmd getPOSPrinterCmd() {
            return null;
        }

        public void reset() {
            Printer4689ParserLine.this.getPropMngr().reset();
        }

        public void visitBoldEscCmd(PrinterEscCmd cmd) throws IllegalAccessException, IllegalArgumentException {
            Printer4689ParserLine.this.getPropMngr().setBold(true);
        }

        public void visitCenterEscCmd(PrinterEscCmd cmd) throws IllegalAccessException, IllegalArgumentException {
            super.visitCenterEscCmd(cmd);
        }

        public void visitHighWideControlEscCmd(PrinterEscCmd cmd) throws IllegalAccessException, IllegalArgumentException {
            switch (cmd.getParameter()) {
                case 1: {
                    Printer4689ParserLine.this.getPropMngr().setDoubleHigh(false);
                    Printer4689ParserLine.this.getPropMngr().setDoubleWide(false);
                    break;
                }
                case 3: {
                    Printer4689ParserLine.this.getPropMngr().setDoubleHigh(true);
                    break;
                }
                case 2: {
                    Printer4689ParserLine.this.getPropMngr().setDoubleWide(true);
                    break;
                }
                case 4: {
                    Printer4689ParserLine.this.getPropMngr().setDoubleHigh(true);
                    Printer4689ParserLine.this.getPropMngr().setDoubleWide(true);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("wrong HighWideControl argument");
                }
            }
        }

        public void visitNormalEscCmd(PrinterEscCmd cmd) throws IllegalAccessException, IllegalArgumentException {
            if (Printer4689ParserLine.getTracer().isOn()) {
                Printer4689ParserLine.this.trace("visitNormalEscCmd");
            }
            Printer4689ParserLine.this.getPropMngr().reset();
        }

        public void visitNormalDataCmd(PrinterEscCmd cmd) throws IllegalAccessException, IllegalArgumentException {
            if (Printer4689ParserLine.getTracer().isOn()) {
                Printer4689ParserLine.this.trace("visitNormalData");
            }
            Printer4689ParserLine.this.getPropMngr().reset();
        }

        public void visitReverseVideoEscCmd(PrinterEscCmd cmd) throws IllegalAccessException, IllegalArgumentException {
            Printer4689ParserLine.this.getPropMngr().setReverseVideo(true);
        }

        public void visitRightJustifyEscCmd(PrinterEscCmd cmd) throws IllegalAccessException, IllegalArgumentException {
            super.visitRightJustifyEscCmd(cmd);
        }

        public void visitScaleHorizontallyEscCmd(PrinterEscCmd cmd) throws IllegalAccessException, IllegalArgumentException {
            if (cmd.getClosestParameter() > 1) {
                Printer4689ParserLine.this.getPropMngr().setDoubleWide(true);
            }
        }

        public void visitScaleVerticallyEscCmd(PrinterEscCmd cmd) throws IllegalAccessException, IllegalArgumentException {
            if (cmd.getClosestParameter() > 1) {
                Printer4689ParserLine.this.getPropMngr().setDoubleHigh(true);
            }
        }

        public void visitUnderlineEscCmd(PrinterEscCmd cmd) throws IllegalAccessException, IllegalArgumentException {
            if (cmd.getClosestParameter() > 0) {
                Printer4689ParserLine.this.getPropMngr().setUnderline(true);
            }
        }
    }

    class LineElement
    extends PrinterParserElement {
        private int lineElemType = 0;
        private Printer4689PropertiesManager propMngr;
        private PrinterParserEscCmd cmd = null;
        private ByteBuffer text = null;
        private int alignSpaces = 0;

        public LineElement(PrinterEscCmdProcessor escCmdProc) {
            super(escCmdProc);
            this.lineElemType = 0;
        }

        public LineElement(PrinterParserEscCmd cmd) {
            this.lineElemType = 2;
            this.cmd = cmd;
        }

        public LineElement(ByteBuffer text) {
            this.lineElemType = 1;
            this.text = text;
        }

        public LineElement(ByteBuffer text, int type) {
            this.lineElemType = type;
            this.text = text;
        }

        public void setText(byte[] array, int length, int index) {
            if (Printer4689ParserLine.getTracer().isOn()) {
                Printer4689ParserLine.this.trace("LineElement setText >>");
            }
            this.lineElemType = 1;
            if (Printer4689ParserLine.getTracer().isOn()) {
                Printer4689ParserLine.this.trace("length = " + length + "   index = " + index);
            }
            byte[] tmp = new byte[length];
            System.arraycopy(array, index, tmp, 0, length);
            if (Printer4689ParserLine.getTracer().isOn()) {
                Printer4689ParserLine.this.trace("text = " + Util.toFormatedHexString((byte[])tmp));
            }
            this.getText().reset();
            this.getText().append(tmp);
            if (Printer4689ParserLine.getTracer().isOn()) {
                Printer4689ParserLine.this.trace("LineElement setText << ");
            }
        }

        public ByteBuffer getText() {
            if (this.text == null) {
                this.text = ByteBuffer.getByteBufferFactory().createByteBuffer();
            }
            return this.text;
        }

        public void setText(ByteBuffer text) {
            if (text == null) {
                throw new IllegalArgumentException("argument should not be null");
            }
            this.text = text;
        }

        public Printer4689PropertiesManager getPropMngr() {
            if (this.propMngr == null) {
                if (Printer4689ParserLine.getTracer().isOn()) {
                    Printer4689ParserLine.this.trace("propMngr == null");
                }
                this.propMngr = new Printer4689PropertiesManager();
                this.propMngr.setProperties(Printer4689ParserLine.this.getPropMngr());
            }
            return this.propMngr;
        }

        public void setPropMngr(Printer4689PropertiesManager propMngr) {
            this.getPropMngr().setProperties(propMngr);
        }

        public int getAlignSpaces() {
            return this.alignSpaces;
        }

        public void setAlignSpaces(int alignSpaces) {
            this.alignSpaces = alignSpaces;
        }
    }

    class RightText
    extends IBM4689AlignedText {
        public RightText() {
            this.setLeftLimit(this.getLeftLimit());
            this.setRightLimit(this.getRightLimit());
        }

        protected void updateLimits(int amount) {
            int lineWidth = Printer4689ParserLine.this.getState().getLineChars(Printer4689ParserLine.this.getStation());
            int rightRightLimit = lineWidth - amount;
            this.setInitialPosition(rightRightLimit);
            Printer4689ParserLine.this.getCenterText().setRightLimit(rightRightLimit);
            if (!Printer4689ParserLine.this.getCenterText().isTextPresent()) {
                Printer4689ParserLine.this.getLeftText().setRightLimit(rightRightLimit);
            }
        }
    }

    class CenterText
    extends IBM4689AlignedText {
        public CenterText() {
            this.setLeftLimit(this.getLeftLimit());
            this.setRightLimit(this.getRightLimit());
        }

        protected void updateLimits(int amount) {
            int lineWidth = Printer4689ParserLine.this.getState().getLineChars(Printer4689ParserLine.this.getStation());
            int centerLeftLimit = (lineWidth - amount) / 2;
            int centerRightLimit = (lineWidth + amount) / 2;
            this.setLeftLimit(centerLeftLimit);
            this.setRightLimit(centerRightLimit);
            this.setInitialPosition(centerLeftLimit);
            Printer4689ParserLine.this.getLeftText().setRightLimit(centerLeftLimit);
            Printer4689ParserLine.this.getRightText().setLeftLimit(centerRightLimit);
        }
    }

    class LeftText
    extends IBM4689AlignedText {
        public LeftText() {
            this.setLeftLimit(this.getLeftLimit());
            this.setRightLimit(this.getRightLimit());
        }

        protected void updateLimits(int amount) {
            int lineWidth = Printer4689ParserLine.this.getState().getLineChars(Printer4689ParserLine.this.getStation());
            Printer4689ParserLine.this.getCenterText().setLeftLimit(amount);
            Printer4689ParserLine.this.getCenterText().setRightLimit(lineWidth - amount);
            if (!Printer4689ParserLine.this.getCenterText().isTextPresent()) {
                Printer4689ParserLine.this.getRightText().setLeftLimit(amount);
            }
        }
    }

    public abstract class IBM4689AlignedText
    extends PrinterParserLine.AlignedText {
        List elemList = new ArrayList();
        private int listIndex = 0;

        public void init() {
            this.reset();
            this.setLeftLimit(0);
            this.setRightLimit(Printer4689ParserLine.this.getState().getLineChars(Printer4689ParserLine.this.getStation()));
            this.listIndex = 0;
            this.textSize = 0;
            this.elemList = new ArrayList();
        }

        public List getElemList() {
            return this.elemList;
        }

        public LineElement getCurrentLineElement() {
            block3: {
                try {
                    if (this.elemList.isEmpty() || this.listIndex >= this.elemList.size()) {
                        this.elemList.add(this.listIndex, new LineElement(Printer4689ParserLine.this.getEscCmdProcessor()));
                    }
                }
                catch (IllegalAccessException iaE) {
                    if (!Printer4689ParserLine.getTracer().isOn()) break block3;
                    Printer4689ParserLine.getTracer().println("null escCmdProcessor");
                }
            }
            ((LineElement)this.getElemList().get(this.listIndex)).setPropMngr(Printer4689ParserLine.this.getPropMngr());
            return (LineElement)this.getElemList().get(this.listIndex);
        }

        public void createNewElement() {
            block2: {
                ++this.listIndex;
                try {
                    LineElement newElem = new LineElement(Printer4689ParserLine.this.getEscCmdProcessor());
                    this.elemList.add(this.listIndex, newElem);
                }
                catch (IllegalAccessException iaE) {
                    if (!Printer4689ParserLine.getTracer().isOn()) break block2;
                    Printer4689ParserLine.getTracer().println("null escCmdProcessor");
                }
            }
            this.getCurrentLineElement();
        }

        public int getTextSize() {
            return super.getTextSize() * Printer4689ParserLine.this.getPropMngr().getWideMagnification();
        }

        protected void appendCmd(PrinterParserEscCmd escCmd) {
            LineElement elem = new LineElement(escCmd);
            ++this.listIndex;
            this.getElemList().add(this.listIndex++, elem);
        }

        protected int appendText(PrinterParserElement parserElem) {
            if (Printer4689ParserLine.getTracer().isOn()) {
                Printer4689ParserLine.this.trace("appendText >>");
            }
            int charsToAppend = 0;
            if (this.getFreeSpace() > 0) {
                int freeSpace = this.getFreeSpace() / Printer4689ParserLine.this.getWideMagnification();
                if (Printer4689ParserLine.getTracer().isOn()) {
                    Printer4689ParserLine.this.trace("getFreeSpace() = " + this.getFreeSpace());
                }
                charsToAppend = parserElem.getLength() > freeSpace ? freeSpace : parserElem.getLength();
                if (Printer4689ParserLine.this.getCharsInLine() + charsToAppend > Printer4689ParserLine.this.getState().getMaxPrintChars(Printer4689ParserLine.this.getStation())) {
                    charsToAppend = Printer4689ParserLine.this.getState().getMaxPrintChars(Printer4689ParserLine.this.getStation()) - Printer4689ParserLine.this.getCharsInLine();
                }
                if (charsToAppend < parserElem.getLength() && parserElem.isDBCSChar(charsToAppend)) {
                    --charsToAppend;
                }
                parserElem.setCharsToPrint(charsToAppend);
                Printer4689ParserLine.this.dataTruncated = parserElem.isDataTruncated();
                if (Printer4689ParserLine.getTracer().isOn()) {
                    Printer4689ParserLine.this.trace("parserElem.isDataTruncated? = " + parserElem.isDataTruncated());
                }
                if (charsToAppend < parserElem.getLength()) {
                    Printer4689ParserLine.this.dataTruncated = true;
                    if (Printer4689ParserLine.getTracer().isOn()) {
                        Printer4689ParserLine.this.trace("seting dataTruncated = " + Printer4689ParserLine.this.dataTruncated);
                    }
                }
                if (charsToAppend > 0) {
                    if (Printer4689ParserLine.getTracer().isOn()) {
                        Printer4689ParserLine.this.trace("charsToAppend = " + charsToAppend);
                    }
                    this.getCurrentLineElement().setText(parserElem.getBytesRef(), charsToAppend, parserElem.getIndex());
                    this.increaseTextSize(charsToAppend);
                    if (Printer4689ParserLine.getTracer().isOn()) {
                        Printer4689ParserLine.this.trace("getTextSize = " + this.getTextSize());
                    }
                    this.updateLimits(charsToAppend * Printer4689ParserLine.this.getWideMagnification());
                }
            } else if (Printer4689ParserLine.getTracer().isOn()) {
                Printer4689ParserLine.this.trace("freeSpace = 0 ");
            }
            if (Printer4689ParserLine.getTracer().isOn()) {
                Printer4689ParserLine.this.trace("appendText << ");
            }
            return charsToAppend;
        }

        protected void completeTextMasterCommand() {
        }

        protected int getFreeSpace() {
            int freeSpace = 0;
            int align = 0;
            try {
                align = Printer4689ParserLine.this.getEscCmdProcessor().getParserState().getAlignment(Printer4689ParserLine.this.getStation());
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            switch (align) {
                case 0: {
                    freeSpace = super.getFreeSpace();
                }
                case 1: {
                    freeSpace = ((IBM4689AlignedText)Printer4689ParserLine.this.getCenterText()).getRightLimit() - ((IBM4689AlignedText)Printer4689ParserLine.this.getCenterText()).getLeftLimit() - ((IBM4689AlignedText)Printer4689ParserLine.this.getCenterText()).getTextSize();
                }
                case 2: {
                    freeSpace = ((IBM4689AlignedText)Printer4689ParserLine.this.getRightText()).getRightLimit() - ((IBM4689AlignedText)Printer4689ParserLine.this.getRightText()).getLeftLimit() - ((IBM4689AlignedText)Printer4689ParserLine.this.getRightText()).getTextSize();
                }
            }
            return freeSpace;
        }
    }
}

