/*
 * Decompiled with CFR 0.152.
 */
package jpos;

import java.util.Vector;
import jpos.BaseControl;
import jpos.BaseJposControl;
import jpos.JposConst;
import jpos.JposException;
import jpos.LineDisplayControl19;
import jpos.events.DataEvent;
import jpos.events.DirectIOEvent;
import jpos.events.DirectIOListener;
import jpos.events.ErrorEvent;
import jpos.events.OutputCompleteEvent;
import jpos.events.StatusUpdateEvent;
import jpos.events.StatusUpdateListener;
import jpos.services.BaseService;
import jpos.services.EventCallbacks;
import jpos.services.LineDisplayService12;
import jpos.services.LineDisplayService13;
import jpos.services.LineDisplayService14;
import jpos.services.LineDisplayService15;
import jpos.services.LineDisplayService16;
import jpos.services.LineDisplayService17;
import jpos.services.LineDisplayService18;
import jpos.services.LineDisplayService19;

public class LineDisplay
extends BaseJposControl
implements LineDisplayControl19,
JposConst {
    protected LineDisplayService12 service12;
    protected LineDisplayService13 service13;
    protected LineDisplayService14 service14;
    protected LineDisplayService15 service15;
    protected LineDisplayService16 service16;
    protected LineDisplayService17 service17;
    protected LineDisplayService18 service18;
    protected LineDisplayService19 service19;
    protected Vector directIOListeners;
    protected Vector statusUpdateListeners;

    public LineDisplay() {
        this.deviceControlDescription = "JavaPOS LineDisplay Device Control";
        this.deviceControlVersion = 1009000;
        this.directIOListeners = new Vector();
        this.statusUpdateListeners = new Vector();
    }

    public int getCapBlink() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            return this.service12.getCapBlink();
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public boolean getCapBrightness() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            return this.service12.getCapBrightness();
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public int getCapCharacterSet() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            return this.service12.getCapCharacterSet();
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public boolean getCapDescriptors() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            return this.service12.getCapDescriptors();
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public boolean getCapHMarquee() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            return this.service12.getCapHMarquee();
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public boolean getCapICharWait() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            return this.service12.getCapICharWait();
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public boolean getCapVMarquee() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            return this.service12.getCapVMarquee();
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public int getCapPowerReporting() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        if (this.serviceVersion < 1003000) {
            throw new JposException(104, "Device Service is not 1.3.0 compliant.");
        }
        try {
            return this.service13.getCapPowerReporting();
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public boolean getCapBlinkRate() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        if (this.serviceVersion < 1006000) {
            throw new JposException(104, "Device Service is not 1.6.0 compliant.");
        }
        try {
            return this.service16.getCapBlinkRate();
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public int getCapCursorType() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        if (this.serviceVersion < 1006000) {
            throw new JposException(104, "Device Service is not 1.6.0 compliant.");
        }
        try {
            return this.service16.getCapCursorType();
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public boolean getCapCustomGlyph() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        if (this.serviceVersion < 1006000) {
            throw new JposException(104, "Device Service is not 1.6.0 compliant.");
        }
        try {
            return this.service16.getCapCustomGlyph();
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public int getCapReadBack() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        if (this.serviceVersion < 1006000) {
            throw new JposException(104, "Device Service is not 1.6.0 compliant.");
        }
        try {
            return this.service16.getCapReadBack();
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public int getCapReverse() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        if (this.serviceVersion < 1006000) {
            throw new JposException(104, "Device Service is not 1.6.0 compliant.");
        }
        try {
            return this.service16.getCapReverse();
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public boolean getCapBitmap() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        if (this.serviceVersion < 1007000) {
            throw new JposException(104, "Device Service is not 1.7.0 compliant.");
        }
        try {
            return this.service17.getCapBitmap();
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public boolean getCapMapCharacterSet() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        if (this.serviceVersion < 1007000) {
            throw new JposException(104, "Device Service is not 1.7.0 compliant.");
        }
        try {
            return this.service17.getCapMapCharacterSet();
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public boolean getCapScreenMode() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        if (this.serviceVersion < 1007000) {
            throw new JposException(104, "Device Service is not 1.7.0 compliant.");
        }
        try {
            return this.service17.getCapScreenMode();
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public boolean getCapStatisticsReporting() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        if (this.serviceVersion < 1008000) {
            throw new JposException(104, "Device Service is not 1.8.0 compliant.");
        }
        try {
            return this.service18.getCapStatisticsReporting();
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public boolean getCapUpdateStatistics() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        if (this.serviceVersion < 1008000) {
            throw new JposException(104, "Device Service is not 1.8.0 compliant.");
        }
        try {
            return this.service18.getCapUpdateStatistics();
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public boolean getCapCompareFirmwareVersion() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        if (this.serviceVersion < 1009000) {
            throw new JposException(104, "Device Service is not 1.9.0 compliant.");
        }
        try {
            return this.service19.getCapCompareFirmwareVersion();
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public boolean getCapUpdateFirmware() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        if (this.serviceVersion < 1009000) {
            throw new JposException(104, "Device Service is not 1.9.0 compliant.");
        }
        try {
            return this.service19.getCapUpdateFirmware();
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public int getCharacterSet() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            return this.service12.getCharacterSet();
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public void setCharacterSet(int n) throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            this.service12.setCharacterSet(n);
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public String getCharacterSetList() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            return this.service12.getCharacterSetList();
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public int getColumns() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            return this.service12.getColumns();
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public int getCurrentWindow() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            return this.service12.getCurrentWindow();
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public void setCurrentWindow(int n) throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            this.service12.setCurrentWindow(n);
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public int getCursorColumn() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            return this.service12.getCursorColumn();
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public void setCursorColumn(int n) throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            this.service12.setCursorColumn(n);
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public int getCursorRow() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            return this.service12.getCursorRow();
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public void setCursorRow(int n) throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            this.service12.setCursorRow(n);
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public boolean getCursorUpdate() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            return this.service12.getCursorUpdate();
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public void setCursorUpdate(boolean bl) throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            this.service12.setCursorUpdate(bl);
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public int getDeviceBrightness() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            return this.service12.getDeviceBrightness();
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public void setDeviceBrightness(int n) throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            this.service12.setDeviceBrightness(n);
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public int getDeviceColumns() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            return this.service12.getDeviceColumns();
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public int getDeviceDescriptors() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            return this.service12.getDeviceDescriptors();
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public int getDeviceRows() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            return this.service12.getDeviceRows();
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public int getDeviceWindows() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            return this.service12.getDeviceWindows();
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public int getInterCharacterWait() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            return this.service12.getInterCharacterWait();
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public void setInterCharacterWait(int n) throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            this.service12.setInterCharacterWait(n);
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public int getMarqueeFormat() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            return this.service12.getMarqueeFormat();
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public void setMarqueeFormat(int n) throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            this.service12.setMarqueeFormat(n);
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public int getMarqueeRepeatWait() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            return this.service12.getMarqueeRepeatWait();
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public void setMarqueeRepeatWait(int n) throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            this.service12.setMarqueeRepeatWait(n);
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public int getMarqueeType() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            return this.service12.getMarqueeType();
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public void setMarqueeType(int n) throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            this.service12.setMarqueeType(n);
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public int getMarqueeUnitWait() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            return this.service12.getMarqueeUnitWait();
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public void setMarqueeUnitWait(int n) throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            this.service12.setMarqueeUnitWait(n);
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public int getRows() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            return this.service12.getRows();
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public int getPowerNotify() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        if (this.serviceVersion < 1003000) {
            throw new JposException(104, "Device Service is not 1.3.0 compliant.");
        }
        try {
            return this.service13.getPowerNotify();
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public void setPowerNotify(int n) throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        if (this.serviceVersion < 1003000) {
            throw new JposException(104, "Device Service is not 1.3.0 compliant.");
        }
        try {
            this.service13.setPowerNotify(n);
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public int getPowerState() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        if (this.serviceVersion < 1003000) {
            throw new JposException(104, "Device Service is not 1.3.0 compliant.");
        }
        try {
            return this.service13.getPowerState();
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public int getBlinkRate() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        if (this.serviceVersion < 1006000) {
            throw new JposException(104, "Device Service is not 1.6.0 compliant.");
        }
        try {
            return this.service16.getBlinkRate();
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public void setBlinkRate(int n) throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        if (this.serviceVersion < 1006000) {
            throw new JposException(104, "Device Service is not 1.6.0 compliant.");
        }
        try {
            this.service16.setBlinkRate(n);
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public int getCursorType() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        if (this.serviceVersion < 1006000) {
            throw new JposException(104, "Device Service is not 1.6.0 compliant.");
        }
        try {
            return this.service16.getCursorType();
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public void setCursorType(int n) throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        if (this.serviceVersion < 1006000) {
            throw new JposException(104, "Device Service is not 1.6.0 compliant.");
        }
        try {
            this.service16.setCursorType(n);
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public String getCustomGlyphList() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        if (this.serviceVersion < 1006000) {
            throw new JposException(104, "Device Service is not 1.6.0 compliant.");
        }
        try {
            return this.service16.getCustomGlyphList();
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public int getGlyphHeight() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        if (this.serviceVersion < 1006000) {
            throw new JposException(104, "Device Service is not 1.6.0 compliant.");
        }
        try {
            return this.service16.getGlyphHeight();
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public int getGlyphWidth() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        if (this.serviceVersion < 1006000) {
            throw new JposException(104, "Device Service is not 1.6.0 compliant.");
        }
        try {
            return this.service16.getGlyphWidth();
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public boolean getMapCharacterSet() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        if (this.serviceVersion < 1007000) {
            throw new JposException(104, "Device Service is not 1.7.0 compliant.");
        }
        try {
            return this.service17.getMapCharacterSet();
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public void setMapCharacterSet(boolean bl) throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        if (this.serviceVersion < 1007000) {
            throw new JposException(104, "Device Service is not 1.7.0 compliant.");
        }
        try {
            this.service17.setMapCharacterSet(bl);
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public int getMaximumX() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        if (this.serviceVersion < 1007000) {
            throw new JposException(104, "Device Service is not 1.7.0 compliant.");
        }
        try {
            return this.service17.getMaximumX();
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public int getMaximumY() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        if (this.serviceVersion < 1007000) {
            throw new JposException(104, "Device Service is not 1.7.0 compliant.");
        }
        try {
            return this.service17.getMaximumY();
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public int getScreenMode() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        if (this.serviceVersion < 1007000) {
            throw new JposException(104, "Device Service is not 1.7.0 compliant.");
        }
        try {
            return this.service17.getScreenMode();
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public void setScreenMode(int n) throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        if (this.serviceVersion < 1007000) {
            throw new JposException(104, "Device Service is not 1.7.0 compliant.");
        }
        try {
            this.service17.setScreenMode(n);
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public String getScreenModeList() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        if (this.serviceVersion < 1007000) {
            throw new JposException(104, "Device Service is not 1.7.0 compliant.");
        }
        try {
            return this.service17.getScreenModeList();
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public void clearDescriptors() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            this.service12.clearDescriptors();
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public void clearText() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            this.service12.clearText();
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public void createWindow(int n, int n2, int n3, int n4, int n5, int n6) throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            this.service12.createWindow(n, n2, n3, n4, n5, n6);
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public void destroyWindow() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            this.service12.destroyWindow();
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public void displayText(String string, int n) throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            this.service12.displayText(string, n);
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public void displayTextAt(int n, int n2, String string, int n3) throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            this.service12.displayTextAt(n, n2, string, n3);
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public void refreshWindow(int n) throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            this.service12.refreshWindow(n);
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public void scrollText(int n, int n2) throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            this.service12.scrollText(n, n2);
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public void setDescriptor(int n, int n2) throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            this.service12.setDescriptor(n, n2);
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public void defineGlyph(int n, byte[] byArray) throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        if (this.serviceVersion < 1006000) {
            throw new JposException(104, "Device Service is not 1.6.0 compliant.");
        }
        try {
            this.service16.defineGlyph(n, byArray);
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public void readCharacterAtCursor(int[] nArray) throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        if (this.serviceVersion < 1006000) {
            throw new JposException(104, "Device Service is not 1.6.0 compliant.");
        }
        try {
            this.service16.readCharacterAtCursor(nArray);
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public void displayBitmap(String string, int n, int n2, int n3) throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        if (this.serviceVersion < 1007000) {
            throw new JposException(104, "Device Service is not 1.7.0 compliant.");
        }
        try {
            this.service17.displayBitmap(string, n, n2, n3);
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public void setBitmap(int n, String string, int n2, int n3, int n4) throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        if (this.serviceVersion < 1007000) {
            throw new JposException(104, "Device Service is not 1.7.0 compliant.");
        }
        try {
            this.service17.setBitmap(n, string, n2, n3, n4);
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public void resetStatistics(String string) throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        if (this.serviceVersion < 1008000) {
            throw new JposException(104, "Device Service is not 1.8.0 compliant.");
        }
        try {
            this.service18.resetStatistics(string);
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public void retrieveStatistics(String[] stringArray) throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        if (this.serviceVersion < 1008000) {
            throw new JposException(104, "Device Service is not 1.8.0 compliant.");
        }
        try {
            this.service18.retrieveStatistics(stringArray);
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public void updateStatistics(String string) throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        if (this.serviceVersion < 1008000) {
            throw new JposException(104, "Device Service is not 1.8.0 compliant.");
        }
        try {
            this.service18.updateStatistics(string);
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public void compareFirmwareVersion(String string, int[] nArray) throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        if (this.serviceVersion < 1009000) {
            throw new JposException(104, "Device Service is not 1.9.0 compliant.");
        }
        try {
            this.service19.compareFirmwareVersion(string, nArray);
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public void updateFirmware(String string) throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        if (this.serviceVersion < 1009000) {
            throw new JposException(104, "Device Service is not 1.9.0 compliant.");
        }
        try {
            this.service19.updateFirmware(string);
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    protected EventCallbacks createEventCallbacks() {
        return new LineDisplayCallbacks();
    }

    protected void setDeviceService(BaseService baseService, int n) throws JposException {
        if (baseService == null) {
            this.service12 = null;
            this.service13 = null;
            this.service14 = null;
            this.service15 = null;
            this.service16 = null;
            this.service17 = null;
            this.service18 = null;
            this.service19 = null;
        } else {
            if (this.serviceVersion >= 1002000) {
                try {
                    this.service12 = (LineDisplayService12)baseService;
                }
                catch (Exception exception) {
                    throw new JposException(104, "Service does not fully implement LineDisplayService12 interface", exception);
                }
            }
            if (this.serviceVersion >= 1003000) {
                try {
                    this.service13 = (LineDisplayService13)baseService;
                }
                catch (Exception exception) {
                    throw new JposException(104, "Service does not fully implement LineDisplayService13 interface", exception);
                }
            }
            if (this.serviceVersion >= 1004000) {
                try {
                    this.service14 = (LineDisplayService14)baseService;
                }
                catch (Exception exception) {
                    throw new JposException(104, "Service does not fully implement LineDisplayService14 interface", exception);
                }
            }
            if (this.serviceVersion >= 1005000) {
                try {
                    this.service15 = (LineDisplayService15)baseService;
                }
                catch (Exception exception) {
                    throw new JposException(104, "Service does not fully implement LineDisplayService15 interface", exception);
                }
            }
            if (this.serviceVersion >= 1006000) {
                try {
                    this.service16 = (LineDisplayService16)baseService;
                }
                catch (Exception exception) {
                    throw new JposException(104, "Service does not fully implement LineDisplayService16 interface", exception);
                }
            }
            if (this.serviceVersion >= 1007000) {
                try {
                    this.service17 = (LineDisplayService17)baseService;
                }
                catch (Exception exception) {
                    throw new JposException(104, "Service does not fully implement LineDisplayService17 interface", exception);
                }
            }
            if (this.serviceVersion >= 1008000) {
                try {
                    this.service18 = (LineDisplayService18)baseService;
                }
                catch (Exception exception) {
                    throw new JposException(104, "Service does not fully implement LineDisplayService18 interface", exception);
                }
            }
            if (this.serviceVersion >= 1009000) {
                try {
                    this.service19 = (LineDisplayService19)baseService;
                }
                catch (Exception exception) {
                    throw new JposException(104, "Service does not fully implement LineDisplayService19 interface", exception);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDirectIOListener(DirectIOListener directIOListener) {
        Vector vector = this.directIOListeners;
        synchronized (vector) {
            this.directIOListeners.addElement(directIOListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDirectIOListener(DirectIOListener directIOListener) {
        Vector vector = this.directIOListeners;
        synchronized (vector) {
            this.directIOListeners.removeElement(directIOListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addStatusUpdateListener(StatusUpdateListener statusUpdateListener) {
        Vector vector = this.statusUpdateListeners;
        synchronized (vector) {
            this.statusUpdateListeners.addElement(statusUpdateListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeStatusUpdateListener(StatusUpdateListener statusUpdateListener) {
        Vector vector = this.statusUpdateListeners;
        synchronized (vector) {
            this.statusUpdateListeners.removeElement(statusUpdateListener);
        }
    }

    protected class LineDisplayCallbacks
    implements EventCallbacks {
        protected LineDisplayCallbacks() {
        }

        public BaseControl getEventSource() {
            return LineDisplay.this;
        }

        public void fireDataEvent(DataEvent dataEvent) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void fireDirectIOEvent(DirectIOEvent directIOEvent) {
            Vector vector = LineDisplay.this.directIOListeners;
            synchronized (vector) {
                for (int i = 0; i < LineDisplay.this.directIOListeners.size(); ++i) {
                    ((DirectIOListener)LineDisplay.this.directIOListeners.elementAt(i)).directIOOccurred(directIOEvent);
                }
            }
        }

        public void fireErrorEvent(ErrorEvent errorEvent) {
        }

        public void fireOutputCompleteEvent(OutputCompleteEvent outputCompleteEvent) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void fireStatusUpdateEvent(StatusUpdateEvent statusUpdateEvent) {
            Vector vector = LineDisplay.this.statusUpdateListeners;
            synchronized (vector) {
                for (int i = 0; i < LineDisplay.this.statusUpdateListeners.size(); ++i) {
                    ((StatusUpdateListener)LineDisplay.this.statusUpdateListeners.elementAt(i)).statusUpdateOccurred(statusUpdateEvent);
                }
            }
        }
    }
}

