/*
 * Decompiled with CFR 0.152.
 */
package jpos.config.simple.editor;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import jpos.config.CompositeRegPopulator;
import jpos.config.JposEntry;
import jpos.config.JposEntryConst;
import jpos.config.JposRegPopulator;
import jpos.config.simple.SimpleEntry;
import jpos.config.simple.editor.JposEntryEditorMsg;
import jpos.loader.JposServiceLoader;
import jpos.profile.DevCat;
import jpos.profile.JposDevCats;
import jpos.util.JposEntryUtility;

class AddJposEntryDialog
extends JDialog {
    private JposEntry jposEntry = null;
    private JTextField logicalNameTextField = new JTextField(20);
    private JComboBox regPopulatorComboBox = new JComboBox();
    private JComboBox devCatComboBox = new JComboBox<DevCat>(JposDevCats.DEVCAT_ARRAY);
    private JComboBox jposVersionComboBox = new JComboBox<String>(JposEntryConst.JPOS_VERSION_PROPS);
    private JButton okButton = new JButton(OKBUTTON_STRING);
    private JButton cancelButton = new JButton(CANCELBUTTON_STRING);
    private boolean canceled = false;
    public static final String CANCELBUTTON_STRING = JposEntryEditorMsg.CANCELBUTTON_STRING;
    public static final String OKBUTTON_STRING = JposEntryEditorMsg.OKBUTTON_STRING;
    public static final String LOGICAL_NAME_STRING = "Logical name:";
    public static final String ADD_JPOSENTRY_DIALOG_TITLE_STRING = "Add JposEntry";
    public static final String REGISTRY_POPULATOR_STRING = "Registry populator:";
    public static final String NEW_JPOSENTRY_PROPERTY_STRING = "New JposEntry Properties";
    public static final String LOGICAL_NAME_MUST_BE_NON_EMPTY_MSG = "Logical name cannot be empty!";
    public static final String JPOS_VERSION_STRING = "JavaPOS version:";
    public static final String DEVICE_CATEGORY_STRING = "Device Category:";

    public AddJposEntryDialog(JFrame jFrame) {
        super(jFrame);
        this.setTitle(ADD_JPOSENTRY_DIALOG_TITLE_STRING);
        this.getContentPane().setLayout(new BorderLayout());
        JPanel jPanel = new JPanel(new GridLayout(3, 1));
        jPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.gray), NEW_JPOSENTRY_PROPERTY_STRING));
        JPanel jPanel2 = new JPanel(new FlowLayout(0));
        jPanel2.add(new JLabel(LOGICAL_NAME_STRING));
        jPanel2.add(this.logicalNameTextField);
        jPanel.add(jPanel2);
        jPanel2 = new JPanel(new FlowLayout(0));
        jPanel2.add(new JLabel(REGISTRY_POPULATOR_STRING));
        jPanel2.add(this.regPopulatorComboBox);
        jPanel.add(jPanel2);
        jPanel2 = new JPanel(new FlowLayout(0));
        jPanel2.add(new JLabel(JPOS_VERSION_STRING));
        jPanel2.add(this.jposVersionComboBox);
        jPanel2.add(new JLabel(DEVICE_CATEGORY_STRING));
        jPanel2.add(this.devCatComboBox);
        jPanel.add(jPanel2);
        this.getContentPane().add((Component)jPanel, "Center");
        JPanel jPanel3 = new JPanel(new FlowLayout(1));
        jPanel3.add(this.okButton);
        jPanel3.add(this.cancelButton);
        this.getContentPane().add((Component)jPanel3, "South");
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AddJposEntryDialog.this.ok();
            }
        });
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AddJposEntryDialog.this.cancel();
            }
        });
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                AddJposEntryDialog.this.cancel();
            }
        });
        this.initRegPopulatorComboBox();
        this.pack();
        this.centerFrame();
    }

    private void initRegPopulatorComboBox() {
        this.regPopulatorComboBox.removeAllItems();
        JposRegPopulator jposRegPopulator = JposServiceLoader.getManager().getRegPopulator();
        if (jposRegPopulator.isComposite()) {
            Iterator iterator = ((CompositeRegPopulator)jposRegPopulator).getPopulators();
            while (iterator.hasNext()) {
                this.regPopulatorComboBox.addItem(iterator.next());
            }
        } else {
            this.regPopulatorComboBox.addItem(jposRegPopulator);
        }
    }

    private void centerFrame() {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation(dimension.width / 2 - this.getSize().width / 2, dimension.height / 2 - this.getSize().height / 2);
    }

    private void ok() {
        if (this.logicalNameTextField.getText().equals("")) {
            JOptionPane.showMessageDialog(this, LOGICAL_NAME_MUST_BE_NON_EMPTY_MSG);
            return;
        }
        this.jposEntry = new SimpleEntry(this.logicalNameTextField.getText(), (JposRegPopulator)this.regPopulatorComboBox.getSelectedItem());
        this.jposEntry.addProperty("jposVersion", this.jposVersionComboBox.getSelectedItem().toString());
        this.jposEntry.addProperty("deviceCategory", this.devCatComboBox.getSelectedItem().toString());
        JposEntryUtility.addMissingRequiredProps(this.jposEntry);
        this.canceled = false;
        this.setVisible(false);
    }

    private void cancel() {
        this.canceled = true;
        this.setVisible(false);
    }

    public void setVisible(boolean bl) {
        if (bl) {
            this.initRegPopulatorComboBox();
            this.logicalNameTextField.setText("");
            this.jposEntry = null;
            this.canceled = false;
        }
        super.setVisible(bl);
    }

    public JposEntry getJposEntry() {
        return this.jposEntry;
    }

    public boolean isCanceled() {
        return this.canceled;
    }
}

