/*
 * Decompiled with CFR 0.152.
 */
package jpos.config.simple.editor;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import jpos.config.JposEntry;
import jpos.config.JposRegPopulator;
import jpos.config.simple.editor.JposEntryComparable;
import jpos.config.simple.editor.JposEntryListEvent;
import jpos.config.simple.editor.JposEntryListListener;
import jpos.loader.JposServiceLoader;
import jpos.util.Sorter;
import jpos.util.tracing.Tracer;
import jpos.util.tracing.TracerFactory;

class JposEntryList {
    private boolean loadedFromFile = false;
    private String entriesFileName = "";
    private Vector entries = new Vector();
    private Vector removedEntriesVector = new Vector();
    private Vector listeners = new Vector();
    private JposRegPopulator regPopulator = JposServiceLoader.getManager().getRegPopulator();
    private Tracer tracer = TracerFactory.getInstance().createTracer("JposEntryList");

    public JposEntryList() {
        this.loadedFromFile = false;
    }

    public JposEntryList(String string) throws Exception {
        this.load(string);
        this.loadedFromFile = true;
    }

    public void addJposEntryListListener(JposEntryListListener jposEntryListListener) {
        this.listeners.addElement(jposEntryListListener);
    }

    public void removeJposEntryListListener(JposEntryListListener jposEntryListListener) {
        this.listeners.removeElement(jposEntryListListener);
    }

    public Enumeration getEntries() {
        return this.entries.elements();
    }

    public Enumeration getRemovedEntries() {
        return this.removedEntriesVector.elements();
    }

    public int size() {
        return this.entries.size();
    }

    public String getEntriesFileName() {
        return this.entriesFileName;
    }

    public void setEntriesFileName(String string) {
        this.entriesFileName = string;
        this.loadedFromFile = true;
    }

    public void load(String string) throws Exception {
        this.entries.clear();
        this.getRegPopulator().load(string);
        this.tracer.println("Tried to load fileName: " + string);
        this.tracer.println("Using RegPopulator: " + this.getRegPopulator());
        if (this.getRegPopulator().getLastLoadException() != null) {
            this.tracer.println("Exception while loading fileName: " + string + " Exception.message=" + this.getRegPopulator().getLastLoadException());
            this.entries = new Vector();
            throw this.getRegPopulator().getLastLoadException();
        }
        Enumeration enumeration = this.getRegPopulator().getEntries();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            JposEntry jposEntry = (JposEntry)enumeration.nextElement();
            ++n;
            this.entries.addElement(jposEntry);
        }
        this.entriesFileName = string;
        this.loadedFromFile = true;
        this.tracer.println("Loaded fileName: " + string + " found " + n + " JposEntries");
    }

    public void save() throws Exception {
        Enumeration enumeration = this.entries.elements();
        this.getRegPopulator().save(enumeration, this.getEntriesFileName());
    }

    public void add(String string, JposEntry jposEntry) {
        this.entries.addElement(jposEntry);
        this.fireJposEntryListEventAdded(new JposEntryListEvent(this, jposEntry));
    }

    public void remove(String string) {
        Enumeration enumeration = this.entries.elements();
        while (enumeration.hasMoreElements()) {
            JposEntry jposEntry = (JposEntry)enumeration.nextElement();
            if (!jposEntry.getPropertyValue("logicalName").toString().equals(string)) continue;
            this.removedEntriesVector.addElement(jposEntry);
            if (!this.entries.removeElement(jposEntry)) continue;
            this.fireJposEntryListEventRemoved(new JposEntryListEvent(this, jposEntry));
            return;
        }
    }

    public void change(String string, JposEntry jposEntry) {
        this.entries.removeElement(jposEntry);
        this.entries.addElement(jposEntry);
    }

    public boolean isLoadedFromFile() {
        return this.loadedFromFile;
    }

    public boolean hasJposEntry(String string) {
        Enumeration enumeration = this.entries.elements();
        while (enumeration.hasMoreElements()) {
            JposEntry jposEntry = (JposEntry)enumeration.nextElement();
            if (!jposEntry.getPropertyValue("logicalName").toString().equals(string)) continue;
            return true;
        }
        return false;
    }

    public boolean isEmpty() {
        return this.entries.isEmpty();
    }

    public void sort() {
        Object object;
        Serializable serializable;
        Enumeration enumeration = this.entries.elements();
        Vector<Object> vector = new Vector<Object>();
        while (enumeration.hasMoreElements()) {
            serializable = (JposEntry)enumeration.nextElement();
            object = new JposEntryComparable((JposEntry)serializable);
            vector.addElement(object);
        }
        this.entries.removeAllElements();
        serializable = Sorter.insertionSort(vector);
        object = ((Vector)serializable).elements();
        while (object.hasMoreElements()) {
            JposEntryComparable jposEntryComparable = (JposEntryComparable)object.nextElement();
            this.entries.addElement(jposEntryComparable.getJposEntry());
        }
    }

    public JposRegPopulator getRegPopulator() {
        return this.regPopulator;
    }

    public void setRegPopulator(JposRegPopulator jposRegPopulator) {
        this.tracer.println("Setting RegPopulator to: " + jposRegPopulator);
        this.regPopulator = jposRegPopulator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireJposEntryListEventAdded(JposEntryListEvent jposEntryListEvent) {
        Vector vector;
        Vector vector2 = vector = (Vector)this.listeners.clone();
        synchronized (vector2) {
            for (int i = 0; i < vector.size(); ++i) {
                ((JposEntryListListener)vector.elementAt(i)).jposEntryAdded(jposEntryListEvent);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireJposEntryListEventRemoved(JposEntryListEvent jposEntryListEvent) {
        Vector vector;
        Vector vector2 = vector = (Vector)this.listeners.clone();
        synchronized (vector2) {
            for (int i = 0; i < vector.size(); ++i) {
                ((JposEntryListListener)vector.elementAt(i)).jposEntryRemoved(jposEntryListEvent);
            }
        }
    }
}

