/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jusb.util;

import java.util.ArrayList;
import java.util.List;

public class RunnableManager {
    private ManagerRunnable runnable = new ManagerRunnable();
    private long managerCount = ++count;
    private long threadCount = 0L;
    private String name = "RunnableManager " + this.managerCount;
    private long maxSize = 1L;
    private static long count = 0L;
    public static final long SIZE_UNLIMITED = Long.MAX_VALUE;

    public RunnableManager() {
        this(true);
    }

    public RunnableManager(boolean start) {
        if (start) {
            this.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setName(String n) {
        this.name = n;
        Object object = this.runnable.lock;
        synchronized (object) {
            if (this.isRunning()) {
                this.runnable.thread.setName(this.name + " Thread " + this.threadCount);
            }
        }
    }

    public String getName() {
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(Runnable newRunnable) {
        Object object = this.runnable.lock;
        synchronized (object) {
            if (this.isRunning() && this.getSize() >= this.getMaxSize()) {
                this.stop();
                this.start();
            }
        }
        object = this.runnable.lock;
        synchronized (object) {
            this.runnable.list.add(newRunnable);
            this.runnable.lock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        Object object = this.runnable.lock;
        synchronized (object) {
            if (this.runnable.running) {
                throw new IllegalThreadStateException("RunnableManager already running");
            }
            this.runnable.running = true;
            this.runnable.thread = new Thread(this.runnable);
            this.runnable.thread.setDaemon(true);
            this.runnable.thread.setName(this.name + " Thread " + ++this.threadCount);
            this.runnable.thread.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object = this.runnable.lock;
        synchronized (object) {
            this.runnable.running = false;
            this.runnable.lock.notifyAll();
            this.runnable = new ManagerRunnable();
        }
    }

    public boolean isRunning() {
        return this.runnable.running;
    }

    public long getMaxSize() {
        return this.maxSize;
    }

    public void setMaxSize(long size) {
        if (1L > size) {
            throw new IllegalArgumentException("Max size cannot be less than 1");
        }
        this.maxSize = size;
    }

    public long getSize() {
        return this.runnable.getSize();
    }

    protected class ManagerRunnable
    implements Runnable {
        public Thread thread = null;
        public Object[] array = null;
        public Object lock = new Object();
        public boolean running = false;
        public List list = new ArrayList();
        private long size = 0L;

        protected ManagerRunnable() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (this.running || !this.list.isEmpty()) {
                while (!this.list.isEmpty()) {
                    Object object = this.lock;
                    synchronized (object) {
                        this.array = this.list.toArray();
                        this.list.clear();
                        this.size = this.array.length;
                    }
                    for (int i = 0; i < this.array.length; ++i) {
                        try {
                            ((Runnable)this.array[i]).run();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        catch (Error e) {
                            e.printStackTrace();
                        }
                        --this.size;
                    }
                    this.array = null;
                }
                Object object = this.lock;
                synchronized (object) {
                    while (this.running && this.list.isEmpty()) {
                        try {
                            this.lock.wait();
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public long getSize() {
            Object object = this.lock;
            synchronized (object) {
                return (long)this.list.size() + this.size;
            }
        }
    }

    public class SynchronizedRunnableManager
    extends RunnableManager {
        public synchronized void add(Runnable newRunnable) {
            super.add(newRunnable);
        }

        public synchronized void start() {
            super.start();
        }

        public synchronized void stop() {
            super.stop();
        }
    }
}

