/*
 * Decompiled with CFR 0.152.
 */
package jpos;

import java.util.Vector;
import jpos.BaseControl;
import jpos.CATControl15;
import jpos.JposConst;
import jpos.JposException;
import jpos.events.DataEvent;
import jpos.events.DirectIOEvent;
import jpos.events.DirectIOListener;
import jpos.events.ErrorEvent;
import jpos.events.ErrorListener;
import jpos.events.OutputCompleteEvent;
import jpos.events.OutputCompleteListener;
import jpos.events.StatusUpdateEvent;
import jpos.events.StatusUpdateListener;
import jpos.loader.JposServiceConnection;
import jpos.loader.JposServiceLoader;
import jpos.services.CATService14;
import jpos.services.CATService15;
import jpos.services.EventCallbacks;

public class CAT
implements CATControl15,
JposConst {
    protected static final String deviceControlDescription = "JavaPOS CAT Device Control";
    protected static final int deviceControlVersion = 1005000;
    protected static final int deviceVersion14 = 1004000;
    protected static final int deviceVersion15 = 1005000;
    protected JposServiceConnection serviceConnection = null;
    protected int serviceVersion;
    protected CATService14 service14 = null;
    protected CATService15 service15 = null;
    protected Vector directIOListeners = new Vector();
    protected Vector errorListeners = new Vector();
    protected Vector outputCompleteListeners = new Vector();
    protected Vector statusUpdateListeners = new Vector();

    public boolean getCapAdditionalSecurityInformation() throws JposException {
        try {
            return this.service14.getCapAdditionalSecurityInformation();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public boolean getCapAuthorizeCompletion() throws JposException {
        try {
            return this.service14.getCapAuthorizeCompletion();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public boolean getCapAuthorizePreSales() throws JposException {
        try {
            return this.service14.getCapAuthorizePreSales();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public boolean getCapAuthorizeRefund() throws JposException {
        try {
            return this.service14.getCapAuthorizeRefund();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public boolean getCapAuthorizeVoid() throws JposException {
        try {
            return this.service14.getCapAuthorizeVoid();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public boolean getCapAuthorizeVoidPreSales() throws JposException {
        try {
            return this.service14.getCapAuthorizeVoidPreSales();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public boolean getCapCenterResultCode() throws JposException {
        try {
            return this.service14.getCapCenterResultCode();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public boolean getCapCheckCard() throws JposException {
        try {
            return this.service14.getCapCheckCard();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public int getCapDailyLog() throws JposException {
        try {
            return this.service14.getCapDailyLog();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public boolean getCapInstallments() throws JposException {
        try {
            return this.service14.getCapInstallments();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public boolean getCapPaymentDetail() throws JposException {
        try {
            return this.service14.getCapPaymentDetail();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public int getCapPowerReporting() throws JposException {
        try {
            return this.service14.getCapPowerReporting();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public boolean getCapTaxOthers() throws JposException {
        try {
            return this.service14.getCapTaxOthers();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public boolean getCapTransactionNumber() throws JposException {
        try {
            return this.service14.getCapTransactionNumber();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public boolean getCapTrainingMode() throws JposException {
        try {
            return this.service14.getCapTrainingMode();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public String getCheckHealthText() throws JposException {
        try {
            return this.service14.getCheckHealthText();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public boolean getClaimed() throws JposException {
        try {
            return this.service14.getClaimed();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public String getDeviceControlDescription() {
        return deviceControlDescription;
    }

    public int getDeviceControlVersion() {
        return 1005000;
    }

    public boolean getDeviceEnabled() throws JposException {
        try {
            return this.service14.getDeviceEnabled();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public void setDeviceEnabled(boolean deviceEnabled) throws JposException {
        try {
            this.service14.setDeviceEnabled(deviceEnabled);
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public String getDeviceServiceDescription() throws JposException {
        try {
            return this.service14.getDeviceServiceDescription();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public int getDeviceServiceVersion() throws JposException {
        try {
            return this.service14.getDeviceServiceVersion();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public boolean getFreezeEvents() throws JposException {
        try {
            return this.service14.getFreezeEvents();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public void setFreezeEvents(boolean freezeEvents) throws JposException {
        try {
            this.service14.setFreezeEvents(freezeEvents);
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public String getPhysicalDeviceDescription() throws JposException {
        try {
            return this.service14.getPhysicalDeviceDescription();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public String getPhysicalDeviceName() throws JposException {
        try {
            return this.service14.getPhysicalDeviceName();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public int getState() {
        try {
            return this.service14.getState();
        }
        catch (Exception e) {
            return 1;
        }
    }

    public String getAccountNumber() throws JposException {
        try {
            return this.service14.getAccountNumber();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public String getAdditionalSecurityInformation() throws JposException {
        try {
            return this.service14.getAdditionalSecurityInformation();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public void setAdditionalSecurityInformation(String securityInfo) throws JposException {
        try {
            this.service14.setAdditionalSecurityInformation(securityInfo);
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public String getApprovalCode() throws JposException {
        try {
            return this.service14.getApprovalCode();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public boolean getAsyncMode() throws JposException {
        try {
            return this.service14.getAsyncMode();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public void setAsyncMode(boolean asyncMode) throws JposException {
        try {
            this.service14.setAsyncMode(asyncMode);
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public String getCardCompanyID() throws JposException {
        try {
            return this.service14.getCardCompanyID();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public String getCenterResultCode() throws JposException {
        try {
            return this.service14.getCenterResultCode();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public String getDailyLog() throws JposException {
        try {
            return this.service14.getDailyLog();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public int getPaymentCondition() throws JposException {
        try {
            return this.service14.getPaymentCondition();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public String getPaymentDetail() throws JposException {
        try {
            return this.service14.getPaymentDetail();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public int getPowerNotify() throws JposException {
        try {
            return this.service14.getPowerNotify();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public void setPowerNotify(int powerNotify) throws JposException {
        try {
            this.service14.setPowerNotify(powerNotify);
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public int getPowerState() throws JposException {
        try {
            return this.service14.getPowerState();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public int getSequenceNumber() throws JposException {
        try {
            return this.service14.getSequenceNumber();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public String getSlipNumber() throws JposException {
        try {
            return this.service14.getSlipNumber();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public boolean getTrainingMode() throws JposException {
        try {
            return this.service14.getTrainingMode();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public void setTrainingMode(boolean trainingMode) throws JposException {
        try {
            this.service14.setTrainingMode(trainingMode);
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public String getTransactionNumber() throws JposException {
        try {
            return this.service14.getTransactionNumber();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public String getTransactionType() throws JposException {
        try {
            return this.service14.getTransactionType();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public int getPaymentMedia() throws JposException {
        if (this.service14 == null || this.serviceVersion >= 1005000) {
            try {
                return this.service15.getPaymentMedia();
            }
            catch (JposException je) {
                throw je;
            }
            catch (Exception e) {
                throw new JposException(101, "Control not opened", e);
            }
        }
        throw new JposException(104, "Service does not support the CATControl15 interface");
    }

    public void setPaymentMedia(int paymentMedia) throws JposException {
        if (this.service14 == null || this.serviceVersion >= 1005000) {
            try {
                this.service15.setPaymentMedia(paymentMedia);
            }
            catch (JposException je) {
                throw je;
            }
            catch (Exception e) {
                throw new JposException(101, "Control not opened", e);
            }
        } else {
            throw new JposException(104, "Service does not support the CATControl15 interface");
        }
    }

    public void claim(int timeout) throws JposException {
        try {
            this.service14.claim(timeout);
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public synchronized void close() throws JposException {
        try {
            this.service14.close();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Service not open", e);
        }
        try {
            try {
                this.serviceConnection.disconnect();
            }
            catch (Exception e) {
                throw new JposException(104, "Unable to free service connection", e);
            }
        }
        catch (Throwable throwable) {
            Object var2_5 = null;
            this.service14 = null;
            this.service15 = null;
            throw throwable;
        }
        Object var2_6 = null;
        this.service14 = null;
        this.service15 = null;
    }

    public void checkHealth(int level) throws JposException {
        try {
            this.service14.checkHealth(level);
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public void directIO(int command, int[] data, Object object) throws JposException {
        try {
            this.service14.directIO(command, data, object);
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public synchronized void open(String logicalDeviceName) throws JposException {
        if (this.service14 != null) {
            throw new JposException(106, "Device control already open");
        }
        try {
            this.serviceConnection = JposServiceLoader.findService(logicalDeviceName);
            this.serviceConnection.connect();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(104, "Could not connect to service", e);
        }
        try {
            this.service14 = (CATService14)((Object)this.serviceConnection.getService());
        }
        catch (Exception e) {
            throw new JposException(104, "Could not get service instance", e);
        }
        try {
            this.serviceVersion = this.service14.getDeviceServiceVersion();
        }
        catch (Exception e) {
            throw new JposException(104, "Could not get service version information", e);
        }
        if (this.serviceVersion >= 1005000) {
            try {
                this.service15 = (CATService15)this.service14;
            }
            catch (Exception e) {
                throw new JposException(104, "Service does not fully implement CATDevice15 interface", e);
            }
        }
        CATCallbacks callbacks = new CATCallbacks();
        this.service14.open(logicalDeviceName, callbacks);
    }

    public void release() throws JposException {
        try {
            this.service14.release();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public void accessDailyLog(int sequenceNumber, int type, int timeout) throws JposException {
        try {
            this.service14.accessDailyLog(sequenceNumber, type, timeout);
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public void authorizeCompletion(int sequenceNumber, long amount, long taxOthers, int timeout) throws JposException {
        try {
            this.service14.authorizeCompletion(sequenceNumber, amount, taxOthers, timeout);
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public void authorizePreSales(int sequenceNumber, long amount, long taxOthers, int timeout) throws JposException {
        try {
            this.service14.authorizePreSales(sequenceNumber, amount, taxOthers, timeout);
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public void authorizeRefund(int sequenceNumber, long amount, long taxOthers, int timeout) throws JposException {
        try {
            this.service14.authorizeRefund(sequenceNumber, amount, taxOthers, timeout);
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public void authorizeSales(int sequenceNumber, long amount, long taxOthers, int timeout) throws JposException {
        try {
            this.service14.authorizeSales(sequenceNumber, amount, taxOthers, timeout);
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public void authorizeVoid(int sequenceNumber, long amount, long taxOthers, int timeout) throws JposException {
        try {
            this.service14.authorizeVoid(sequenceNumber, amount, taxOthers, timeout);
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public void authorizeVoidPreSales(int sequenceNumber, long amount, long taxOthers, int timeout) throws JposException {
        try {
            this.service14.authorizeVoidPreSales(sequenceNumber, amount, taxOthers, timeout);
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public void checkCard(int sequenceNumber, int timeout) throws JposException {
        try {
            this.service14.checkCard(sequenceNumber, timeout);
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public void clearOutput() throws JposException {
        try {
            this.service14.clearOutput();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public void addDirectIOListener(DirectIOListener l) {
        Vector vector = this.directIOListeners;
        synchronized (vector) {
            this.directIOListeners.addElement(l);
        }
    }

    public void removeDirectIOListener(DirectIOListener l) {
        Vector vector = this.directIOListeners;
        synchronized (vector) {
            this.directIOListeners.removeElement(l);
        }
    }

    public void addErrorListener(ErrorListener l) {
        Vector vector = this.errorListeners;
        synchronized (vector) {
            this.errorListeners.addElement(l);
        }
    }

    public void removeErrorListener(ErrorListener l) {
        Vector vector = this.errorListeners;
        synchronized (vector) {
            this.errorListeners.removeElement(l);
        }
    }

    public void addOutputCompleteListener(OutputCompleteListener l) {
        Vector vector = this.outputCompleteListeners;
        synchronized (vector) {
            this.outputCompleteListeners.addElement(l);
        }
    }

    public void removeOutputCompleteListener(OutputCompleteListener l) {
        Vector vector = this.outputCompleteListeners;
        synchronized (vector) {
            this.outputCompleteListeners.removeElement(l);
        }
    }

    public void addStatusUpdateListener(StatusUpdateListener l) {
        Vector vector = this.statusUpdateListeners;
        synchronized (vector) {
            this.statusUpdateListeners.addElement(l);
        }
    }

    public void removeStatusUpdateListener(StatusUpdateListener l) {
        Vector vector = this.statusUpdateListeners;
        synchronized (vector) {
            this.statusUpdateListeners.removeElement(l);
        }
    }

    protected class CATCallbacks
    implements EventCallbacks {
        protected CATCallbacks() {
        }

        public BaseControl getEventSource() {
            return CAT.this;
        }

        public void fireDataEvent(DataEvent e) {
        }

        public void fireDirectIOEvent(DirectIOEvent e) {
            Vector vector = CAT.this.directIOListeners;
            synchronized (vector) {
                int x = 0;
                while (x < CAT.this.directIOListeners.size()) {
                    ((DirectIOListener)CAT.this.directIOListeners.elementAt(x)).directIOOccurred(e);
                    ++x;
                }
            }
        }

        public void fireErrorEvent(ErrorEvent e) {
            Vector vector = CAT.this.errorListeners;
            synchronized (vector) {
                int x = 0;
                while (x < CAT.this.errorListeners.size()) {
                    ((ErrorListener)CAT.this.errorListeners.elementAt(x)).errorOccurred(e);
                    ++x;
                }
            }
        }

        public void fireOutputCompleteEvent(OutputCompleteEvent e) {
            Vector vector = CAT.this.outputCompleteListeners;
            synchronized (vector) {
                int x = 0;
                while (x < CAT.this.outputCompleteListeners.size()) {
                    ((OutputCompleteListener)CAT.this.outputCompleteListeners.elementAt(x)).outputCompleteOccurred(e);
                    ++x;
                }
            }
        }

        public void fireStatusUpdateEvent(StatusUpdateEvent e) {
            Vector vector = CAT.this.statusUpdateListeners;
            synchronized (vector) {
                int x = 0;
                while (x < CAT.this.statusUpdateListeners.size()) {
                    ((StatusUpdateListener)CAT.this.statusUpdateListeners.elementAt(x)).statusUpdateOccurred(e);
                    ++x;
                }
            }
        }
    }
}

