/*
 * Decompiled with CFR 0.152.
 */
package jpos;

import java.util.Vector;
import jpos.BaseControl;
import jpos.CashChangerControl15;
import jpos.JposConst;
import jpos.JposException;
import jpos.events.DataEvent;
import jpos.events.DataListener;
import jpos.events.DirectIOEvent;
import jpos.events.DirectIOListener;
import jpos.events.ErrorEvent;
import jpos.events.OutputCompleteEvent;
import jpos.events.StatusUpdateEvent;
import jpos.events.StatusUpdateListener;
import jpos.loader.JposServiceConnection;
import jpos.loader.JposServiceLoader;
import jpos.services.CashChangerService12;
import jpos.services.CashChangerService13;
import jpos.services.CashChangerService14;
import jpos.services.CashChangerService15;
import jpos.services.EventCallbacks;

public class CashChanger
implements CashChangerControl15,
JposConst {
    protected static final String deviceControlDescription = "JavaPOS CashChanger Device Control";
    protected static final int deviceControlVersion = 1005000;
    protected static final int deviceVersion12 = 1002000;
    protected static final int deviceVersion13 = 1003000;
    protected static final int deviceVersion14 = 1004000;
    protected static final int deviceVersion15 = 1005000;
    protected JposServiceConnection serviceConnection = null;
    protected int serviceVersion;
    protected CashChangerService12 service12 = null;
    protected CashChangerService13 service13 = null;
    protected CashChangerService14 service14 = null;
    protected CashChangerService15 service15 = null;
    protected Vector directIOListeners = new Vector();
    protected Vector statusUpdateListeners = new Vector();
    protected Vector dataListeners = new Vector();

    public boolean getCapDiscrepancy() throws JposException {
        try {
            return this.service12.getCapDiscrepancy();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public boolean getCapEmptySensor() throws JposException {
        try {
            return this.service12.getCapEmptySensor();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public boolean getCapFullSensor() throws JposException {
        try {
            return this.service12.getCapFullSensor();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public boolean getCapNearEmptySensor() throws JposException {
        try {
            return this.service12.getCapNearEmptySensor();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public boolean getCapNearFullSensor() throws JposException {
        try {
            return this.service12.getCapNearFullSensor();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public int getCapPowerReporting() throws JposException {
        if (this.service12 == null || this.serviceVersion >= 1003000) {
            try {
                return this.service13.getCapPowerReporting();
            }
            catch (JposException je) {
                throw je;
            }
            catch (Exception e) {
                throw new JposException(101, "Control not opened", e);
            }
        }
        throw new JposException(104, "Service does not support the CashChangerControl13 interface");
    }

    public boolean getCapDeposit() throws JposException {
        if (this.service12 == null || this.serviceVersion >= 1005000) {
            try {
                return this.service15.getCapDeposit();
            }
            catch (JposException je) {
                throw je;
            }
            catch (Exception e) {
                throw new JposException(101, "Control not opened", e);
            }
        }
        throw new JposException(104, "Service does not support the CashChangerControl15 interface");
    }

    public boolean getCapDepositDataEvent() throws JposException {
        if (this.service12 == null || this.serviceVersion >= 1005000) {
            try {
                return this.service15.getCapDepositDataEvent();
            }
            catch (JposException je) {
                throw je;
            }
            catch (Exception e) {
                throw new JposException(101, "Control not opened", e);
            }
        }
        throw new JposException(104, "Service does not support the CashChangerControl15 interface");
    }

    public boolean getCapPauseDeposit() throws JposException {
        if (this.service12 == null || this.serviceVersion >= 1005000) {
            try {
                return this.service15.getCapPauseDeposit();
            }
            catch (JposException je) {
                throw je;
            }
            catch (Exception e) {
                throw new JposException(101, "Control not opened", e);
            }
        }
        throw new JposException(104, "Service does not support the CashChangerControl15 interface");
    }

    public boolean getCapRepayDeposit() throws JposException {
        if (this.service12 == null || this.serviceVersion >= 1005000) {
            try {
                return this.service15.getCapRepayDeposit();
            }
            catch (JposException je) {
                throw je;
            }
            catch (Exception e) {
                throw new JposException(101, "Control not opened", e);
            }
        }
        throw new JposException(104, "Service does not support the CashChangerControl15 interface");
    }

    public String getCheckHealthText() throws JposException {
        try {
            return this.service12.getCheckHealthText();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public boolean getClaimed() throws JposException {
        try {
            return this.service12.getClaimed();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public String getDeviceControlDescription() {
        return deviceControlDescription;
    }

    public int getDeviceControlVersion() {
        return 1005000;
    }

    public boolean getDeviceEnabled() throws JposException {
        try {
            return this.service12.getDeviceEnabled();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public void setDeviceEnabled(boolean deviceEnabled) throws JposException {
        try {
            this.service12.setDeviceEnabled(deviceEnabled);
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public String getDeviceServiceDescription() throws JposException {
        try {
            return this.service12.getDeviceServiceDescription();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public int getDeviceServiceVersion() throws JposException {
        try {
            return this.service12.getDeviceServiceVersion();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public boolean getFreezeEvents() throws JposException {
        try {
            return this.service12.getFreezeEvents();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public void setFreezeEvents(boolean freezeEvents) throws JposException {
        try {
            this.service12.setFreezeEvents(freezeEvents);
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public String getPhysicalDeviceDescription() throws JposException {
        try {
            return this.service12.getPhysicalDeviceDescription();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public String getPhysicalDeviceName() throws JposException {
        try {
            return this.service12.getPhysicalDeviceName();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public int getState() {
        try {
            return this.service12.getState();
        }
        catch (Exception e) {
            return 1;
        }
    }

    public boolean getAsyncMode() throws JposException {
        try {
            return this.service12.getAsyncMode();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public void setAsyncMode(boolean asyncMode) throws JposException {
        try {
            this.service12.setAsyncMode(asyncMode);
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public int getAsyncResultCode() throws JposException {
        try {
            return this.service12.getAsyncResultCode();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public int getAsyncResultCodeExtended() throws JposException {
        try {
            return this.service12.getAsyncResultCodeExtended();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public String getCurrencyCashList() throws JposException {
        try {
            return this.service12.getCurrencyCashList();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public String getCurrencyCode() throws JposException {
        try {
            return this.service12.getCurrencyCode();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public void setCurrencyCode(String currencyCode) throws JposException {
        try {
            this.service12.setCurrencyCode(currencyCode);
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public String getCurrencyCodeList() throws JposException {
        try {
            return this.service12.getCurrencyCodeList();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public int getCurrentExit() throws JposException {
        try {
            return this.service12.getCurrentExit();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public void setCurrentExit(int currentExit) throws JposException {
        try {
            this.service12.setCurrentExit(currentExit);
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public int getDeviceExits() throws JposException {
        try {
            return this.service12.getDeviceExits();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public int getDeviceStatus() throws JposException {
        try {
            return this.service12.getDeviceStatus();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public String getExitCashList() throws JposException {
        try {
            return this.service12.getExitCashList();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public int getFullStatus() throws JposException {
        try {
            return this.service12.getFullStatus();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public int getPowerNotify() throws JposException {
        if (this.service12 == null || this.serviceVersion >= 1003000) {
            try {
                return this.service13.getPowerNotify();
            }
            catch (JposException je) {
                throw je;
            }
            catch (Exception e) {
                throw new JposException(101, "Control not opened", e);
            }
        }
        throw new JposException(104, "Service does not support the CashChangerControl13 interface");
    }

    public void setPowerNotify(int powerNotify) throws JposException {
        if (this.service12 == null || this.serviceVersion >= 1003000) {
            try {
                this.service13.setPowerNotify(powerNotify);
            }
            catch (JposException je) {
                throw je;
            }
            catch (Exception e) {
                throw new JposException(101, "Control not opened", e);
            }
        } else {
            throw new JposException(104, "Service does not support the CashChangerControl13 interface");
        }
    }

    public int getPowerState() throws JposException {
        if (this.service12 == null || this.serviceVersion >= 1003000) {
            try {
                return this.service13.getPowerState();
            }
            catch (JposException je) {
                throw je;
            }
            catch (Exception e) {
                throw new JposException(101, "Control not opened", e);
            }
        }
        throw new JposException(104, "Service does not support the CashChangerControl13 interface");
    }

    public int getDataCount() throws JposException {
        if (this.service12 == null || this.serviceVersion >= 1005000) {
            try {
                return this.service15.getDataCount();
            }
            catch (JposException je) {
                throw je;
            }
            catch (Exception e) {
                throw new JposException(101, "Control not opened", e);
            }
        }
        throw new JposException(104, "Service does not support the CashChangerControl15 interface");
    }

    public boolean getDataEventEnabled() throws JposException {
        if (this.service12 == null || this.serviceVersion >= 1005000) {
            try {
                return this.service15.getDataEventEnabled();
            }
            catch (JposException je) {
                throw je;
            }
            catch (Exception e) {
                throw new JposException(101, "Control not opened", e);
            }
        }
        throw new JposException(104, "Service does not support the CashChangerControl15 interface");
    }

    public void setDataEventEnabled(boolean dataEventEnabled) throws JposException {
        if (this.service12 == null || this.serviceVersion >= 1005000) {
            try {
                this.service15.setDataEventEnabled(dataEventEnabled);
            }
            catch (JposException je) {
                throw je;
            }
            catch (Exception e) {
                throw new JposException(101, "Control not opened", e);
            }
        } else {
            throw new JposException(104, "Service does not support the CashChangerControl15 interface");
        }
    }

    public int getDepositAmount() throws JposException {
        if (this.service12 == null || this.serviceVersion >= 1005000) {
            try {
                return this.service15.getDepositAmount();
            }
            catch (JposException je) {
                throw je;
            }
            catch (Exception e) {
                throw new JposException(101, "Control not opened", e);
            }
        }
        throw new JposException(104, "Service does not support the CashChangerControl15 interface");
    }

    public String getDepositCashList() throws JposException {
        if (this.service12 == null || this.serviceVersion >= 1005000) {
            try {
                return this.service15.getDepositCashList();
            }
            catch (JposException je) {
                throw je;
            }
            catch (Exception e) {
                throw new JposException(101, "Control not opened", e);
            }
        }
        throw new JposException(104, "Service does not support the CashChangerControl15 interface");
    }

    public String getDepositCodeList() throws JposException {
        if (this.service12 == null || this.serviceVersion >= 1005000) {
            try {
                return this.service15.getDepositCodeList();
            }
            catch (JposException je) {
                throw je;
            }
            catch (Exception e) {
                throw new JposException(101, "Control not opened", e);
            }
        }
        throw new JposException(104, "Service does not support the CashChangerControl15 interface");
    }

    public String getDepositCounts() throws JposException {
        if (this.service12 == null || this.serviceVersion >= 1005000) {
            try {
                return this.service15.getDepositCounts();
            }
            catch (JposException je) {
                throw je;
            }
            catch (Exception e) {
                throw new JposException(101, "Control not opened", e);
            }
        }
        throw new JposException(104, "Service does not support the CashChangerControl15 interface");
    }

    public int getDepositStatus() throws JposException {
        if (this.service12 == null || this.serviceVersion >= 1005000) {
            try {
                return this.service15.getDepositStatus();
            }
            catch (JposException je) {
                throw je;
            }
            catch (Exception e) {
                throw new JposException(101, "Control not opened", e);
            }
        }
        throw new JposException(104, "Service does not support the CashChangerControl15 interface");
    }

    public void claim(int timeout) throws JposException {
        try {
            this.service12.claim(timeout);
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public synchronized void close() throws JposException {
        try {
            this.service12.close();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Service not open", e);
        }
        try {
            try {
                this.serviceConnection.disconnect();
            }
            catch (Exception e) {
                throw new JposException(104, "Unable to free service connection", e);
            }
        }
        catch (Throwable throwable) {
            Object var2_5 = null;
            this.service12 = null;
            this.service13 = null;
            this.service14 = null;
            this.service15 = null;
            throw throwable;
        }
        Object var2_6 = null;
        this.service12 = null;
        this.service13 = null;
        this.service14 = null;
        this.service15 = null;
    }

    public void checkHealth(int level) throws JposException {
        try {
            this.service12.checkHealth(level);
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public void directIO(int command, int[] data, Object object) throws JposException {
        try {
            this.service12.directIO(command, data, object);
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public synchronized void open(String logicalDeviceName) throws JposException {
        if (this.service12 != null) {
            throw new JposException(106, "Device control already open");
        }
        try {
            this.serviceConnection = JposServiceLoader.findService(logicalDeviceName);
            this.serviceConnection.connect();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(104, "Could not connect to service", e);
        }
        try {
            this.service12 = (CashChangerService12)((Object)this.serviceConnection.getService());
        }
        catch (Exception e) {
            throw new JposException(104, "Could not get service instance", e);
        }
        try {
            this.serviceVersion = this.service12.getDeviceServiceVersion();
        }
        catch (Exception e) {
            throw new JposException(104, "Could not get service version information", e);
        }
        if (this.serviceVersion >= 1003000) {
            try {
                this.service13 = (CashChangerService13)this.service12;
            }
            catch (Exception e) {
                throw new JposException(104, "Service does not fully implement CashChangerDevice13 interface", e);
            }
        }
        if (this.serviceVersion >= 1004000) {
            try {
                this.service14 = (CashChangerService14)this.service12;
            }
            catch (Exception e) {
                throw new JposException(104, "Service does not fully implement CashChangerDevice14 interface", e);
            }
        }
        if (this.serviceVersion >= 1005000) {
            try {
                this.service15 = (CashChangerService15)this.service12;
            }
            catch (Exception e) {
                throw new JposException(104, "Service does not fully implement CashChangerDevice15 interface", e);
            }
        }
        CashChangerCallbacks callbacks = new CashChangerCallbacks();
        this.service12.open(logicalDeviceName, callbacks);
    }

    public void release() throws JposException {
        try {
            this.service12.release();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public void dispenseCash(String cashCounts) throws JposException {
        try {
            this.service12.dispenseCash(cashCounts);
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public void dispenseChange(int amount) throws JposException {
        try {
            this.service12.dispenseChange(amount);
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public void readCashCounts(String[] cashCounts, boolean[] discrepancy) throws JposException {
        try {
            this.service12.readCashCounts(cashCounts, discrepancy);
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public void beginDeposit() throws JposException {
        if (this.service12 == null || this.serviceVersion >= 1005000) {
            try {
                this.service15.beginDeposit();
            }
            catch (JposException je) {
                throw je;
            }
            catch (Exception e) {
                throw new JposException(101, "Control not opened", e);
            }
        } else {
            throw new JposException(104, "Service does not support the CashChangerControl15 interface");
        }
    }

    public void clearInput() throws JposException {
        if (this.service12 == null || this.serviceVersion >= 1005000) {
            try {
                this.service15.clearInput();
            }
            catch (JposException je) {
                throw je;
            }
            catch (Exception e) {
                throw new JposException(101, "Control not opened", e);
            }
        } else {
            throw new JposException(104, "Service does not support the CashChangerControl15 interface");
        }
    }

    public void endDeposit(int success) throws JposException {
        if (this.service12 == null || this.serviceVersion >= 1005000) {
            try {
                this.service15.endDeposit(success);
            }
            catch (JposException je) {
                throw je;
            }
            catch (Exception e) {
                throw new JposException(101, "Control not opened", e);
            }
        } else {
            throw new JposException(104, "Service does not support the CashChangerControl15 interface");
        }
    }

    public void fixDeposit() throws JposException {
        if (this.service12 == null || this.serviceVersion >= 1005000) {
            try {
                this.service15.fixDeposit();
            }
            catch (JposException je) {
                throw je;
            }
            catch (Exception e) {
                throw new JposException(101, "Control not opened", e);
            }
        } else {
            throw new JposException(104, "Service does not support the CashChangerControl15 interface");
        }
    }

    public void pauseDeposit(int control) throws JposException {
        if (this.service12 == null || this.serviceVersion >= 1005000) {
            try {
                this.service15.pauseDeposit(control);
            }
            catch (JposException je) {
                throw je;
            }
            catch (Exception e) {
                throw new JposException(101, "Control not opened", e);
            }
        } else {
            throw new JposException(104, "Service does not support the CashChangerControl15 interface");
        }
    }

    public void addDirectIOListener(DirectIOListener l) {
        Vector vector = this.directIOListeners;
        synchronized (vector) {
            this.directIOListeners.addElement(l);
        }
    }

    public void removeDirectIOListener(DirectIOListener l) {
        Vector vector = this.directIOListeners;
        synchronized (vector) {
            this.directIOListeners.removeElement(l);
        }
    }

    public void addStatusUpdateListener(StatusUpdateListener l) {
        Vector vector = this.statusUpdateListeners;
        synchronized (vector) {
            this.statusUpdateListeners.addElement(l);
        }
    }

    public void removeStatusUpdateListener(StatusUpdateListener l) {
        Vector vector = this.statusUpdateListeners;
        synchronized (vector) {
            this.statusUpdateListeners.removeElement(l);
        }
    }

    public void addDataListener(DataListener l) {
        Vector vector = this.dataListeners;
        synchronized (vector) {
            this.dataListeners.addElement(l);
        }
    }

    public void removeDataListener(DataListener l) {
        Vector vector = this.dataListeners;
        synchronized (vector) {
            this.dataListeners.removeElement(l);
        }
    }

    protected class CashChangerCallbacks
    implements EventCallbacks {
        protected CashChangerCallbacks() {
        }

        public BaseControl getEventSource() {
            return CashChanger.this;
        }

        public void fireDataEvent(DataEvent e) {
            Vector vector = CashChanger.this.dataListeners;
            synchronized (vector) {
                int x = 0;
                while (x < CashChanger.this.dataListeners.size()) {
                    ((DataListener)CashChanger.this.dataListeners.elementAt(x)).dataOccurred(e);
                    ++x;
                }
            }
        }

        public void fireDirectIOEvent(DirectIOEvent e) {
            Vector vector = CashChanger.this.directIOListeners;
            synchronized (vector) {
                int x = 0;
                while (x < CashChanger.this.directIOListeners.size()) {
                    ((DirectIOListener)CashChanger.this.directIOListeners.elementAt(x)).directIOOccurred(e);
                    ++x;
                }
            }
        }

        public void fireErrorEvent(ErrorEvent e) {
        }

        public void fireOutputCompleteEvent(OutputCompleteEvent e) {
        }

        public void fireStatusUpdateEvent(StatusUpdateEvent e) {
            Vector vector = CashChanger.this.statusUpdateListeners;
            synchronized (vector) {
                int x = 0;
                while (x < CashChanger.this.statusUpdateListeners.size()) {
                    ((StatusUpdateListener)CashChanger.this.statusUpdateListeners.elementAt(x)).statusUpdateOccurred(e);
                    ++x;
                }
            }
        }
    }
}

