/*
 * Decompiled with CFR 0.152.
 */
package jpos.config.simple.xml;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.util.Enumeration;
import java.util.Vector;
import jpos.config.JposConfigException;
import jpos.config.JposEntry;
import jpos.config.simple.SimpleEntry;
import jpos.config.simple.xml.AbstractXercesRegPopulator;
import jpos.util.JposEntryUtility;
import jpos.util.tracing.Tracer;
import jpos.util.tracing.TracerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class XercesRegPopulator
extends AbstractXercesRegPopulator {
    private boolean createdTempDTD = false;
    private boolean createdTempDir = false;
    private Tracer tracer = TracerFactory.getInstance().createTracer("XercesRegPopulator");
    public static final String DTD_JPOS_FILE_PATH = "jpos";
    public static final String DTD_JPOS_RES_FILE_PATH = "jpos" + File.separator + "res";
    public static final String DTD_JAR_FILE_NAME = "jpos/res/jcl.dtd";
    public static final String XERCES_REG_POPULATOR_NAME_STRING = "JCL XML Entries Populator";
    static /* synthetic */ Class class$jpos$config$simple$xml$XercesRegPopulator;

    public XercesRegPopulator() {
        super((class$jpos$config$simple$xml$XercesRegPopulator == null ? (class$jpos$config$simple$xml$XercesRegPopulator = XercesRegPopulator.class$("jpos.config.simple.xml.XercesRegPopulator")) : class$jpos$config$simple$xml$XercesRegPopulator).getName());
    }

    public XercesRegPopulator(String string) {
        super(string);
    }

    public String getClassName() {
        return (class$jpos$config$simple$xml$XercesRegPopulator == null ? (class$jpos$config$simple$xml$XercesRegPopulator = XercesRegPopulator.class$("jpos.config.simple.xml.XercesRegPopulator")) : class$jpos$config$simple$xml$XercesRegPopulator).getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load() {
        this.tracer.println("load(): isPopulatorFileDefined=" + this.isPopulatorFileDefined());
        if (!this.isPopulatorFileDefined()) {
            this.getJposEntries().clear();
            this.xmlFileName = "jpos.xml";
            this.load(this.xmlFileName);
            return;
        }
        try {
            try {
                this.getJposEntries().clear();
                this.checkAndCreateTempDTD();
                this.domParser.parse(new InputSource(this.getPopulatorFileIS()));
                Document document = this.domParser.getDocument();
                Enumeration enumeration = this.extractJposEntries(document);
                while (enumeration.hasMoreElements()) {
                    JposEntry jposEntry = (JposEntry)enumeration.nextElement();
                    if (!jposEntry.hasPropertyWithName("logicalName")) continue;
                    this.getJposEntries().put(jposEntry.getLogicalName(), jposEntry);
                }
                this.lastLoadException = null;
            }
            catch (Exception exception) {
                this.lastLoadException = exception;
                this.tracer.println("Error loading XML file.  Exception.msg = " + exception.getMessage());
                Object var5_6 = null;
                this.removeTempDTD();
            }
            Object var5_5 = null;
            this.removeTempDTD();
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            this.removeTempDTD();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(String string) {
        this.tracer.println("load: xmlFileName=" + string);
        InputStream inputStream = null;
        File file = new File(string);
        try {
            inputStream = file.exists() ? new FileInputStream(file) : this.findFileInClasspath(string);
            if (inputStream == null) {
                this.getJposEntries().clear();
                this.tracer.println("Could not find file: " + string + " in path or CLASSPATH");
                this.lastLoadException = new FileNotFoundException(string);
                return;
            }
            this.lastLoadException = null;
        }
        catch (Exception exception) {
            this.lastLoadException = exception;
            this.tracer.println("Error loading XML file.  Exception.message = " + exception.getMessage());
        }
        try {
            try {
                this.getJposEntries().clear();
                this.checkAndCreateTempDTD();
                this.domParser.parse(new InputSource(inputStream));
                Document document = this.domParser.getDocument();
                Enumeration enumeration = this.extractJposEntries(document);
                while (enumeration.hasMoreElements()) {
                    JposEntry jposEntry = (JposEntry)enumeration.nextElement();
                    if (!jposEntry.hasPropertyWithName("logicalName")) continue;
                    this.getJposEntries().put(jposEntry.getLogicalName(), jposEntry);
                }
                this.lastLoadException = null;
            }
            catch (Exception exception) {
                this.lastLoadException = exception;
                this.tracer.println("Error loading XML file.  Exception.message = " + exception.getMessage());
                Object var8_10 = null;
                this.removeTempDTD();
            }
            Object var8_9 = null;
            this.removeTempDTD();
        }
        catch (Throwable throwable) {
            Object var8_11 = null;
            this.removeTempDTD();
            throw throwable;
        }
    }

    public String getName() {
        return XERCES_REG_POPULATOR_NAME_STRING;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void checkAndCreateTempDTD() {
        this.createdTempDTD = false;
        this.createdTempDir = false;
        var1_1 = null;
        try {
            block13: {
                var2_2 = new File(AbstractXercesRegPopulator.DTD_FILE_PATH);
                var3_4 = new File(AbstractXercesRegPopulator.DTD_FILE_NAME);
                if (!var3_4.exists()) break block13;
                var5_5 = null;
                ** GOTO lbl46
            }
            if (!var2_2.exists()) {
                var2_2.mkdirs();
                this.createdTempDir = true;
                this.tracer.println("DTD file PATH does not exist...  ");
                this.tracer.println("Created \"jpos/res\" as: " + var2_2.getCanonicalPath());
            }
            if ((var1_1 = ClassLoader.getSystemResourceAsStream("jpos/res/jcl.dtd")) == null) {
                var1_1 = ClassLoader.getSystemClassLoader().getResourceAsStream(AbstractXercesRegPopulator.DTD_FILE_NAME);
            }
            this.tracer.println("Got DTD InputStream from current ClassLoader");
            if (var1_1 != null) {
                this.readAndCreateTempDtdFile(var1_1);
            }
            ** GOTO lbl53
        }
        catch (IOException var2_3) {
            this.tracer.println("Error creating DTD file or path.  Exception.msg = " + var2_3.getMessage());
            var5_7 = null;
            try {
                if (var1_1 == null) return;
                var1_1.close();
                return;
            }
            catch (IOException var6_11) {
                this.tracer.println("Error while closing InputStream...Exception.msg=" + var6_11.getMessage());
                return;
            }
        }
        {
            catch (Throwable var4_13) {
                var5_8 = null;
                ** try [egrp 2[TRYBLOCK] [5 : 190->201)] { 
lbl40:
                // 1 sources

                if (var1_1 == null) throw var4_13;
                var1_1.close();
                throw var4_13;
lbl43:
                // 1 sources

                catch (IOException var6_12) {
                    this.tracer.println("Error while closing InputStream...Exception.msg=" + var6_12.getMessage());
                }
                throw var4_13;
            }
lbl46:
            // 1 sources

            ** try [egrp 2[TRYBLOCK] [5 : 190->201)] { 
lbl47:
            // 1 sources

            if (var1_1 == null) return;
            var1_1.close();
            return;
lbl50:
            // 1 sources

            catch (IOException var6_9) {
                this.tracer.println("Error while closing InputStream...Exception.msg=" + var6_9.getMessage());
            }
            return;
lbl53:
            // 1 sources

            var5_6 = null;
            try {}
            catch (IOException var6_10) {}
            this.tracer.println("Error while closing InputStream...Exception.msg=" + var6_10.getMessage());
            return;
            if (var1_1 == null) return;
            var1_1.close();
            return;
        }
    }

    protected void readAndCreateTempDtdFile(InputStream inputStream) throws IOException {
        File file = new File(AbstractXercesRegPopulator.DTD_FILE_NAME);
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(fileOutputStream);
        BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
        StringBuffer stringBuffer = new StringBuffer();
        while (bufferedInputStream.available() > 0) {
            byte[] byArray = new byte[bufferedInputStream.available()];
            bufferedInputStream.read(byArray);
            stringBuffer.append(new String(byArray));
        }
        outputStreamWriter.write(stringBuffer.toString().trim());
        this.createdTempDTD = true;
        try {
            if (outputStreamWriter != null) {
                outputStreamWriter.close();
            }
            if (fileOutputStream != null) {
                fileOutputStream.close();
            }
        }
        catch (IOException iOException) {
            this.tracer.println("Error while closing InputStream...Exception.msg=" + iOException.getMessage());
        }
        this.tracer.println("Read and created temp DTD file: jpos/res/jcl.dtd");
    }

    protected void removeTempDTD() {
        try {
            File file;
            if (this.createdTempDTD) {
                file = new File(AbstractXercesRegPopulator.DTD_FILE_NAME);
                file.delete();
            }
            if (this.createdTempDir) {
                this.tracer.println("Deleting the DTD temp jpos/res/ directories...");
                file = new File(DTD_JPOS_RES_FILE_PATH);
                file.delete();
                File file2 = new File(DTD_JPOS_FILE_PATH);
                file2.delete();
            }
        }
        catch (Exception exception) {
            this.tracer.println("Error removing temporary DTD file.  Exception.msg= " + exception.getMessage());
        }
    }

    protected Enumeration extractJposEntries(Document document) {
        Vector<SimpleEntry> vector;
        block16: {
            vector = new Vector<SimpleEntry>();
            NodeList nodeList = document.getElementsByTagName("JposEntry");
            String string = "";
            try {
                int n = 0;
                while (n < nodeList.getLength()) {
                    Node node = nodeList.item(n);
                    if (node.getNodeType() == 1) {
                        Object object;
                        SimpleEntry simpleEntry = new SimpleEntry();
                        Element element = (Element)node;
                        string = element.getAttribute("logicalName");
                        simpleEntry.addProperty("logicalName", string);
                        NodeList nodeList2 = nodeList.item(n).getChildNodes();
                        int n2 = 0;
                        while (n2 < nodeList2.getLength()) {
                            object = nodeList2.item(n2);
                            if (object.getNodeType() == 1) {
                                Element element2 = (Element)object;
                                String string2 = element2.getNodeName();
                                if (string2.equals("creation")) {
                                    this.extractCreationAttr(simpleEntry, element2);
                                } else if (string2.equals("vendor")) {
                                    this.extractVendorAttr(simpleEntry, element2);
                                } else if (string2.equals(DTD_JPOS_FILE_PATH)) {
                                    this.extractJposAttr(simpleEntry, element2);
                                } else if (string2.equals("product")) {
                                    this.extractProductAttr(simpleEntry, element2);
                                } else {
                                    this.extractPropAttr(simpleEntry, element2);
                                }
                            }
                            ++n2;
                        }
                        if (JposEntryUtility.isValidJposEntry(simpleEntry)) {
                            vector.addElement(simpleEntry);
                        } else {
                            object = "JposEntry with logicalName: " + string + " is not valid (missing required properties)";
                            throw new JposConfigException((String)object);
                        }
                    }
                    ++n;
                }
            }
            catch (JposConfigException jposConfigException) {
                this.tracer.println("Skipping invalid entry with logicalName: " + string);
                this.tracer.println("--->JposConfigException.message = " + jposConfigException.getMessage());
                this.tracer.print(jposConfigException);
                if (jposConfigException.getOrigException() == null) break block16;
                this.tracer.print(jposConfigException.getOrigException());
            }
        }
        return vector.elements();
    }

    protected void extractCreationAttr(JposEntry jposEntry, Element element) {
        jposEntry.addProperty("serviceInstanceFactoryClass", element.getAttribute("factoryClass"));
        jposEntry.addProperty("serviceClass", element.getAttribute("serviceClass"));
    }

    protected void extractVendorAttr(JposEntry jposEntry, Element element) {
        jposEntry.addProperty("vendorName", element.getAttribute("name"));
        jposEntry.addProperty("vendorURL", element.getAttribute("url"));
    }

    protected void extractJposAttr(JposEntry jposEntry, Element element) {
        jposEntry.addProperty("jposVersion", element.getAttribute("version"));
        jposEntry.addProperty("deviceCategory", element.getAttribute("category"));
    }

    protected void extractProductAttr(JposEntry jposEntry, Element element) {
        jposEntry.addProperty("productName", element.getAttribute("name"));
        jposEntry.addProperty("productDescription", element.getAttribute("description"));
        jposEntry.addProperty("productURL", element.getAttribute("url"));
    }

    protected void extractPropAttr(JposEntry jposEntry, Element element) throws JposConfigException {
        String string = element.getAttribute("name");
        String string2 = element.getAttribute("value");
        String string3 = element.getAttribute("type");
        if (string3.equals("")) {
            string3 = "String";
        }
        Object object = null;
        Class<?> clazz = null;
        try {
            clazz = Class.forName(string3.startsWith("java.lang.") ? string3 : "java.lang." + string3);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new JposConfigException("Invalid property type: " + string3 + " for property named: " + string, classNotFoundException);
        }
        if (!JposEntryUtility.isValidPropType(clazz)) {
            throw new JposConfigException("Invalid property type: " + string3 + " for property named: " + string);
        }
        object = JposEntryUtility.parsePropValue(string2, clazz);
        if (!JposEntryUtility.validatePropValue(object, clazz)) {
            throw new JposConfigException("Invalid property type: " + string3 + " for property named: " + string);
        }
        jposEntry.add(jposEntry.createProp(string, object, clazz));
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

