/*
 * Decompiled with CFR 0.152.
 */
package jpos.loader;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import jpos.JposTestCase;
import jpos.config.JposEntry;
import junit.framework.Assert;

public abstract class AbstractTestCase
extends JposTestCase {
    protected List entryList = null;
    protected String[] populatorTypes = new String[]{"XML", "Serialized", "XML"};
    protected String[] populatorClasses = new String[]{"jpos.config.simple.xml.SimpleXmlRegPopulator", "jpos.config.simple.SimpleRegPopulator", "jpos.config.simple.xml.SimpleXmlRegPopulator"};
    protected String[] populatorFiles = new String[]{JposTestCase.TEST_DATA_PATH + "populator0.xml", JposTestCase.TEST_DATA_PATH + "populator1.cfg", JposTestCase.TEST_DATA_PATH + "populator2.xml"};
    protected int[] multiEntrySizes = new int[]{5, 10, 15};
    protected List[] multiEntryLists = new List[3];
    protected HashMap propertiesMap = null;
    public static final int MAX_JPOSENTRIES = 10;
    public static final String MANAGER_CLASS = "jpos.loader.simple.SimpleServiceManager";
    public static final String POPULATOR_CLASS = "jpos.config.simple.SimpleRegPopulator";
    public static final String POPULATOR_FILE = JposTestCase.TEST_DATA_PATH + "ServiceLoaderTestCase.cfg";

    public AbstractTestCase(String string) {
        super(string);
    }

    protected void setUp() throws Exception {
        if (this.useSimpleProfile()) {
            this.createSimplePropFile();
        } else {
            this.createMultiPropFile();
        }
    }

    protected void tearDown() throws Exception {
        if (this.useSimpleProfile()) {
            this.deleteSimplePropFile();
        } else {
            this.deleteMultiPropFile();
        }
    }

    protected abstract boolean useSimpleProfile();

    protected List getEntriesList() {
        if (this.useSimpleProfile()) {
            return this.entryList;
        }
        ArrayList arrayList = new ArrayList();
        int n = 0;
        while (n < this.multiEntryLists.length) {
            Iterator iterator = this.multiEntryLists[n].iterator();
            while (iterator.hasNext()) {
                arrayList.add(iterator.next());
            }
            ++n;
        }
        return arrayList;
    }

    protected void printEntries(Enumeration enumeration) {
        LinkedList linkedList = new LinkedList();
        while (enumeration.hasMoreElements()) {
            linkedList.add(enumeration.nextElement());
        }
        this.printEntries(linkedList.iterator());
    }

    protected void printEntries(List list) {
        this.printEntries(list.iterator());
    }

    protected void printEntries(Iterator iterator) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<printEntries>\n");
        int n = 0;
        while (iterator.hasNext()) {
            JposEntry jposEntry = (JposEntry)iterator.next();
            stringBuffer.append("entry" + n + ".LogicalName = " + jposEntry.getLogicalName() + "\n");
            ++n;
        }
        stringBuffer.append("</printEntries>\n");
        this.println(stringBuffer.toString());
    }

    private void createPropertiesMap(Properties properties) {
        this.propertiesMap = new HashMap();
        Enumeration<Object> enumeration = properties.keys();
        while (enumeration.hasMoreElements()) {
            Object object = enumeration.nextElement();
            this.propertiesMap.put(object, properties.get(object));
        }
    }

    private void createSimplePropFile() throws Exception {
        Properties properties = new Properties();
        properties.put("jpos.util.tracing", "OFF");
        properties.put("jpos.loader.serviceManagerClass", MANAGER_CLASS);
        properties.put("jpos.config.regPopulatorClass", POPULATOR_CLASS);
        properties.put("jpos.config.populatorFile", POPULATOR_FILE);
        this.createPropFile(properties);
        this.createPropertiesMap(properties);
        this.entryList = this.createDefaultSerializedJposEntriesFile(POPULATOR_FILE, 10);
    }

    private void deleteSimplePropFile() throws IOException {
        new File(POPULATOR_FILE).delete();
        this.restorePropFile();
        this.entryList = null;
        this.propertiesMap = null;
    }

    private void createMultiPropFile() throws Exception {
        Properties properties = new Properties();
        properties.put("jpos.util.tracing", "OFF");
        properties.put("jpos.loader.serviceManagerClass", MANAGER_CLASS);
        int n = 0;
        int n2 = 0;
        while (n2 < this.populatorClasses.length) {
            properties.put("jpos.config.populator.class." + n2, this.populatorClasses[n2]);
            properties.put("jpos.config.populator.file." + n2, this.populatorFiles[n2]);
            if (this.populatorTypes[n2].equals("XML")) {
                this.multiEntryLists[n2] = this.createDefaultXmlJposEntriesFile(this.populatorFiles[n2], n, this.multiEntrySizes[n2]);
                Assert.assertTrue((String)("Could not create populator file: " + this.populatorFiles[n2]), (boolean)new File(this.populatorFiles[n2]).exists());
            } else {
                this.multiEntryLists[n2] = this.createDefaultSerializedJposEntriesFile(this.populatorFiles[n2], n, this.multiEntrySizes[n2]);
                Assert.assertTrue((String)("Could not create populator file: " + this.populatorFiles[n2]), (boolean)new File(this.populatorFiles[n2]).exists());
            }
            n += this.multiEntrySizes[n2];
            ++n2;
        }
        this.createPropertiesMap(properties);
        this.createPropFile(properties);
    }

    private void deleteMultiPropFile() throws IOException {
        int n = 0;
        while (n < this.populatorFiles.length) {
            new File(this.populatorFiles[n]).delete();
            ++n;
        }
        this.restorePropFile();
        this.populatorClasses = null;
        this.populatorFiles = null;
        this.multiEntrySizes = null;
        this.multiEntryLists = null;
        this.propertiesMap = null;
    }
}

