/*
 * Decompiled with CFR 0.152.
 */
package jpos.profile;

import java.util.Enumeration;
import java.util.Vector;
import jpos.JposTestCase;
import jpos.profile.DefaultProfile;
import jpos.profile.DefaultProfileRegistry;
import jpos.profile.Profile;
import jpos.profile.ProfileRegistry;
import jpos.test.JUnitUtility;
import junit.framework.Assert;

public class ProfileRegistryTestCase
extends JposTestCase {
    private ProfileRegistry registry = null;
    private Profile profile0 = null;
    private Profile profile1 = null;
    private Profile profile2 = null;
    private Profile profile3 = null;

    public ProfileRegistryTestCase(String string) {
        super(string);
    }

    protected void setUp() {
        this.registry = new DefaultProfileRegistry();
        this.profile0 = new DefaultProfile("profile0");
        this.profile1 = new DefaultProfile("profile1");
        this.profile2 = new DefaultProfile("profile2");
        this.profile3 = new DefaultProfile("profile3");
    }

    protected void tearDown() {
        this.registry = null;
        this.profile0 = null;
        this.profile1 = null;
        this.profile2 = null;
        this.profile3 = null;
    }

    public void testProfileRegistry1() {
        Assert.assertTrue((String)"registry should be empty", (boolean)this.registry.isEmpty());
        Assert.assertTrue((String)"registry size should be 0", (this.registry.getSize() == 0 ? 1 : 0) != 0);
        Vector<Profile> vector = new Vector<Profile>();
        this.registry.addProfile(this.profile0);
        this.registry.addProfile(this.profile1);
        this.registry.addProfile(this.profile2);
        this.registry.addProfile(this.profile3);
        vector.add(this.profile0);
        vector.add(this.profile1);
        vector.add(this.profile2);
        vector.add(this.profile3);
        Assert.assertTrue((String)"registry should NOT be empty", (!this.registry.isEmpty() ? 1 : 0) != 0);
        Assert.assertTrue((String)"registry size should be 4", (this.registry.getSize() == 4 ? 1 : 0) != 0);
        Assert.assertTrue((String)"registry contents should be <profile0, profile1, profile2, profile3>", (boolean)JUnitUtility.isEquals((Enumeration)this.registry.getProfiles(), vector.elements()));
        this.registry.removeProfile(this.profile1);
        this.registry.removeProfile(this.profile3);
        vector.remove(this.profile1);
        vector.remove(this.profile3);
        Assert.assertTrue((String)"registry should NOT be empty", (!this.registry.isEmpty() ? 1 : 0) != 0);
        Assert.assertTrue((String)"registry size should be 2", (this.registry.getSize() == 2 ? 1 : 0) != 0);
        Assert.assertTrue((String)"registry contents should be <profile0, profile1, profile2, profile3>", (boolean)JUnitUtility.isEquals((Enumeration)this.registry.getProfiles(), vector.elements()));
    }

    public void testProfileRegistry2() {
        this.emptyTest();
    }
}

