/*
 * Decompiled with CFR 0.152.
 */
package jpos.util.tracing;

import jpos.util.tracing.Tracer;
import jpos.util.tracing.TracerFactory;
import junit.framework.Assert;
import junit.framework.TestCase;

public class TracerFactoryTestCase
extends TestCase {
    private TracerFactory tracerFactory = null;
    private Tracer globalTracer = null;
    private Tracer tracer1 = null;
    private Tracer tracer2 = null;
    public static final String NAMEDTRACER1_NAME = "NamedTracer1";
    public static final String NAMEDTRACER2_NAME = "NamedTracer2";

    public TracerFactoryTestCase(String string) {
        super(string);
    }

    protected void setUp() {
        this.tracerFactory = TracerFactory.getInstance();
        this.globalTracer = this.tracerFactory.createGlobalTracer();
        this.tracer1 = this.tracerFactory.createTracer(NAMEDTRACER1_NAME);
        this.tracer2 = this.tracerFactory.createTracer(NAMEDTRACER2_NAME);
    }

    protected void tearDown() {
        this.tracerFactory = null;
        this.globalTracer = null;
        this.tracer1 = null;
        this.tracer2 = null;
    }

    public void testGetInstance() {
        Assert.assertTrue((String)"TracerFactory.getInstance() return different instances", (this.tracerFactory == TracerFactory.getInstance() ? 1 : 0) != 0);
    }

    public void testCreateGlobalTracer() {
        Assert.assertTrue((String)"Got different GlobalTracer objects", (this.globalTracer == TracerFactory.getInstance().createGlobalTracer() ? 1 : 0) != 0);
        Assert.assertTrue((String)"Got a GlobalTracer with incorrect state", (TracerFactory.getInstance().createGlobalTracer(true).isOn() ? 1 : 0) != 0);
    }

    public void testCreateTracer1() {
        Assert.assertTrue((String)"Got different Tracer1 objects", (this.tracer1 == TracerFactory.getInstance().createTracer(NAMEDTRACER1_NAME) ? 1 : 0) != 0);
        Assert.assertTrue((String)"Got different Tracer2 objects", (this.tracer2 == TracerFactory.getInstance().createTracer(NAMEDTRACER2_NAME) ? 1 : 0) != 0);
        Assert.assertTrue((String)"Got a Tracer with incorrect state", (TracerFactory.getInstance().createTracer(NAMEDTRACER1_NAME, true).isOn() ? 1 : 0) != 0);
        Assert.assertTrue((String)"Got a Tracer with incorrect state", (!TracerFactory.getInstance().createTracer(NAMEDTRACER1_NAME, false).isOn() ? 1 : 0) != 0);
    }

    public void testCreateTracer2() {
    }

    public void testSetPrintStream() {
    }
}

