/*
 * Decompiled with CFR 0.152.
 */
package de.ailis.usb4java.libusb;

import de.ailis.usb4java.libusb.DeviceHandle;
import de.ailis.usb4java.libusb.Interface;
import de.ailis.usb4java.utils.DescriptorUtils;
import java.nio.ByteBuffer;
import javax.usb.UsbConfigurationDescriptor;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public final class ConfigDescriptor
implements UsbConfigurationDescriptor {
    private long configDescriptorPointer;

    public long getPointer() {
        return this.configDescriptorPointer;
    }

    @Override
    public native byte bLength();

    @Override
    public native byte bDescriptorType();

    @Override
    public native short wTotalLength();

    @Override
    public native byte bNumInterfaces();

    @Override
    public native byte bConfigurationValue();

    @Override
    public native byte iConfiguration();

    @Override
    public native byte bmAttributes();

    @Override
    public native byte bMaxPower();

    public native Interface[] iface();

    public native ByteBuffer extra();

    public native int extraLength();

    public String dump() {
        return this.dump(null);
    }

    public String dump(DeviceHandle handle) {
        StringBuilder builder = new StringBuilder();
        builder.append(String.format("%s%n  extralen %17d%n  extra:%n%s", DescriptorUtils.dump(this), this.extraLength(), DescriptorUtils.dump(this.extra()).replaceAll("(?m)^", "    ")));
        for (Interface descriptor : this.iface()) {
            builder.append(descriptor.dump(handle).replaceAll("(?m)^", "  "));
        }
        return builder.toString();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        ConfigDescriptor other = (ConfigDescriptor)obj;
        return new EqualsBuilder().append(this.bDescriptorType(), other.bDescriptorType()).append(this.bLength(), other.bLength()).append(this.bConfigurationValue(), other.bConfigurationValue()).append(this.bmAttributes(), other.bmAttributes()).append(this.bNumInterfaces(), other.bNumInterfaces()).append(this.iConfiguration(), other.iConfiguration()).append(this.bMaxPower(), other.bMaxPower()).append(this.wTotalLength(), other.wTotalLength()).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder().append(this.bLength()).append(this.bDescriptorType()).append(this.wTotalLength()).append(this.bNumInterfaces()).append(this.bConfigurationValue()).append(this.iConfiguration()).append(this.bmAttributes()).append(this.bMaxPower()).append(this.extra()).append(this.extraLength()).toHashCode();
    }

    public String toString() {
        return this.dump();
    }
}

