/** 
 (C) Copyright IBM Corporation 2006
 DISCLAIMER OF WARRANTIES.  The following [enclosed] code is
 sample code created by IBM Corporation. This sample code is not
 part of any standard or IBM product and is provided to you solely
 for  the purpose of assisting you in the development of your
 applications.  The code is provided "AS IS", without
 warranty of any kind.  IBM shall not be liable for any damages
 arising out of your use of the sample code, even if they have been
 advised of the possibility of such damages.
 */

package com.ibm.jpos.tools.sdicc.demo;

import java.awt.Font;
import java.io.IOException;
import java.io.InputStream;

import javax.swing.JEditorPane;
import javax.swing.JScrollPane;


class FileViewerPanel extends JScrollPane
{
    /**
     * 
     */
    private static final long serialVersionUID = 1L;
    //-------------------------------------------------------------------------
    // public methods
    //
    public FileViewerPanel()
    {
        editorPane = new JEditorPane();
        Font font = new Font( "Monospaced", Font.PLAIN, 10 );
        
        editorPane.setFont( font );
        editorPane.setEditable(false);
        setViewportView( editorPane );
    }
    
    /**
     * @param fileName the relative fileName to set
     * */
    public void setFile(String fileName)
    {
        if (currentFile.equalsIgnoreCase(fileName))
            // File already loaded
            return;

        try
        {
            if (com.ibm.jutil.FileUtil.locateFile(fileName, true, true))
            {
                InputStream is = com.ibm.jutil.FileUtil.loadFile(fileName,
                        true, true);
                byte[] fileContent = null;

                if (is != null)
                {
                    fileContent = new byte[is.available()];
                    is.read(fileContent);
                    is.close();
                }

                editorPane.setText(new String(fileContent));
                editorPane.setCaretPosition(0);
            }
        }catch(NoClassDefFoundError nce){
            editorPane.setText("NoClassDefFoundError - IBM UPOS needed to display  source code\n" + nce);
        }catch (IOException ioe){
            editorPane.setText(" IOException  - Could not read source file\n" +ioe);
        }catch(Exception e){
            editorPane.setText(" Exception - Could not read source file\n" + e);
        }finally
        {
            editorPane.setEditable(false);
        }

    }
    
    //-------------------------------------------------------------------------
    // private variables
    //
    private String currentFile = "";
    private JEditorPane editorPane;

}
