/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jpos.services;

import com.ibm.jpos.services.DeviceService;
import com.ibm.jpos.services.ServiceKey;
import com.ibm.jpos.services.ServiceRegistry;
import com.ibm.jpos.util.JposEntryInfo;
import jpos.JposException;

public class DeviceServiceState {
    private JposEntryInfo jposEntryInfo = null;
    private boolean zombified = false;
    private ServiceKey serviceKey = null;
    private DeviceService deviceService = null;
    private String checkHealthText = "";
    private boolean deviceEnabled = false;
    private String deviceServiceDescription = "";
    private int deviceServiceVersion = 1005134;
    private boolean freezeEvents = false;
    private String physicalDeviceDescription = "";
    private String physicalDeviceName = "";
    private int state = 1;
    private int capPowerReporting = 0;
    private int powerNotify = 0;
    private int powerState = 2000;

    DeviceServiceState() {
    }

    public synchronized void isOpen() throws JposException {
        if (this.state == 1) {
            throw new JposException(101);
        }
    }

    public synchronized void isEnable() throws JposException {
        if (!this.deviceEnabled) {
            throw new JposException(105);
        }
    }

    public synchronized void isClaim() throws JposException {
        DeviceService deviceService = ServiceRegistry.getInstance().getClaimedService(this.getServiceKey());
        if (deviceService == this.getDeviceService()) {
            return;
        }
        if (deviceService == null) {
            throw new JposException(103);
        }
        throw new JposException(102);
    }

    public synchronized void isOpenEnable() throws JposException {
        this.isOpen();
        this.isEnable();
    }

    public synchronized void isOpenClaim() throws JposException {
        this.isOpen();
        this.isClaim();
    }

    public synchronized void isOpenClaimEnable() throws JposException {
        this.isOpen();
        this.isClaim();
        this.isEnable();
    }

    public synchronized boolean isZombified() {
        return this.zombified;
    }

    public synchronized JposEntryInfo getJposEntryInfo() {
        return this.jposEntryInfo;
    }

    synchronized void setJposEntryInfo(JposEntryInfo jposEntryInfo) {
        if (this.jposEntryInfo == null) {
            this.jposEntryInfo = jposEntryInfo;
        }
    }

    public synchronized ServiceKey getServiceKey() {
        return this.serviceKey;
    }

    synchronized DeviceService getDeviceService() {
        return this.deviceService;
    }

    public synchronized void setServiceKey(ServiceKey serviceKey) {
        if (this.serviceKey == null) {
            this.serviceKey = serviceKey;
        }
    }

    synchronized void setDeviceService(DeviceService deviceService) {
        this.deviceService = deviceService;
    }

    public synchronized String getCheckHealthText() {
        return this.checkHealthText;
    }

    public synchronized boolean getClaimed() {
        DeviceService deviceService = ServiceRegistry.getInstance().getClaimedService(this.getServiceKey());
        return deviceService == this.getDeviceService();
    }

    public synchronized boolean getDeviceEnabled() {
        return this.deviceEnabled;
    }

    public synchronized String getDeviceServiceDescription() {
        return this.deviceServiceDescription;
    }

    public synchronized int getDeviceServiceVersion() {
        return this.deviceServiceVersion;
    }

    public synchronized boolean getFreezeEvents() {
        return this.freezeEvents;
    }

    public synchronized String getPhysicalDeviceDescription() {
        return this.physicalDeviceDescription;
    }

    public synchronized String getPhysicalDeviceName() {
        return this.physicalDeviceName;
    }

    public synchronized int getState() {
        return this.state;
    }

    public int getCapPowerReporting() {
        return this.capPowerReporting;
    }

    public int getPowerNotify() {
        return this.powerNotify;
    }

    public int getPowerState() {
        return this.powerState;
    }

    public synchronized void setCheckHealthText(String string) {
        this.checkHealthText = string;
    }

    synchronized void setClaimed(boolean bl) {
        ServiceRegistry serviceRegistry = ServiceRegistry.getInstance();
        synchronized (serviceRegistry) {
            DeviceService deviceService = ServiceRegistry.getInstance().getClaimedService(this.getServiceKey());
            if (bl) {
                if (deviceService == this.getDeviceService()) {
                    return;
                }
                if (deviceService == null) {
                    ServiceRegistry.getInstance().setClaimedService(this.getServiceKey(), this.getDeviceService());
                }
            } else if (deviceService == this.getDeviceService() && this.getDeviceService() != null) {
                ServiceRegistry.getInstance().setClaimedService(this.getServiceKey(), null);
            }
        }
    }

    public synchronized void setDeviceEnabled(boolean bl) {
        this.deviceEnabled = bl;
    }

    public synchronized void setDeviceServiceDescription(String string) {
        this.deviceServiceDescription = string;
    }

    public synchronized void setDeviceServiceVersion(int n) {
        this.deviceServiceVersion = n;
    }

    synchronized void setFreezeEvents(boolean bl) {
        this.freezeEvents = bl;
    }

    public synchronized void setPhysicalDeviceDescription(String string) {
        this.physicalDeviceDescription = string;
    }

    public synchronized void setPhysicalDeviceName(String string) {
        this.physicalDeviceName = string;
    }

    public synchronized void setState(int n) throws JposException {
        this.checkStateValue(n);
        this.state = n;
    }

    public void setCapPowerReporting(int n) throws JposException {
        this.checkCapPowerReportingValue(n);
        this.capPowerReporting = n;
    }

    public void setPowerNotify(int n) throws JposException {
        this.checkPowerNotifyValue(n);
        this.powerNotify = n;
    }

    public void setPowerState(int n) throws JposException {
        this.checkPowerStateValue(n);
        this.powerState = n;
    }

    public void checkNegativeValue(int n) throws JposException {
        if (n < 0) {
            throw new JposException(106);
        }
    }

    public void checkNegativeOrZeroValue(int n) throws JposException {
        if (n == 0) {
            throw new JposException(106);
        }
        this.checkNegativeValue(n);
    }

    public void checkNullValue(Object object) throws JposException {
        if (object == null) {
            throw new JposException(106);
        }
    }

    public void checkStateValue(int n) throws JposException {
        switch (n) {
            case 3: {
                break;
            }
            case 1: {
                break;
            }
            case 4: {
                break;
            }
            case 2: {
                break;
            }
            default: {
                throw new JposException(106);
            }
        }
    }

    public void checkCapPowerReportingValue(int n) throws JposException {
        switch (n) {
            case 0: {
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                break;
            }
            default: {
                throw new JposException(106);
            }
        }
    }

    public void checkPowerNotifyValue(int n) throws JposException {
        switch (n) {
            case 0: {
                break;
            }
            case 1: {
                break;
            }
            default: {
                throw new JposException(106);
            }
        }
    }

    public void checkPowerStateValue(int n) throws JposException {
        switch (n) {
            case 2000: {
                break;
            }
            case 2001: {
                break;
            }
            case 2002: {
                break;
            }
            case 2003: {
                break;
            }
            case 2004: {
                break;
            }
            default: {
                throw new JposException(106);
            }
        }
    }

    synchronized void setZombified(boolean bl) {
        if (bl) {
            this.zombified = bl;
        }
    }

    synchronized void initProperties() throws JposException {
        this.setCheckHealthText("");
        this.setClaimed(false);
        this.setDeviceEnabled(false);
        this.setDeviceServiceDescription("");
        this.setDeviceServiceVersion(1005134);
        this.setFreezeEvents(false);
        this.setPhysicalDeviceDescription("");
        this.setPhysicalDeviceName("");
        this.setState(1);
        this.setCapPowerReporting(0);
        this.setPowerNotify(0);
        this.setPowerState(2000);
    }
}

