/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jpos.services;

import com.ibm.jpos.services.DeviceService;
import com.ibm.jpos.services.ServiceKey;
import java.util.Enumeration;
import java.util.Vector;

public class ServiceInfo {
    private ServiceKey serviceKey = null;
    private Vector deviceServices = new Vector();
    private DeviceService claimedService = null;
    private DeviceService parentService = null;
    public static final String DEVICESERVICE_KEY_NOT_MATCHING_SERVICEINFO_KEY = "JavaPOS Internal ServiceRegistry Error: DeviceService.State.ServiceKey does not match ServiceInfo.ServiceKey";

    public ServiceInfo(ServiceKey serviceKey) {
        this.serviceKey = serviceKey;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("---------------------------------------\n");
        stringBuffer.append("ServiceInfo for key = " + this.getServiceKey().toString() + "\n");
        stringBuffer.append("    Number of DeviceService = " + this.deviceServices.size() + "\n");
        stringBuffer.append("    ClaimedService = " + this.getClaimedService() + "\n");
        int n = 0;
        while (n < this.deviceServices.size()) {
            stringBuffer.append("        DeviceService #" + n + " " + this.deviceServices.elementAt(n) + "\n");
            ++n;
        }
        stringBuffer.append("---------------------------------------");
        return stringBuffer.toString();
    }

    public ServiceKey getServiceKey() {
        return this.serviceKey;
    }

    public DeviceService getClaimedService() {
        return this.claimedService;
    }

    public void setClaimedService(DeviceService deviceService) {
        if (deviceService == null) {
            this.claimedService = null;
            return;
        }
        if (!this.deviceServices.contains(deviceService)) {
            this.deviceServices.addElement(deviceService);
        }
        this.claimedService = deviceService;
    }

    public Enumeration getDeviceServices() {
        return this.deviceServices.elements();
    }

    public void addDeviceService(DeviceService deviceService) throws IllegalArgumentException {
        if (!deviceService.getDeviceServiceState().getServiceKey().equals(this.getServiceKey())) {
            throw new IllegalArgumentException(DEVICESERVICE_KEY_NOT_MATCHING_SERVICEINFO_KEY);
        }
        if (!this.deviceServices.contains(deviceService)) {
            this.deviceServices.addElement(deviceService);
        }
    }

    public void removeDeviceService(DeviceService deviceService) throws IllegalArgumentException {
        if (!deviceService.getDeviceServiceState().getServiceKey().equals(this.getServiceKey())) {
            throw new IllegalArgumentException(DEVICESERVICE_KEY_NOT_MATCHING_SERVICEINFO_KEY);
        }
        this.deviceServices.removeElement(deviceService);
    }

    public boolean containsDeviceService(DeviceService deviceService) {
        return this.deviceServices.contains(deviceService);
    }
}

