/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jpos.services.ibmprinter;

import com.ibm.jpos.services.DeviceServiceAbstraction;
import com.ibm.jpos.services.ibmprinter.DocumentManagementImplementor;
import com.ibm.jpos.services.ibmprinter.MicrPrinterState;
import com.ibm.jpos.services.ibmprinter.PrinterCommunicationsManager;
import com.ibm.jpos.util.Tracer;
import com.ibm.poss.Printer;
import jpos.JposConst;
import jpos.JposException;
import jpos.POSPrinterConst;

public class DocumentManager
implements JposConst,
POSPrinterConst,
Printer {
    MicrPrinterState impServiceState = null;
    DeviceServiceAbstraction serviceAbstraction = null;
    DocumentManagementImplementor documentImp = null;
    PrinterCommunicationsManager printerManager = null;
    boolean isMicrDevice = false;
    boolean insertionMode = false;
    boolean removalMode = false;
    int lastPossStation;
    private static final String className = "DocumentManager";

    public DocumentManager(DeviceServiceAbstraction deviceServiceAbstraction, DocumentManagementImplementor documentManagementImplementor, boolean bl) {
        Tracer.trace(4, className, "Constructor", "Entry");
        this.isMicrDevice = bl;
        this.serviceAbstraction = deviceServiceAbstraction;
        this.impServiceState = (MicrPrinterState)((Object)deviceServiceAbstraction.getDeviceServiceState());
        this.documentImp = documentManagementImplementor;
        try {
            this.printerManager = documentManagementImplementor.getPrinterManager();
        }
        catch (JposException jposException) {
            // empty catch block
        }
        Tracer.trace(4, className, "Constructor", "Exit");
    }

    public DocumentManager(DeviceServiceAbstraction deviceServiceAbstraction, DocumentManagementImplementor documentManagementImplementor) {
        Tracer.trace(4, className, "Constructor", "Entry");
        this.isMicrDevice = false;
        this.serviceAbstraction = deviceServiceAbstraction;
        this.impServiceState = (MicrPrinterState)((Object)deviceServiceAbstraction.getDeviceServiceState());
        this.documentImp = documentManagementImplementor;
        try {
            this.printerManager = documentManagementImplementor.getPrinterManager();
        }
        catch (JposException jposException) {
            // empty catch block
        }
        Tracer.trace(4, className, "Constructor", "Exit");
    }

    public void beginInsertion(int n) throws JposException {
        Tracer.trace(4, className, "beginInsertion(" + n + ")", "Entry");
        if (!this.impServiceState.getCapSlpPresent()) {
            throw new JposException(106);
        }
        if (!this.documentImp.isOnline()) {
            throw new JposException(108);
        }
        if (this.impServiceState.getState() == 3 || this.printerManager.outputPending(4) && !this.printerManager.getTransactionMode(4)) {
            throw new JposException(113);
        }
        this.documentImp.setStation(4, true);
        this.insertionMode = true;
        if (n != 0) {
            this.documentImp.waitForSlipInserted(n);
            this.sleep(500);
        } else if (!this.documentImp.isSlipInserted()) {
            throw new JposException(112);
        }
        Tracer.trace(4, className, "beginInsertion(" + n + ")", "Exit");
    }

    public void endInsertion() throws JposException {
        Tracer.trace(4, className, "endInsertion()", "Entry");
        if (!this.insertionMode) {
            throw new JposException(106);
        }
        this.insertionMode = false;
        if (!this.documentImp.isOnline()) {
            throw new JposException(108);
        }
        if (this.impServiceState.getState() == 3 || this.printerManager.outputPending(4) && !this.printerManager.getTransactionMode(4)) {
            throw new JposException(113);
        }
        if (this.impServiceState.getCoverOpen()) {
            throw new JposException(114, 201);
        }
        if (!this.documentImp.isSlipInserted()) {
            throw new JposException(114, 204);
        }
        this.documentImp.setStation(4, true);
        if (!this.documentImp.isSlipReady()) {
            try {
                this.documentImp.doRegisterDocument();
                this.documentImp.waitForSlipReady(2000);
            }
            catch (JposException jposException) {
                try {
                    this.documentImp.setStation(1, true);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (!this.documentImp.isSlipInserted()) {
                    throw new JposException(114, 204);
                }
                throw new JposException(111);
            }
        }
        Tracer.trace(4, className, "endInsertion()", "Exit");
    }

    public void beginRemoval(int n) throws JposException {
        Tracer.trace(4, className, "beginRemoval(" + n + ")", "Entry");
        this.insertionMode = false;
        if (!this.impServiceState.getCapSlpPresent() || this.insertionMode) {
            throw new JposException(106);
        }
        if (!this.documentImp.isOnline()) {
            throw new JposException(108);
        }
        if (this.impServiceState.getState() == 3 || this.printerManager.outputPending(4) || this.printerManager.getTransactionMode(4)) {
            throw new JposException(113);
        }
        this.removalMode = true;
        if (this.documentImp.isSlipInserted()) {
            this.documentImp.setStation(4, true);
            this.documentImp.doEjectDocument();
        }
        this.documentImp.waitForSlipRemoved(n);
        Tracer.trace(4, className, "beginRemoval(" + n + ")", "Exit");
    }

    public void endRemoval() throws JposException {
        Tracer.trace(4, className, "endRemoval()", "Entry");
        if (!this.removalMode) {
            throw new JposException(106);
        }
        this.removalMode = false;
        if (!this.documentImp.isOnline()) {
            throw new JposException(108);
        }
        try {
            this.documentImp.waitForSlipRemoved(500);
        }
        catch (JposException jposException) {
            if (this.documentImp.isSlipInserted()) {
                throw new JposException(114, 205);
            }
            throw new JposException(111);
        }
        Tracer.trace(4, className, "endRemoval()", "Exit");
    }

    void sleep(int n) {
        try {
            Thread.currentThread();
            Thread.sleep(n);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void setCurrentStation(int n) {
        this.lastPossStation = n;
    }

    public int getCurrentStation() {
        try {
            this.lastPossStation = this.documentImp.getCurrentStation();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.lastPossStation;
    }
}

