/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jpos.services.ibmprinter;

import com.ibm.jpos.services.ibmprinter.PrintQueueElement;
import jpos.JposException;
import jpos.POSPrinterConst;

public abstract class PrintQueueData
implements PrintQueueElement,
POSPrinterConst {
    private static final int[] nextOutputID = new int[]{1};
    private int station;
    private boolean asyncMode;
    private boolean reversedLines;
    private int errorLevel;
    private JposException jposException;
    private boolean[] doneMonitor;
    private int outputID;

    public PrintQueueData(int n, boolean bl, boolean bl2) {
        this.station = n;
        this.asyncMode = bl;
        this.reversedLines = bl2;
        this.errorLevel = 1;
        this.jposException = null;
        this.doneMonitor = new boolean[]{false};
        int[] nArray = nextOutputID;
        synchronized (nArray) {
            int n2 = nextOutputID[0];
            nextOutputID[0] = n2 + 1;
            this.outputID = n2;
        }
    }

    public int getStation() {
        return this.station;
    }

    public boolean hasReversedLines() {
        return this.reversedLines;
    }

    public boolean isAsyncMode() {
        return this.asyncMode;
    }

    public int getOutputID() {
        return this.outputID;
    }

    public int getErrorLevel() {
        return this.errorLevel;
    }

    public void setErrorLevel(int n) {
        this.errorLevel = n;
    }

    public JposException getJposException() {
        return this.jposException;
    }

    public void setJposException(JposException jposException) {
        this.jposException = jposException;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void waitUntilDone() {
        boolean[] blArray = this.doneMonitor;
        synchronized (blArray) {
            while (!this.doneMonitor[0]) {
                try {
                    this.doneMonitor.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            return;
        }
    }

    public void notifyDone() {
        boolean[] blArray = this.doneMonitor;
        synchronized (blArray) {
            this.doneMonitor[0] = true;
            this.doneMonitor.notifyAll();
        }
    }
}

