/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jpos.services.jcomm;

import com.ibm.jpos.services.DeviceServiceAbstraction;
import com.ibm.jpos.services.POSPrinterServiceImp;
import com.ibm.jpos.services.POSPrinterServiceState;
import com.ibm.jpos.services.ibmprinter.CacheVector;
import com.ibm.jpos.services.ibmprinter.CacheVectorEntry;
import com.ibm.jpos.services.ibmprinter.DirectIOBitmapInfo;
import com.ibm.jpos.services.ibmprinter.PrintBarCodeData;
import com.ibm.jpos.services.ibmprinter.PrintBitmapImageInfo;
import com.ibm.jpos.services.ibmprinter.PrintDataCompiler;
import com.ibm.jpos.services.ibmprinter.PrinterFont;
import com.ibm.jpos.services.ibmprinter.RotatePrintData;
import com.ibm.jpos.services.ibmprinter.SetCharacterSetData;
import com.ibm.jpos.services.jcomm.Serial4610POSPrinterServiceImp;
import com.ibm.jpos.services.jcomm.Serial4610PrintDataCompiler;
import com.ibm.jpos.util.ByteBuffer;
import com.ibm.jpos.util.ByteEncoder;
import com.ibm.jpos.util.JposEntryInfo;
import com.ibm.jpos.util.Tracer;
import com.ibm.poss.PosDef;
import java.io.UnsupportedEncodingException;
import jpos.JposException;
import jpos.POSPrinterConst;
import jpos.services.EventCallbacks;

public class IBM4610POSPrinterImp
extends Serial4610POSPrinterServiceImp
implements PosDef,
POSPrinterServiceImp,
POSPrinterConst {
    private static final String className = "IBM4610POSPrinterImp";
    protected Serial4610PrintDataCompiler printDataCompiler = null;
    protected boolean serviceStateReset = false;
    protected int[] index = new int[1];
    private String aspectRatioH = "1";
    private String aspectRatioW = "2";
    private String eccLevelH = "0";
    private String eccLevelL = "15";
    private String truncation = "0";

    protected IBM4610POSPrinterImp(DeviceServiceAbstraction deviceServiceAbstraction) throws JposException {
        super(deviceServiceAbstraction);
        Tracer.trace(4, className, "Constructor()", "Entry");
        Tracer.trace(4, className, "Constructor()", "Exit");
    }

    public void open(String string, EventCallbacks eventCallbacks) throws JposException {
        Tracer.trace(4, className, "open(" + string + ")", "Entry");
        super.open(string, eventCallbacks);
        Object object = this.serial4610Device.getIOSemaphore();
        synchronized (object) {
            this.printDataCompiler = new Serial4610PrintDataCompiler((POSPrinterServiceState)this.getDeviceServiceState());
            JposEntryInfo jposEntryInfo = this.serviceState.getJposEntryInfo();
            if (jposEntryInfo != null) {
                if (jposEntryInfo.getPropertyValue("aspectRatioH") != null) {
                    this.aspectRatioH = (String)jposEntryInfo.getPropertyValue("aspectRatioH");
                }
                if (jposEntryInfo.getPropertyValue("aspectRatioW") != null) {
                    this.aspectRatioW = (String)jposEntryInfo.getPropertyValue("aspectRatioW");
                }
                if (jposEntryInfo.getPropertyValue("eccLevelH") != null) {
                    this.eccLevelH = (String)jposEntryInfo.getPropertyValue("eccLevelH");
                }
                if (jposEntryInfo.getPropertyValue("eccLevelL") != null) {
                    this.eccLevelL = (String)jposEntryInfo.getPropertyValue("eccLevelL");
                }
                if (jposEntryInfo.getPropertyValue("truncation") != null) {
                    this.truncation = (String)jposEntryInfo.getPropertyValue("truncation");
                }
            }
            Tracer.trace(4, className, "open()", "Exit");
        }
    }

    public void setDeviceEnabled(boolean bl) throws JposException {
        Tracer.trace(4, className, "setDeviceEnabled(" + bl + ")", "Entry");
        super.setDeviceEnabled(bl);
        Tracer.trace(4, className, "setDeviceEnabled()", "Exit");
    }

    protected PrintDataCompiler getPrintDataCompiler() {
        return this.printDataCompiler;
    }

    protected void processDynamicCapabilities() throws JposException {
        Tracer.trace(4, className, "processDynamicCapabilities()", "Entry");
        super.processDynamicCapabilities();
        Object object = this.serial4610Device.getIOSemaphore();
        synchronized (object) {
            try {
                if (ByteEncoder.isDBCSCodePage(ByteEncoder.getCodePage(this.serviceState.getCharacterSet()))) {
                    Tracer.trace(4, className, "processDynamicCapabilities()", "Code page is DBCS");
                    this.serviceState.setCapSlpLeft90(false);
                    this.serviceState.setSlpSidewaysMaxChars(0);
                    this.serviceState.setSlpSidewaysMaxLines(0);
                } else {
                    Tracer.trace(4, className, "processDynamicCapabilities()", "Code page is SBCS");
                    this.serviceState.setCapSlpLeft90(true);
                    this.serviceState.setSlpSidewaysMaxChars(147);
                    this.serviceState.setSlpSidewaysMaxLines(17);
                }
            }
            catch (Exception exception) {
                this.checkPrinterErrorCause();
                throw this.createJposException(exception);
            }
            if ((this.serial4610Device.getPrinterID()[2] & 2) != 0) {
                this.serviceState.setCapSlpBothSidesPrint(true);
            }
            Tracer.trace(4, className, "processDynamicCapabilities()", "Exit");
        }
    }

    void doDirectIOFlipCheck() throws JposException {
        Tracer.trace(4, className, "doDirectIOFlipCheck()", "Entry");
        Object object = this.serial4610Device.getIOSemaphore();
        synchronized (object) {
            if (!this.serviceState.getCapSlpBothSidesPrint()) {
                throw new JposException(111, "Flipper not present.");
            }
            if (this.serviceState.getCoverOpen()) {
                throw new JposException(114, 201);
            }
            if (this.documentInserted.isFalse()) {
                throw new JposException(114, 204);
            }
            this.selectStations(4);
            this.serial4610Device.write(new byte[]{27, 53});
            this.chase(30000);
            Tracer.trace(4, className, "doDirectIOFlipCheck()", "Exit");
        }
    }

    void doDirectIOPrintDownloadedBitmap(int n, DirectIOBitmapInfo directIOBitmapInfo) throws JposException {
        Tracer.trace(4, className, "doDirectIOPrintDownloadedBitmap(" + n + ")", "Entry");
        StringBuffer stringBuffer = new StringBuffer();
        Object object = this.serial4610Device.getIOSemaphore();
        synchronized (object) {
            if (n == 0) {
                this.clearBitmaps();
                if (this.printBitmapUtil != null) {
                    this.printBitmapUtil.cacheVector.removeAllElements(CacheVector.BITMAP);
                }
            } else {
                if (n > 40) {
                    throw new JposException(106);
                }
                if (this.printBitmapUtil == null) {
                    throw new JposException(111);
                }
                CacheVectorEntry cacheVectorEntry = this.printBitmapUtil.cacheVector.get(CacheVector.BITMAP, directIOBitmapInfo.station, n);
                if (cacheVectorEntry == null) {
                    throw new JposException(111);
                }
                Serial4610POSPrinterServiceImp.debugPrintBitmap.println("printing " + n + " from " + cacheVectorEntry.index);
                this.checkStations(directIOBitmapInfo.station);
                this.selectStations(directIOBitmapInfo.station);
                byte[] byArray = new byte[]{29, 47, 0, (byte)cacheVectorEntry.index};
                this.chaseCompleted.set(false);
                try {
                    this.serial4610Device.write(byArray);
                    this.chase(30000);
                }
                catch (Exception exception) {
                    throw this.createJposException(exception);
                }
            }
            Tracer.trace(4, className, "doDirectIOPrintDownloadedBitmap()", "Exit");
        }
    }

    void doDirectIOPrintDownloadedMessage(int n) throws JposException {
        Tracer.trace(4, className, "doDirectIOPrintDownloadedMessage(" + n + ")", "Entry");
        Object object = this.serial4610Device.getIOSemaphore();
        synchronized (object) {
            this.printDataCompiler.setLogo(1, "");
            this.printDataCompiler.setLogo(2, "");
            StringBuffer stringBuffer = new StringBuffer();
            if (n == 0) {
                this.clearMessages();
                if (this.printBitmapUtil != null) {
                    this.printBitmapUtil.cacheVector.removeAllElements(CacheVector.MESSAGE);
                }
            } else {
                if (n > 25) {
                    throw new JposException(106);
                }
                CacheVectorEntry cacheVectorEntry = this.printBitmapUtil.cacheVector.get(CacheVector.MESSAGE, -1, n);
                if (cacheVectorEntry == null) {
                    throw new JposException(111);
                }
                int n2 = 2;
                try {
                    this.serial4610Device.write(new byte[]{29, 94, (byte)cacheVectorEntry.index, 27, 71});
                    this.chase();
                }
                catch (Exception exception) {
                    throw this.createJposException(exception);
                }
            }
            Tracer.trace(4, className, "doDirectIOPrintDownloadedMessage()", "Exit");
        }
    }

    public void processRotatePrint(RotatePrintData rotatePrintData) throws JposException {
        Tracer.trace(4, className, "processRotatePrint()", "Entry");
        super.processRotatePrint(rotatePrintData);
        Object object = this.serial4610Device.getIOSemaphore();
        synchronized (object) {
            block2 : switch (rotatePrintData.getStation()) {
                case 2: {
                    switch (rotatePrintData.getRotation()) {
                        case 257: {
                            this.setRecLineSpacing(15);
                            break block2;
                        }
                        case 1: {
                            this.setRecLineSpacing(this.serviceState.getRecLineSpacing());
                        }
                    }
                }
            }
            Tracer.trace(4, className, "processRotatePrint()", "Exit");
        }
    }

    /*
     * Unable to fully structure code
     */
    public void processPrintBarCode(PrintBarCodeData var1_1) throws JposException {
        var2_2 = var1_1.getStation();
        var3_3 = var1_1.getData();
        var4_4 = var1_1.getSymbology();
        var5_5 = var1_1.getHeight();
        var6_6 = var1_1.getWidth();
        var7_7 = var1_1.getAlignment();
        var8_8 = var1_1.getTextPosition();
        var9_9 = this.serviceState.getRecLineWidth();
        Tracer.trace(4, "IBM4610POSPrinterImp", "processPrintBarCode(" + var2_2 + ", " + var3_3 + ", " + var4_4 + ", " + var5_5 + ", " + var6_6 + ", " + var7_7 + ", " + var8_8 + ")", "Entry");
        var10_10 = this.serial4610Device.getIOSemaphore();
        synchronized (var10_10) {
            try {
                block40: {
                    if (this.getPrintingMode(var2_2).getRotation() != 1) {
                        throw new JposException(106);
                    }
                    if (var6_6 > var9_9) {
                        throw new JposException(106);
                    }
                    this.checkStations(var2_2);
                    this.selectStations(var2_2);
                    var11_11 = 0;
                    var12_13 = 0;
                    var15_14 = false;
                    var16_15 = new ByteBuffer();
                    switch (var4_4) {
                        case 101: {
                            var12_13 = 0;
                            break;
                        }
                        case 102: {
                            var12_13 = 1;
                            break;
                        }
                        case 103: {
                            var12_13 = 3;
                            break;
                        }
                        case 104: {
                            var12_13 = 2;
                            break;
                        }
                        case 106: {
                            var12_13 = 5;
                            break;
                        }
                        case 107: {
                            var12_13 = 6;
                            break;
                        }
                        case 108: {
                            var12_13 = 4;
                            break;
                        }
                        case 109: {
                            var12_13 = 8;
                            break;
                        }
                        case 110: {
                            var12_13 = 7;
                            break;
                        }
                        case 201: {
                            break;
                        }
                        default: {
                            throw new JposException(111, "Internal Error: don't recognize validated symbology: " + var4_4);
                        }
                    }
                    switch (var8_8) {
                        case -11: {
                            var11_11 = 0;
                            break;
                        }
                        case -12: {
                            var11_11 = 1;
                            break;
                        }
                        case -13: {
                            var11_11 = 2;
                            break;
                        }
                        default: {
                            throw new JposException(111, "Internal Error: don't recognize validated textPosition: " + var8_8);
                        }
                    }
                    var13_16 = (this.mapModeCalc.convertToPrinterDots(this.serviceState.getMapMode(), var6_6, this.getDotsPerInchWide(var2_2)) + var9_9 / 6) * 3 / var9_9 + 1;
                    if (var13_16 < 2) {
                        var13_16 = 2;
                    } else if (var13_16 > 4) {
                        var13_16 = 4;
                    }
                    var14_17 = this.mapModeCalc.convertToPrinterDots(this.serviceState.getMapMode(), var5_5, this.getDotsPerInchWide(var2_2));
                    if (var14_17 > 255) {
                        throw new JposException(106);
                    }
                    var16_15.append(27).append(97);
                    switch (var7_7) {
                        case -1: {
                            var16_15.append(0);
                            break;
                        }
                        case -2: {
                            var16_15.append(1);
                            break;
                        }
                        case -3: {
                            var16_15.append(2);
                            break;
                        }
                        default: {
                            throw new JposException(106, "Illegal alignment: " + var7_7);
                        }
                    }
                    if (var4_4 != 201) {
                        var16_15.append(29).append(119);
                        var16_15.append(var13_16);
                        var16_15.append(29).append(104);
                        var16_15.append(var14_17);
                        var16_15.append(29).append(72);
                        var16_15.append(var11_11);
                        var16_15.append(29).append(107);
                        var16_15.append(var12_13);
                    } else {
                        var16_15.append(29).append(82);
                        var16_15.append(new Integer(new String(this.eccLevelH.getBytes())));
                        var16_15.append(new Integer(new String(this.eccLevelL.getBytes())));
                        var16_15.append(29).append(83);
                        var16_15.append(new Integer(new String(this.aspectRatioH.getBytes())));
                        var16_15.append(new Integer(new String(this.aspectRatioW.getBytes())));
                        var16_15.append(29).append(84);
                        var16_15.append(new Integer(new String(this.truncation.getBytes())));
                        var16_15.append(29).append(80);
                    }
                    try {
                        var16_15.append(var3_3.getBytes("ISO8859_1"));
                        break block40;
                    }
                    catch (UnsupportedEncodingException var17_18) {
                        var18_19 = 0;
                        ** while (var18_19 < var3_3.length())
                    }
lbl-1000:
                    // 1 sources

                    {
                        var16_15.append((byte)var3_3.charAt(var18_19));
                        ++var18_19;
                        continue;
                    }
                }
                var16_15.append(0);
                var16_15.append(27).append(97).append(0);
                this.serial4610Device.write(var16_15.getBytes());
                this.chase();
            }
            catch (Exception var11_12) {
                if (this.getPrintingMode(var2_2).isTransaction()) {
                    this.getPrintingMode(var2_2).clearTransaction();
                }
                this.checkPrinterErrorCause(var1_1);
                if (var11_12 instanceof JposException) {
                    throw (JposException)var11_12;
                }
                throw new JposException(111);
            }
            Tracer.trace(4, "IBM4610POSPrinterImp", "processPrintBarCode()", "Exit");
        }
    }

    public void checkMode(int n, int n2) throws JposException {
        Tracer.trace(4, className, "checkMode(" + n + ", " + n2 + ")", "Entry");
        if (n2 == 2 || n2 == 16) {
            Tracer.trace(4, className, "checkMode()", "Exit");
            return;
        }
        throw new JposException(106);
    }

    public void clearMessages() throws JposException {
        Tracer.trace(4, className, "clearMessages()", "Entry");
        Object object = this.serial4610Device.getIOSemaphore();
        synchronized (object) {
            this.serial4610Device.write(new byte[]{27, 35, 2});
            if (this.printBitmapUtil != null) {
                this.printBitmapUtil.messageIndex = 1;
            }
            Tracer.trace(4, className, "clearMessages()", "Exit");
        }
    }

    public void doPrinting(int n, String string, String string2, byte[] byArray, int n2, int n3, boolean bl, boolean bl2, int n4) throws JposException {
    }

    public void downloadData(int n, String string, int n2, int n3) throws JposException {
        Tracer.trace(4, className, "downloadData(" + n + ", " + string + ", " + n2 + ", " + n3 + ")", "Entry");
        Object object = this.serial4610Device.getIOSemaphore();
        synchronized (object) {
            int n4 = string.indexOf("\u001bF");
            if (n4 > 0) {
                try {
                    string = new String(string.substring(0, n4));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            byte[] byArray = new byte[string.length()];
            int n5 = 0;
            while (n5 < byArray.length) {
                byArray[n5] = (byte)string.charAt(n5);
                ++n5;
            }
            ByteBuffer byteBuffer = new ByteBuffer();
            byteBuffer.append(29).append(58);
            byteBuffer.append(n3);
            byteBuffer.append(byArray);
            byteBuffer.append(29).append(58);
            this.serial4610Device.write(byteBuffer.getBytes());
            if (this.printBitmapUtil != null) {
                this.printBitmapUtil.cacheVector.setDownloaded(CacheVector.BITMAP, n, n3, true);
            }
            Tracer.trace(4, className, "downloadData()", "Exit");
        }
    }

    public void downloadData(int n, byte[] byArray, int n2, int n3) throws JposException {
        Tracer.trace(4, className, "downloadData(" + n + ", " + n2 + ", " + n3 + ")", "Entry");
        Object object = this.serial4610Device.getIOSemaphore();
        synchronized (object) {
            int n4;
            int n5;
            int n6 = byArray[1] & 0xFF;
            int n7 = byArray[2] & 0xFF;
            int n8 = n6 * 8 * n7 + 3;
            if (n == 2) {
                n5 = this.serviceState.getRecLineWidth() / 8;
                n4 = 255;
            } else {
                n5 = this.serviceState.getSlpLineWidth() / 8;
                n4 = 5;
            }
            Tracer.trace(4, className, "downloadData", "maxWidth: " + n5);
            Tracer.trace(4, className, "downloadData", "maxHeight: " + n4);
            Tracer.trace(4, className, "downloadData", "bitmap[1]: " + n6);
            Tracer.trace(4, className, "downloadData", "bitmap[2]: " + n7);
            Tracer.trace(4, className, "downloadData", "bitmapSize: " + n8);
            if (n8 > this.getMaxSetBitmapSize(n) || n6 > n5 || n7 > n4) {
                throw new JposException(114, 206);
            }
            this.doPrinting(n, byArray, n2, 16);
            if (this.printBitmapUtil != null) {
                this.printBitmapUtil.cacheVector.setDownloaded(CacheVector.BITMAP, n, n3, true);
            }
            Tracer.trace(4, className, "downloadData()", "Exit");
        }
    }

    public int getStationMaxBitmapHeight(int n) {
        Tracer.trace(4, className, "getStationMaxBitmapHeight(" + n + ")", "Entry");
        int n2 = 5;
        if (n == 2) {
            n2 = 255;
        }
        Tracer.trace(4, className, "getStationMaxBitmapHeight() = " + n2, "Exit");
        return n2;
    }

    public short getNextByteForStation(int n, PrintBitmapImageInfo printBitmapImageInfo) {
        short s = 0;
        s = n == 2 ? this.getNextByteForThermal(printBitmapImageInfo) : printBitmapImageInfo.getNextByteForImpact(printBitmapImageInfo);
        return s;
    }

    protected PrinterFont[] getPrinterFonts() throws JposException {
        Tracer.trace(4, className, "getPrinterFonts()", "Entry");
        PrinterFont[] printerFontArray = null;
        try {
            int n = ByteEncoder.getCodePage(this.serviceState.getCharacterSet());
            switch (n) {
                case 949: 
                case 951: 
                case 1088: {
                    printerFontArray = new PrinterFont[]{new PrinterFont(2, 38, 576, 1, 0, 34), new PrinterFont(4, 43, 474, 1, 1, 8)};
                    if (!this.serviceStateReset) {
                        this.serviceState.setRecLineChars(38);
                        this.serviceState.setSlpLineChars(43);
                        this.serviceStateReset = true;
                    }
                    break;
                }
                case 932: 
                case 950: 
                case 1381: {
                    printerFontArray = new PrinterFont[]{new PrinterFont(2, 38, 576, 10, 0, 34), new PrinterFont(2, 44, 576, 11, 0, 34), new PrinterFont(2, 48, 576, 12, 0, 34), new PrinterFont(4, 23, 474, 13, 0, 8), new PrinterFont(4, 24, 474, 14, 0, 8), new PrinterFont(4, 26, 474, 15, 0, 8), new PrinterFont(4, 27, 474, 16, 0, 8), new PrinterFont(4, 29, 474, 17, 0, 8)};
                    if (!this.serviceStateReset) {
                        this.serviceState.setRecLineChars(38);
                        this.serviceState.setSlpLineChars(24);
                        this.serviceStateReset = true;
                    }
                    break;
                }
                default: {
                    printerFontArray = new PrinterFont[]{new PrinterFont(2, 44, 576, 1, 0, 34), new PrinterFont(2, 34, 576, 2, 0, 34), new PrinterFont(2, 48, 576, 3, 0, 34), new PrinterFont(4, 47, 474, 1, 0, 8), new PrinterFont(4, 37, 474, 2, 0, 8), new PrinterFont(4, 52, 474, 3, 0, 8), new PrinterFont(4, 38, 384, 1, 1, 8), new PrinterFont(4, 30, 384, 2, 1, 8), new PrinterFont(4, 42, 384, 3, 1, 8)};
                    break;
                }
            }
        }
        catch (Exception exception) {
            this.checkPrinterErrorCause();
            throw this.createJposException(exception);
        }
        Tracer.trace(4, className, "getPrinterFonts()", "Exit");
        return printerFontArray;
    }

    public void processSetCharacterSet(SetCharacterSetData setCharacterSetData) throws JposException {
        Tracer.trace(4, className, "processSetCharacterSet()", "Entry");
        Object object = this.serial4610Device.getIOSemaphore();
        synchronized (object) {
            this.serviceStateReset = false;
            int n = setCharacterSetData.getCharacterSet();
            super.processSetCharacterSet(setCharacterSetData);
            try {
                int n2 = ByteEncoder.getCodePage(n);
                switch (n2) {
                    case 932: 
                    case 949: 
                    case 950: 
                    case 1381: {
                        Tracer.trace(4, className, "setCharacterSet()", "Code page is DBCS");
                        this.serviceState.setCapSlpLeft90(false);
                        this.serviceState.setSlpSidewaysMaxChars(0);
                        this.serviceState.setSlpSidewaysMaxLines(0);
                        break;
                    }
                    default: {
                        Tracer.trace(4, className, "setCharacterSet()", "Code page is SBCS");
                        this.serviceState.setCapSlpLeft90(true);
                        this.serviceState.setSlpSidewaysMaxChars(147);
                        this.serviceState.setSlpSidewaysMaxLines(17);
                        break;
                    }
                }
            }
            catch (Exception exception) {
                this.checkPrinterErrorCause();
                throw this.createJposException(exception);
            }
            Tracer.trace(4, className, "processSetCharacterSet()", "Exit");
        }
    }

    short getNextByteForThermal(PrintBitmapImageInfo printBitmapImageInfo) {
        int n = 0;
        if (printBitmapImageInfo.row >= printBitmapImageInfo.height) {
            n = 0;
            printBitmapImageInfo.col += 8L;
            if (printBitmapImageInfo.col >= printBitmapImageInfo.width) {
                if (printBitmapImageInfo.row % 8L == 7L) {
                    printBitmapImageInfo.done = true;
                } else {
                    printBitmapImageInfo.col = 0L;
                    ++printBitmapImageInfo.row;
                }
            }
        } else {
            int n2 = 0;
            while (n2 < 8) {
                int n3 = printBitmapImageInfo.pixels[(int)(printBitmapImageInfo.row * printBitmapImageInfo.width + printBitmapImageInfo.col)];
                n3 = n3 == -1 ? 1 : 0;
                n = n << 1 | n3;
                ++printBitmapImageInfo.col;
                if (printBitmapImageInfo.col == printBitmapImageInfo.width) {
                    n <<= 7 - n2;
                    n2 = 8;
                    if (printBitmapImageInfo.row == printBitmapImageInfo.height - 1L && printBitmapImageInfo.row % 8L == 7L) {
                        printBitmapImageInfo.done = true;
                    } else {
                        printBitmapImageInfo.col = 0L;
                        ++printBitmapImageInfo.row;
                    }
                }
                ++n2;
            }
        }
        return (short)n;
    }

    public byte[] getBitmapHeader(int n, int n2) {
        Tracer.trace(4, className, "getBitmapHeader(" + n + ", " + n2 + ")", "Entry");
        byte[] byArray = new byte[]{27, 42, (byte)n2, (byte)n, 1};
        return byArray;
    }

    public int getMaxBitmapWidth(int n) throws JposException {
        if (n == 2) {
            return 576;
        }
        return 472;
    }

    public int getMaxBitmapHeight(int n) throws JposException {
        if (n == 2) {
            return 2040;
        }
        return 40;
    }

    public int getMicronsPerStep(int n) {
        Tracer.trace(4, className, "getMicronsPerStep(" + n + ")", "Entry");
        int n2 = n == 2 ? 125 : (this.getPrintingMode(4).getRotation() != 258 ? 529 : 200);
        Tracer.trace(4, className, "getMicronsPerStep() = " + n2, "Exit");
        return n2;
    }

    public int getDotsPerInchHigh(int n) {
        Tracer.trace(4, className, "getDotsPerInchHigh(" + n + ")", "Entry");
        int n2 = 1;
        switch (n) {
            case 2: {
                n2 = 204;
                break;
            }
            case 4: {
                n2 = this.getPrintingMode(4).getRotation() != 258 ? 48 : 127;
            }
        }
        Tracer.trace(4, className, "getDotsPerInchHigh() = " + n2, "Exit");
        return n2;
    }

    public int getDotsPerInchWide(int n) throws JposException {
        int n2;
        Tracer.trace(4, className, "getDotsPerInchWide(" + n + ")", "Entry");
        switch (n) {
            case 2: {
                n2 = 203;
                break;
            }
            default: {
                n2 = 152;
            }
        }
        Tracer.trace(4, className, "getDotsPerInchWide() = " + n2, "Exit");
        return n2;
    }

    public int getMaxBytesPerWrite(int n) throws JposException {
        Tracer.trace(4, className, "getMaxBytesPerWrite(" + n + ")", "Entry");
        Tracer.trace(4, className, "getMaxBytesPerWrite() = 2000", "Exit");
        return 2000;
    }

    public int getWriteBufferSize() {
        Tracer.trace(4, className, "getWriteBufferSize()", "Entry");
        Tracer.trace(4, className, "getWriteBufferSize() = 2000", "Exit");
        return 2000;
    }

    public int getMaxSetBitmapSize(int n) throws JposException {
        int n2 = 65000;
        Tracer.trace(4, className, "getMaxSetBitmapSize() = " + n2, "Exit");
        return n2;
    }

    public int getMaxPrintBitmapSize() throws JposException {
        int n = this.getMaxBytesPerWrite(2);
        Tracer.trace(4, className, "getMaxPrintBitmapSize() = " + n, "Exit");
        return n;
    }

    public boolean requiresLinefeed(int n) {
        Tracer.trace(4, className, "requiresLineFeed(" + n + ")", "Entry");
        boolean bl = true;
        if (n == 2) {
            bl = false;
        }
        Tracer.trace(4, className, "requiresLineFeed() = " + bl, "Exit");
        return bl;
    }

    public void changePrintSide(int n) throws JposException {
        this.doDirectIOFlipCheck();
    }
}

