/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jpos.services.jcomm;

import com.ibm.jpos.services.DeviceServiceAbstraction;
import com.ibm.jpos.services.ToneIndicatorServiceState;
import com.ibm.jpos.services.jcomm.Serial4610Device;
import com.ibm.jpos.services.jcomm.Serial4610ToneIndicatorServiceImp;
import com.ibm.jpos.util.JposEventContainer;
import com.ibm.jpos.util.Tracer;
import java.util.Vector;
import jpos.JposException;
import jpos.events.ErrorEvent;
import jpos.events.JposEvent;
import jpos.events.OutputCompleteEvent;
import jpos.services.EventCallbacks;

public class IBM4610SSTToneIndicatorImp
extends Serial4610ToneIndicatorServiceImp {
    private Serial4610Device serial4610Device = this.getSerial4610Device();
    private ToneIndicatorServiceState serviceState = null;
    private Object eventSource = null;
    private ToneManager toneManager = null;
    private int outputIDCount = 0;
    private Object errorFlag = new Object();
    private static final int MAX_DURATION = 25400;
    private static final int TONE_DURATION_PAD = 100;
    private static final String className = "IBM4610SSTToneIndicatorImp";

    protected IBM4610SSTToneIndicatorImp(DeviceServiceAbstraction deviceServiceAbstraction) throws JposException {
        super(deviceServiceAbstraction);
        Tracer.trace(4, className, "Constructor", "Entry");
        this.serviceState = (ToneIndicatorServiceState)this.getDeviceServiceState();
        this.toneManager = new ToneManager();
        Tracer.trace(4, className, "Constructor", "Exit");
    }

    public void open(String string, EventCallbacks eventCallbacks) throws JposException {
        Tracer.trace(4, className, "open('" + string + "', " + eventCallbacks + ")", "Entry");
        super.open(string, eventCallbacks);
        this.eventSource = eventCallbacks.getEventSource();
        Tracer.trace(4, className, "open()", "Exit");
    }

    public void close() throws JposException {
        Tracer.trace(4, className, "close()", "Entry");
        try {
            this.toneManager.stop();
            super.close();
        }
        catch (Exception exception) {
            Tracer.trace(4, className, "close()", "exception is " + exception);
        }
        Tracer.trace(4, className, "close()", "Exit");
    }

    public synchronized void deleteImp() throws JposException {
        super.deleteImp();
    }

    public void setDeviceEnabled(boolean bl) throws JposException {
        super.setDeviceEnabled(bl);
    }

    public void clearOutput() throws JposException {
        Tracer.trace(4, className, "clearOutput()", "Entry");
        this.toneManager.clear();
        Tracer.trace(4, className, "clearOutput()", "Exit");
    }

    public void sound(int n, int n2) throws JposException {
        Tracer.trace(4, className, "sound()", "Entry");
        this.enqueueSound(n, n2, this.serviceState.getAsyncMode());
        Tracer.trace(4, className, "sound()", "Exit");
    }

    public void soundImmediate() throws JposException {
        Tracer.trace(4, className, "soundImmediate()", "Entry");
        this.clearOutput();
        this.enqueueSound(1, 0, false);
        Tracer.trace(4, className, "soundImmediate()", "Exit");
    }

    protected void enqueueSound(int n, int n2, boolean bl) throws JposException {
        Tracer.trace(4, className, "enqueueSound()", "Entry");
        if (!bl && n == -1) {
            throw new JposException(106);
        }
        SoundRequest soundRequest = new SoundRequest(n, n2, bl, this.serviceState.getTone1Duration(), this.serviceState.getTone1Pitch(), this.serviceState.getTone1Volume(), this.serviceState.getTone2Duration(), this.serviceState.getTone2Pitch(), this.serviceState.getTone2Volume(), this.serviceState.getInterToneWait());
        if (bl) {
            this.serviceState.setOutputID(soundRequest.outputID);
            this.toneManager.add(soundRequest);
        } else {
            if (this.serviceState.getState() == 3) {
                throw new JposException(113);
            }
            SoundRequest soundRequest2 = soundRequest;
            synchronized (soundRequest2) {
                this.toneManager.add(soundRequest);
                try {
                    soundRequest.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            if (soundRequest.errorCode != 0) {
                throw new JposException(soundRequest.errorCode);
            }
        }
        Tracer.trace(4, className, "enqueueSound()", "Exit");
    }

    private class POSSToneIndicatorErrorEvent
    implements JposEventContainer {
        private ErrorEvent errorEvent;

        public POSSToneIndicatorErrorEvent(int n) {
            this.errorEvent = new ErrorEvent(IBM4610SSTToneIndicatorImp.this.eventSource, n, 0, 1, 11);
        }

        public JposEvent getJposEvent() {
            return this.errorEvent;
        }

        public void prepareToFire() {
        }

        public void doneFiring() {
            Tracer.trace(4, IBM4610SSTToneIndicatorImp.className, "POSSToneIndicatorErrorEvent.doneFiring()", "notifying errorFlag");
            Object object = IBM4610SSTToneIndicatorImp.this.errorFlag;
            synchronized (object) {
                IBM4610SSTToneIndicatorImp.this.errorFlag.notify();
                Tracer.trace(4, IBM4610SSTToneIndicatorImp.className, "POSSToneIndicatorErrorEvent.doneFiring()", "notification complete");
            }
        }
    }

    private class ToneManager
    implements Runnable {
        private Vector requestQueue = new Vector();
        private Thread toneThread = new Thread(this);
        private boolean clearProcessed = false;

        private ToneManager() {
            this.toneThread.start();
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            Tracer.trace(4, IBM4610SSTToneIndicatorImp.className, "ToneManager.run()", "Entry");
            while (true) {
                Object object;
                SoundRequest soundRequest;
                Tracer.trace(4, IBM4610SSTToneIndicatorImp.className, "ToneManager.run()", "reading request queue");
                Vector vector = this.requestQueue;
                synchronized (vector) {
                    while (this.requestQueue.isEmpty()) {
                        try {
                            IBM4610SSTToneIndicatorImp.this.serviceState.setState(2);
                        }
                        catch (JposException jposException) {
                            // empty catch block
                        }
                        try {
                            this.requestQueue.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                    soundRequest = (SoundRequest)this.requestQueue.elementAt(0);
                    this.requestQueue.removeElementAt(0);
                }
                Tracer.trace(4, IBM4610SSTToneIndicatorImp.className, "ToneManager.run()", "request was read from queue");
                Tracer.trace(4, IBM4610SSTToneIndicatorImp.className, "ToneManager.run()", "request.errorCode == " + soundRequest.errorCode);
                if (soundRequest.errorCode == 101) {
                    Tracer.trace(4, IBM4610SSTToneIndicatorImp.className, "ToneManager.run()", "request.errorCode == JPOS_E_CLOSED; returning from run()");
                    return;
                }
                try {
                    IBM4610SSTToneIndicatorImp.this.serviceState.setState(3);
                }
                catch (JposException jposException) {
                    // empty catch block
                }
                if (soundRequest.errorCode == 0) {
                    Tracer.trace(4, IBM4610SSTToneIndicatorImp.className, "ToneManager.run()", "request.errorCode == JPOS_SUCCESS; processing...");
                    try {
                        object = IBM4610SSTToneIndicatorImp.this.serial4610Device.getIOSemaphore();
                        synchronized (object) {
                            this.clearProcessed = false;
                            int n = 0;
                            while (true) {
                                if (soundRequest.cycles != -1 && n >= soundRequest.cycles || this.clearProcessed) {
                                    if (this.clearProcessed) {
                                        // empty if block
                                    }
                                    break;
                                }
                                this.generateTone(soundRequest.tone1Duration, soundRequest.tone1Pitch, soundRequest.tone1Volume);
                                if (soundRequest.interToneWait > 0) {
                                    Thread.sleep(soundRequest.interToneWait);
                                }
                                this.generateTone(soundRequest.tone2Duration, soundRequest.tone2Pitch, soundRequest.tone2Volume);
                                if ((soundRequest.cycles == -1 || n < soundRequest.cycles - 1) && soundRequest.interSoundWait > 0) {
                                    Thread.sleep(soundRequest.interSoundWait);
                                }
                                ++n;
                            }
                        }
                    }
                    catch (InterruptedException interruptedException) {
                    }
                    catch (JposException jposException) {
                        soundRequest.errorCode = jposException.getErrorCode();
                    }
                    catch (Exception exception) {
                        Tracer.trace(4, IBM4610SSTToneIndicatorImp.className, "ToneManager.run()", "unexpected exception: " + exception.getMessage());
                    }
                }
                if (!soundRequest.async) {
                    if (soundRequest.errorCode == 114) {
                        soundRequest.errorCode = 111;
                    }
                    Tracer.trace(4, IBM4610SSTToneIndicatorImp.className, "ToneManager.run()", "notifying of synchronous request completion");
                    object = soundRequest;
                    synchronized (object) {
                        soundRequest.notify();
                    }
                    Tracer.trace(4, IBM4610SSTToneIndicatorImp.className, "ToneManager.run()", "notification complete");
                    continue;
                }
                if (soundRequest.errorCode == 114) continue;
                if (soundRequest.errorCode == 0) {
                    Tracer.trace(4, IBM4610SSTToneIndicatorImp.className, "ToneManager.run()", "posting OutputCompleteEvent");
                    object = new OutputCompleteEvent(IBM4610SSTToneIndicatorImp.this.eventSource, soundRequest.outputID);
                    try {
                        IBM4610SSTToneIndicatorImp.this.getEventQueueManager().postEvent((JposEvent)object);
                    }
                    catch (JposException jposException) {}
                    continue;
                }
                object = new POSSToneIndicatorErrorEvent(soundRequest.errorCode);
                Tracer.trace(4, IBM4610SSTToneIndicatorImp.className, "ToneManager.run()", "synchronizing on errorFlag");
                Object object2 = IBM4610SSTToneIndicatorImp.this.errorFlag;
                synchronized (object2) {
                    Tracer.trace(4, IBM4610SSTToneIndicatorImp.className, "ToneManager.run()", "posting ErrorEvent");
                    try {
                        IBM4610SSTToneIndicatorImp.this.getEventQueueManager().postEvent((JposEventContainer)object);
                    }
                    catch (JposException jposException) {
                        // empty catch block
                    }
                    try {
                        Tracer.trace(4, IBM4610SSTToneIndicatorImp.className, "ToneManager.run()", "waiting on errorFlag notification");
                        IBM4610SSTToneIndicatorImp.this.errorFlag.wait();
                        Tracer.trace(4, IBM4610SSTToneIndicatorImp.className, "ToneManager.run()", "wait satisfied");
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                int n = ((ErrorEvent)object.getJposEvent()).getErrorResponse();
                if (n == 12) {
                    Tracer.trace(4, IBM4610SSTToneIndicatorImp.className, "ToneManager.run()", "errorResponse == JPOS_ER_CLEAR");
                    try {
                        IBM4610SSTToneIndicatorImp.this.clearOutput();
                    }
                    catch (JposException jposException) {}
                    continue;
                }
                Tracer.trace(4, IBM4610SSTToneIndicatorImp.className, "ToneManager.run()", "errorResponse == JPOS_ER_RETRY");
                this.addToFront(soundRequest);
            }
        }

        void stop() {
            Tracer.trace(4, IBM4610SSTToneIndicatorImp.className, "ToneManager.stop()", "Entry");
            this.clear();
            SoundRequest soundRequest = new SoundRequest(0, 0, true, 0, 0, 0, 0, 0, 0, 0);
            soundRequest.errorCode = 101;
            this.addToFront(soundRequest);
            Tracer.trace(4, IBM4610SSTToneIndicatorImp.className, "ToneManager.stop()", "Exit");
        }

        void add(SoundRequest soundRequest) {
            Tracer.trace(4, IBM4610SSTToneIndicatorImp.className, "ToneManager.add()", "Entry");
            Vector vector = this.requestQueue;
            synchronized (vector) {
                this.requestQueue.addElement(soundRequest);
                this.requestQueue.notify();
            }
            Tracer.trace(4, IBM4610SSTToneIndicatorImp.className, "ToneManager.add()", "Exit");
        }

        void addToFront(SoundRequest soundRequest) {
            Tracer.trace(4, IBM4610SSTToneIndicatorImp.className, "ToneManager.addToFront()", "Entry");
            Vector vector = this.requestQueue;
            synchronized (vector) {
                this.requestQueue.insertElementAt(soundRequest, 0);
                this.requestQueue.notify();
            }
            Tracer.trace(4, IBM4610SSTToneIndicatorImp.className, "ToneManager.addToFront()", "Exit");
        }

        void clear() {
            Tracer.trace(4, IBM4610SSTToneIndicatorImp.className, "ToneManager.clear()", "Entry");
            Vector vector = this.requestQueue;
            synchronized (vector) {
                this.requestQueue.removeAllElements();
            }
            try {
                IBM4610SSTToneIndicatorImp.this.serviceState.setState(2);
            }
            catch (JposException jposException) {
                // empty catch block
            }
            this.clearProcessed = true;
            Tracer.trace(4, IBM4610SSTToneIndicatorImp.className, "ToneManager.clear()", "Exit");
        }

        private void generateTone(int n, int n2, int n3) throws JposException, InterruptedException {
            Tracer.trace(4, IBM4610SSTToneIndicatorImp.className, "ToneManager.generateTone()", "Entry");
            if (!IBM4610SSTToneIndicatorImp.this.isOnline()) {
                throw new JposException(108);
            }
            if (n2 > 0 && n3 > 0) {
                int n4 = n;
                while (n4 > 0) {
                    int n5 = n4 > 25400 ? 25400 : n4;
                    byte by = this.calcDurationSST(n5);
                    byte[] byArray = new byte[]{27, 7, by, this.calcN2(this.calcFreqSST(n2), n3)};
                    IBM4610SSTToneIndicatorImp.this.serial4610Device.write(byArray);
                    Thread.sleep((by & 0xFF) * 100 + 100);
                    n4 -= 25400;
                }
            } else {
                Thread.sleep(n);
            }
            Tracer.trace(4, IBM4610SSTToneIndicatorImp.className, "ToneManager.generateTone()", "Exit");
        }

        private void stopTone() throws JposException {
            Tracer.trace(4, IBM4610SSTToneIndicatorImp.className, "ToneManager.stopTone()", "Entry");
            IBM4610SSTToneIndicatorImp.this.serial4610Device.write(new byte[]{27, 7, 0, 47});
            Tracer.trace(4, IBM4610SSTToneIndicatorImp.className, "ToneManager.stopTone()", "Exit");
        }

        private byte calcDurationSST(int n) {
            return n < 100 ? (byte)1 : (byte)(n / 100);
        }

        private int calcFreqSST(int n) {
            int n2 = n;
            if (n < 261) {
                n2 = 261;
            } else if (n > 3953) {
                n2 = 3953;
            }
            return n2;
        }

        private byte calcN2(int n, int n2) {
            double d = 1.0595;
            int n3 = 0;
            double d2 = n;
            while (d2 > 261.7) {
                d2 /= d;
                ++n3;
            }
            int n4 = n3 / 12;
            int n5 = n3 % 12;
            int n6 = n2 < 50 ? 1 : 0;
            int n7 = n5 + n4 * 16 + n6 * 128;
            return (byte)n7;
        }
    }

    private class SoundRequest {
        int cycles;
        int interSoundWait;
        boolean async;
        int tone1Duration;
        int tone1Pitch;
        int tone1Volume;
        int tone2Duration;
        int tone2Pitch;
        int tone2Volume;
        int interToneWait;
        int outputID;
        int errorCode = 0;

        private SoundRequest(int n, int n2, boolean bl, int n3, int n4, int n5, int n6, int n7, int n8, int n9) {
            this.cycles = n;
            this.interSoundWait = n2;
            this.async = bl;
            this.tone1Duration = n3;
            this.tone1Pitch = n4;
            this.tone1Volume = n5;
            this.tone2Duration = n6;
            this.tone2Pitch = n7;
            this.tone2Volume = n8;
            this.interToneWait = n9;
            this.outputID = ++IBM4610SSTToneIndicatorImp.this.outputIDCount;
        }
    }
}

