/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jpos.services.poss;

import com.ibm.jpos.services.DeviceServiceAbstraction;
import com.ibm.jpos.services.ScannerServiceImp;
import com.ibm.jpos.services.ScannerServiceState;
import com.ibm.jpos.services.poss.POSSDeviceServiceImp;
import com.ibm.jpos.util.BooleanMonitor;
import com.ibm.jpos.util.JposEventContainer;
import com.ibm.jpos.util.Tracer;
import com.ibm.poss.Errno;
import com.ibm.poss.PosDef;
import com.ibm.poss.PosDevice;
import com.ibm.poss.PosException;
import com.ibm.poss.PosScannerDataHdr;
import com.ibm.poss.PosmScanDataAvailListener;
import com.ibm.poss.Scanner;
import java.util.Enumeration;
import jpos.JposException;
import jpos.ScannerConst;
import jpos.config.JposEntry;
import jpos.events.DataEvent;
import jpos.events.ErrorEvent;
import jpos.events.JposEvent;
import jpos.services.EventCallbacks;

public abstract class POSSScannerServiceImp
extends POSSDeviceServiceImp
implements ScannerServiceImp,
Errno,
PosDef,
Scanner {
    private static final String className = "POSSScannerServiceImp";
    private ScannerServiceState serviceState = (ScannerServiceState)this.getDeviceServiceState();
    private Object eventSource = null;
    private PosDevice posDevice = this.getPosDevice();
    private boolean scanAheadEnabled = true;
    private long disableTimeMillis = 0L;
    private long maxDisableTimeMillis = 150L;

    protected POSSScannerServiceImp(DeviceServiceAbstraction deviceServiceAbstraction) throws JposException {
        super(deviceServiceAbstraction);
        this.posDevice.setPosmScanDataAvailListener(new PosDeviceListener());
    }

    public void setDeviceEnabled(boolean bl) throws JposException {
        super.setDeviceEnabled(bl);
        if (!bl) {
            this.disableTimeMillis = System.currentTimeMillis();
        }
    }

    public void setAutoDisable(boolean bl) throws JposException {
    }

    public void setDataEventEnabled(boolean bl) throws JposException {
    }

    public void setDecodeData(boolean bl) throws JposException {
    }

    public void open(String string, EventCallbacks eventCallbacks) throws JposException {
        Tracer.trace(4, className, "open", "Entry");
        super.open(string, eventCallbacks);
        this.eventSource = eventCallbacks.getEventSource();
        JposEntry jposEntry = this.getJposEntry();
        Enumeration enumeration = jposEntry.getPropertyNames();
        while (enumeration.hasMoreElements()) {
            String string2;
            String string3 = (String)enumeration.nextElement();
            if (string3.equalsIgnoreCase("scanAheadEnabled")) {
                string2 = jposEntry.getPropertyValue(string3).toString();
                if (!string2.equalsIgnoreCase("false") && !string2.equalsIgnoreCase("no") && !string2.equalsIgnoreCase("off")) continue;
                this.scanAheadEnabled = false;
                Tracer.trace(4, className, "open", "scanAheadEnabled == " + (this.scanAheadEnabled ? "true" : "false"));
                continue;
            }
            if (!string3.equalsIgnoreCase("maxDisableTimeMillis")) continue;
            string2 = jposEntry.getPropertyValue(string3).toString();
            try {
                this.maxDisableTimeMillis = Long.parseLong(string2);
                Tracer.trace(4, className, "open", "maxDisableTimeMillis == " + Long.toString(this.maxDisableTimeMillis));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        Tracer.trace(4, className, "open", "Exit");
    }

    public synchronized void deleteImp() throws JposException {
        Tracer.trace(4, className, "deleteImp()", "Entry");
        super.deleteImp();
        this.posDevice.setPosmScanDataAvailListener(null);
        Tracer.trace(4, className, "deleteImp()", "Exit");
    }

    public void clearInput() throws JposException {
        try {
            this.posDevice.ioctl(5701);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected String getPOSSDeviceClass() {
        return "PosScanner";
    }

    protected final boolean isLockableDevice() {
        return true;
    }

    private class POSSScannerErrorEvent
    implements JposEventContainer,
    ScannerConst {
        private ErrorEvent errorEvent = null;
        private BooleanMonitor complete = new BooleanMonitor(false);

        public POSSScannerErrorEvent(Object object, int n, int n2, int n3, int n4) {
            this.errorEvent = new ErrorEvent(object, n, n2, n3, n4);
        }

        public JposEvent getJposEvent() {
            return this.errorEvent;
        }

        public void prepareToFire() {
        }

        public void doneFiring() {
            if (this.errorEvent.getErrorResponse() == 12) {
                try {
                    POSSScannerServiceImp.this.posDevice.ioctl(5701);
                }
                catch (PosException posException) {
                    // empty catch block
                }
            }
            this.complete.set(true);
        }

        public void waitUntilDoneFiring() {
            try {
                this.complete.waitFor(true);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private class POSSScannerDataEvent
    implements JposEventContainer,
    ScannerConst {
        private ScannerServiceState serviceState = null;
        private DataEvent dataEvent = null;
        private byte[] scanData = new byte[0];
        private byte[] scanDataLabel = new byte[0];
        private int scanDataType = 0;

        public POSSScannerDataEvent(byte[] byArray, int n, ScannerServiceState scannerServiceState) {
            this.serviceState = scannerServiceState;
            this.dataEvent = new DataEvent(POSSScannerServiceImp.this.eventSource, 0);
            PosScannerDataHdr posScannerDataHdr = new PosScannerDataHdr(byArray, n);
            switch (posScannerDataHdr.getLblType()) {
                case 524288: {
                    this.scanDataType = 107;
                    break;
                }
                case 262144: {
                    this.scanDataType = 108;
                    break;
                }
                case 131072: {
                    this.scanDataType = 109;
                    break;
                }
                case 65536: {
                    this.scanDataType = 110;
                    break;
                }
                case 8192: {
                    this.scanDataType = 103;
                    break;
                }
                case 8193: 
                case 8194: 
                case 8208: {
                    this.scanDataType = 118;
                    break;
                }
                case 4096: {
                    this.scanDataType = 104;
                    break;
                }
                case 4097: 
                case 4098: {
                    this.scanDataType = 119;
                    break;
                }
                case 8: {
                    this.scanDataType = 106;
                    break;
                }
                case 4: {
                    this.scanDataType = 105;
                    break;
                }
                case 32768: {
                    this.scanDataType = 101;
                    break;
                }
                case 32769: 
                case 32770: 
                case 32784: {
                    this.scanDataType = 111;
                    break;
                }
                case 2048: {
                    this.scanDataType = 113;
                    break;
                }
                case 1024: {
                    this.scanDataType = 114;
                    break;
                }
                case 512: {
                    this.scanDataType = 115;
                    break;
                }
                case 256: {
                    this.scanDataType = 116;
                    break;
                }
                case 128: {
                    this.scanDataType = 117;
                    break;
                }
                case 16384: {
                    this.scanDataType = 102;
                    break;
                }
                case 16385: 
                case 16386: 
                case 16400: {
                    this.scanDataType = 112;
                    break;
                }
                default: {
                    this.scanDataType = 0;
                }
            }
            this.scanData = new byte[posScannerDataHdr.getLblLen()];
            this.scanDataLabel = this.scanData;
            System.arraycopy(byArray, n + posScannerDataHdr.getHdrLen(), this.scanData, 0, this.scanData.length);
        }

        public JposEvent getJposEvent() {
            return this.dataEvent;
        }

        public void prepareToFire() {
            ScannerServiceState scannerServiceState = this.serviceState;
            synchronized (scannerServiceState) {
                try {
                    this.serviceState.setScanData(this.scanData);
                    if (this.serviceState.getDecodeData()) {
                        this.serviceState.setScanDataLabel(this.scanDataLabel);
                        this.serviceState.setScanDataType(this.scanDataType);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        public void doneFiring() {
            if (!POSSScannerServiceImp.this.scanAheadEnabled && this.serviceState.getDeviceEnabled()) {
                try {
                    POSSScannerServiceImp.this.posDevice.ioctl(306);
                }
                catch (PosException posException) {
                    // empty catch block
                }
            }
        }
    }

    private class PosDeviceListener
    implements PosmScanDataAvailListener {
        private PosDeviceListener() {
        }

        public void posmScanDataAvail(short n) {
            POSSScannerErrorEvent pOSSScannerErrorEvent = null;
            if (Tracer.getTraceLevel() >= 4) {
                Tracer.trace(4, POSSScannerServiceImp.className, "posmScanDataAvail(" + Integer.toString(n) + ")", "Entry");
            }
            boolean bl = POSSScannerServiceImp.this.serviceState.getDeviceEnabled();
            boolean bl2 = POSSScannerServiceImp.this.serviceState.getAutoDisable();
            if (!POSSScannerServiceImp.this.scanAheadEnabled || !bl || bl2) {
                try {
                    POSSScannerServiceImp.this.posDevice.ioctl(303);
                }
                catch (PosException posException) {
                    // empty catch block
                }
            }
            if (!bl && System.currentTimeMillis() - POSSScannerServiceImp.this.disableTimeMillis > POSSScannerServiceImp.this.maxDisableTimeMillis) {
                Tracer.trace(4, POSSScannerServiceImp.className, "posmScanDataAvail()", "ERROR: Event received from disabled device");
                pOSSScannerErrorEvent = new POSSScannerErrorEvent(POSSScannerServiceImp.this.eventSource, 111, 0, 2, 12);
            } else {
                byte[] byArray = new byte[n];
                try {
                    Tracer.trace(4, POSSScannerServiceImp.className, "posmScanDataAvail()", "Reading " + Integer.toString(n) + "bytes");
                    int n2 = POSSScannerServiceImp.this.posDevice.read(byArray);
                    if (n2 != n) {
                        Tracer.trace(4, POSSScannerServiceImp.className, "posmScanDataAvail()", "ERROR: Short read. bytesRead == " + Integer.toString(n2));
                        pOSSScannerErrorEvent = new POSSScannerErrorEvent(POSSScannerServiceImp.this.eventSource, 111, 0, 2, 12);
                    }
                }
                catch (PosException posException) {
                    if (posException.getErrorCode() == 317) {
                        Tracer.trace(4, POSSScannerServiceImp.className, "posmScanDataAvail()", "ERROR: Device offline");
                        pOSSScannerErrorEvent = new POSSScannerErrorEvent(POSSScannerServiceImp.this.eventSource, 108, 0, 2, 12);
                    }
                    Tracer.trace(4, POSSScannerServiceImp.className, "posmScanDataAvail()", "ERROR: " + posException.getMessage());
                    pOSSScannerErrorEvent = new POSSScannerErrorEvent(POSSScannerServiceImp.this.eventSource, 111, 0, 2, 12);
                }
                if (pOSSScannerErrorEvent == null) {
                    PosScannerDataHdr posScannerDataHdr = null;
                    short s = 0;
                    int n3 = 0;
                    while (n3 < n) {
                        try {
                            posScannerDataHdr = new PosScannerDataHdr(byArray, n3);
                        }
                        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                            Tracer.trace(4, POSSScannerServiceImp.className, "posmScanDataAvail()", "ERROR: Array index out of bounds");
                            pOSSScannerErrorEvent = new POSSScannerErrorEvent(POSSScannerServiceImp.this.eventSource, 111, 0, 2, 12);
                            break;
                        }
                        s = posScannerDataHdr.getFlags();
                        if ((s & 0xC) != 0) {
                            Tracer.trace(4, POSSScannerServiceImp.className, "posmScanDataAvail()", "ERROR: POS_SCAN_PARTIAL_LABEL or POS_SCAN_LABEL_READ_ERROR");
                            pOSSScannerErrorEvent = new POSSScannerErrorEvent(POSSScannerServiceImp.this.eventSource, 111, 0, 2, 12);
                            break;
                        }
                        try {
                            POSSScannerServiceImp.this.getEventQueueManager().postEvent(new POSSScannerDataEvent(byArray, n3, POSSScannerServiceImp.this.serviceState));
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        n3 += posScannerDataHdr.getHdrLen() + posScannerDataHdr.getLblLen();
                    }
                }
            }
            if (pOSSScannerErrorEvent != null) {
                if (POSSScannerServiceImp.this.scanAheadEnabled && bl && !bl2) {
                    try {
                        POSSScannerServiceImp.this.posDevice.ioctl(303);
                    }
                    catch (PosException posException) {
                        // empty catch block
                    }
                }
                try {
                    POSSScannerServiceImp.this.getEventQueueManager().postEvent(pOSSScannerErrorEvent);
                    pOSSScannerErrorEvent.waitUntilDoneFiring();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (bl) {
                    try {
                        POSSScannerServiceImp.this.posDevice.ioctl(306);
                    }
                    catch (PosException posException) {
                        // empty catch block
                    }
                }
            }
            Tracer.trace(4, POSSScannerServiceImp.className, "posmScanDataAvail()", "Exit");
        }
    }
}

