/*
 * Decompiled with CFR 0.152.
 */
package de.ailis.usb4java;

import de.ailis.usb4java.AbstractDevice;
import de.ailis.usb4java.DeviceListenerList;
import de.ailis.usb4java.Port;
import de.ailis.usb4java.Ports;
import de.ailis.usb4java.RootHubConfiguration;
import de.ailis.usb4java.UsbPorts;
import de.ailis.usb4java.descriptors.SimpleUsbDeviceDescriptor;
import java.util.ArrayList;
import java.util.List;
import javax.usb.UsbConfiguration;
import javax.usb.UsbConst;
import javax.usb.UsbControlIrp;
import javax.usb.UsbDeviceDescriptor;
import javax.usb.UsbException;
import javax.usb.UsbHub;
import javax.usb.UsbPort;
import javax.usb.UsbStringDescriptor;
import javax.usb.event.UsbDeviceListener;
import javax.usb.util.DefaultUsbControlIrp;

final class RootHub
implements UsbHub,
UsbPorts<Port, AbstractDevice> {
    private static final String MANUFACTURER = "usb4java";
    private static final String PRODUCT = "root hub";
    private static final String SERIAL_NUMBER = "1.0.0";
    private final List<UsbConfiguration> configurations = new ArrayList<UsbConfiguration>(1);
    private final UsbDeviceDescriptor descriptor = new SimpleUsbDeviceDescriptor(18, 1, 257, 9, 0, 0, 8, -1, -1, 0, 1, 2, 3, 1);
    private final DeviceListenerList listeners = new DeviceListenerList();
    private final Ports rootPorts = new Ports(this);

    RootHub() {
        this.configurations.add(new RootHubConfiguration(this));
    }

    @Override
    public UsbPort getParentUsbPort() {
        return null;
    }

    @Override
    public boolean isUsbHub() {
        return true;
    }

    @Override
    public String getManufacturerString() {
        return MANUFACTURER;
    }

    @Override
    public String getSerialNumberString() {
        return SERIAL_NUMBER;
    }

    @Override
    public String getProductString() {
        return PRODUCT;
    }

    @Override
    public Object getSpeed() {
        return UsbConst.DEVICE_SPEED_UNKNOWN;
    }

    @Override
    public List<UsbConfiguration> getUsbConfigurations() {
        return this.configurations;
    }

    @Override
    public UsbConfiguration getUsbConfiguration(byte number) {
        if (number != 1) {
            return null;
        }
        return this.configurations.get(0);
    }

    @Override
    public boolean containsUsbConfiguration(byte number) {
        return number == 1;
    }

    @Override
    public byte getActiveUsbConfigurationNumber() {
        return 1;
    }

    @Override
    public UsbConfiguration getActiveUsbConfiguration() {
        return this.configurations.get(0);
    }

    @Override
    public boolean isConfigured() {
        return true;
    }

    @Override
    public UsbDeviceDescriptor getUsbDeviceDescriptor() {
        return this.descriptor;
    }

    @Override
    public UsbStringDescriptor getUsbStringDescriptor(byte index) throws UsbException {
        throw new UsbException("Can't get USB string descriptor from virtual device");
    }

    @Override
    public String getString(byte index) throws UsbException {
        throw new UsbException("Can't get string from virtual device");
    }

    @Override
    public void syncSubmit(UsbControlIrp irp) throws UsbException {
        throw new UsbException("Can't syncSubmit on virtual device");
    }

    @Override
    public void asyncSubmit(UsbControlIrp irp) throws UsbException {
        throw new UsbException("Can't asyncSubmit on virtual device");
    }

    @Override
    public void syncSubmit(List list) throws UsbException {
        throw new UsbException("Can't syncSubmit on virtual device");
    }

    @Override
    public void asyncSubmit(List list) throws UsbException {
        throw new UsbException("Can't asyncSubmit on virtual device");
    }

    @Override
    public UsbControlIrp createUsbControlIrp(byte bmRequestType, byte bRequest, short wValue, short wIndex) {
        return new DefaultUsbControlIrp(bmRequestType, bRequest, wValue, wIndex);
    }

    @Override
    public void addUsbDeviceListener(UsbDeviceListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeUsbDeviceListener(UsbDeviceListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public byte getNumberOfPorts() {
        return this.rootPorts.getNumberOfPorts();
    }

    @Override
    public List<Port> getUsbPorts() {
        return this.rootPorts.getUsbPorts();
    }

    @Override
    public Port getUsbPort(byte number) {
        return this.rootPorts.getUsbPort(number);
    }

    @Override
    public List<AbstractDevice> getAttachedUsbDevices() {
        return this.rootPorts.getAttachedUsbDevices();
    }

    @Override
    public boolean isUsbDeviceAttached(AbstractDevice device) {
        return this.rootPorts.isUsbDeviceAttached(device);
    }

    @Override
    public boolean isRootUsbHub() {
        return true;
    }

    @Override
    public void connectUsbDevice(AbstractDevice device) {
        this.rootPorts.connectUsbDevice(device);
    }

    @Override
    public void disconnectUsbDevice(AbstractDevice device) {
        this.rootPorts.disconnectUsbDevice(device);
    }

    public String toString() {
        return this.getManufacturerString() + " " + this.getProductString() + " " + this.getSerialNumberString();
    }
}

